/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.AbstractDoCoMoResultParser;
import com.google.zxing.client.result.EmailAddressParsedResult;

final class EmailDoCoMoResultParser
extends AbstractDoCoMoResultParser {
    private static final char[] ATEXT_SYMBOLS = new char[]{'@', '.', '!', '#', '$', '%', '&', '\'', '*', '+', '-', '/', '=', '?', '^', '_', '`', '{', '|', '}', '~'};

    EmailDoCoMoResultParser() {
    }

    public static EmailAddressParsedResult parse(Result result) {
        String string = result.getText();
        if (string == null || !string.startsWith("MATMSG:")) {
            return null;
        }
        String[] stringArray = EmailDoCoMoResultParser.matchDoCoMoPrefixedField("TO:", string, true);
        if (stringArray == null) {
            return null;
        }
        String string2 = stringArray[0];
        if (!EmailDoCoMoResultParser.isBasicallyValidEmailAddress(string2)) {
            return null;
        }
        String string3 = EmailDoCoMoResultParser.matchSingleDoCoMoPrefixedField("SUB:", string, false);
        String string4 = EmailDoCoMoResultParser.matchSingleDoCoMoPrefixedField("BODY:", string, false);
        return new EmailAddressParsedResult(string2, string3, string4, "mailto:" + string2);
    }

    static boolean isBasicallyValidEmailAddress(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || EmailDoCoMoResultParser.isAtextSymbol(c))) {
                return false;
            }
            if (c != '@') continue;
            if (bl) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    private static boolean isAtextSymbol(char c) {
        for (int i = 0; i < ATEXT_SYMBOLS.length; ++i) {
            if (c != ATEXT_SYMBOLS[i]) continue;
            return true;
        }
        return false;
    }
}

