/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.client.result.ProductParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.oned.UPCEReader;

final class ProductResultParser
extends ResultParser {
    private ProductResultParser() {
    }

    public static ProductParsedResult parse(Result result) {
        BarcodeFormat barcodeFormat = result.getBarcodeFormat();
        if (!(BarcodeFormat.UPC_A.equals(barcodeFormat) || BarcodeFormat.UPC_E.equals(barcodeFormat) || BarcodeFormat.EAN_8.equals(barcodeFormat) || BarcodeFormat.EAN_13.equals(barcodeFormat))) {
            return null;
        }
        String string = result.getText();
        if (string == null) {
            return null;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return null;
        }
        String string2 = BarcodeFormat.UPC_E.equals(barcodeFormat) ? UPCEReader.convertUPCEtoUPCA(string) : string;
        return new ProductParsedResult(string, string2);
    }
}

