/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ParsedResultType;

public final class URIParsedResult
extends ParsedResult {
    private final String uri;
    private final String title;

    public URIParsedResult(String string, String string2) {
        super(ParsedResultType.URI);
        this.uri = URIParsedResult.massageURI(string);
        this.title = string2;
    }

    public String getURI() {
        return this.uri;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isPossiblyMaliciousURI() {
        return this.containsUser();
    }

    private boolean containsUser() {
        int n;
        int n2 = this.uri.indexOf(58);
        ++n2;
        int n3 = this.uri.length();
        while (n2 < n3 && this.uri.charAt(n2) == '/') {
            ++n2;
        }
        int n4 = this.uri.indexOf(47, n2);
        if (n4 < 0) {
            n4 = n3;
        }
        return (n = this.uri.indexOf(64, n2)) >= n2 && n < n4;
    }

    public String getDisplayResult() {
        StringBuffer stringBuffer = new StringBuffer(30);
        URIParsedResult.maybeAppend(this.title, stringBuffer);
        URIParsedResult.maybeAppend(this.uri, stringBuffer);
        return stringBuffer.toString();
    }

    private static String massageURI(String string) {
        int n = string.indexOf(58);
        string = n < 0 ? "http://" + string : (URIParsedResult.isColonFollowedByPortNumber(string, n) ? "http://" + string : string.substring(0, n).toLowerCase() + string.substring(n));
        return string;
    }

    private static boolean isColonFollowedByPortNumber(String string, int n) {
        int n2 = string.indexOf(47, n + 1);
        if (n2 < 0) {
            n2 = string.length();
        }
        if (n2 <= n + 1) {
            return false;
        }
        for (int i = n + 1; i < n2; ++i) {
            if (string.charAt(i) >= '0' && string.charAt(i) <= '9') continue;
            return false;
        }
        return true;
    }
}

