/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.client.result.URIParsedResult;

final class URIResultParser
extends ResultParser {
    private URIResultParser() {
    }

    public static URIParsedResult parse(Result result) {
        String string = result.getText();
        if (string != null && string.startsWith("URL:")) {
            string = string.substring(4);
        }
        if (!URIResultParser.isBasicallyValidURI(string)) {
            return null;
        }
        return new URIParsedResult(string, null);
    }

    static boolean isBasicallyValidURI(String string) {
        block8: {
            if (string == null || string.indexOf(32) >= 0 || string.indexOf(10) >= 0) {
                return false;
            }
            int n = string.indexOf(46);
            if (n >= string.length() - 2) {
                return false;
            }
            int n2 = string.indexOf(58);
            if (n < 0 && n2 < 0) {
                return false;
            }
            if (n2 < 0) break block8;
            if (n < 0 || n > n2) {
                for (int i = 0; i < n2; ++i) {
                    char c = string.charAt(i);
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
                    return false;
                }
            } else {
                if (n2 >= string.length() - 2) {
                    return false;
                }
                for (int i = n2 + 1; i < n2 + 3; ++i) {
                    char c = string.charAt(i);
                    if (c >= '0' && c <= '9') continue;
                    return false;
                }
            }
        }
        return true;
    }
}

