/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.AddressBookParsedResult;
import com.google.zxing.client.result.ResultParser;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

final class VCardResultParser
extends ResultParser {
    private VCardResultParser() {
    }

    public static AddressBookParsedResult parse(Result result) {
        String string = result.getText();
        if (string == null || !string.startsWith("BEGIN:VCARD")) {
            return null;
        }
        String[] stringArray = VCardResultParser.matchVCardPrefixedField("FN", string, true);
        if (stringArray == null) {
            stringArray = VCardResultParser.matchVCardPrefixedField("N", string, true);
            VCardResultParser.formatNames(stringArray);
        }
        String[] stringArray2 = VCardResultParser.matchVCardPrefixedField("TEL", string, true);
        String[] stringArray3 = VCardResultParser.matchVCardPrefixedField("EMAIL", string, true);
        String string2 = VCardResultParser.matchSingleVCardPrefixedField("NOTE", string, false);
        String[] stringArray4 = VCardResultParser.matchVCardPrefixedField("ADR", string, true);
        if (stringArray4 != null) {
            for (int i = 0; i < stringArray4.length; ++i) {
                stringArray4[i] = VCardResultParser.formatAddress(stringArray4[i]);
            }
        }
        String string3 = VCardResultParser.matchSingleVCardPrefixedField("ORG", string, true);
        String string4 = VCardResultParser.matchSingleVCardPrefixedField("BDAY", string, true);
        if (!VCardResultParser.isLikeVCardDate(string4)) {
            string4 = null;
        }
        String string5 = VCardResultParser.matchSingleVCardPrefixedField("TITLE", string, true);
        String string6 = VCardResultParser.matchSingleVCardPrefixedField("URL", string, true);
        return new AddressBookParsedResult(stringArray, null, stringArray2, stringArray3, string2, stringArray4, string3, string4, string5, string6);
    }

    private static String[] matchVCardPrefixedField(String string, String string2, boolean bl) {
        Vector<String> vector = null;
        int n = 0;
        int n2 = string2.length();
        while (n < n2 && (n = string2.indexOf(string, n)) >= 0) {
            String string3;
            int n3;
            if (n > 0 && string2.charAt(n - 1) != '\n') {
                ++n;
                continue;
            }
            if (string2.charAt(n += string.length()) != ':' && string2.charAt(n) != ';') continue;
            int n4 = n;
            while (string2.charAt(n) != ':') {
                ++n;
            }
            boolean bl2 = false;
            String string4 = null;
            if (n > n4) {
                for (n3 = n4 + 1; n3 <= n; ++n3) {
                    if (string2.charAt(n3) != ';' && string2.charAt(n3) != ':') continue;
                    string3 = string2.substring(n4 + 1, n3);
                    int n5 = string3.indexOf(61);
                    if (n5 >= 0) {
                        String string5 = string3.substring(0, n5);
                        String string6 = string3.substring(n5 + 1);
                        if (string5.equalsIgnoreCase("ENCODING")) {
                            if (string6.equalsIgnoreCase("QUOTED-PRINTABLE")) {
                                bl2 = true;
                            }
                        } else if (string5.equalsIgnoreCase("CHARSET")) {
                            string4 = string6;
                        }
                    }
                    n4 = n3;
                }
            }
            n3 = ++n;
            while ((n = string2.indexOf(10, n)) >= 0) {
                if (n < string2.length() - 1 && (string2.charAt(n + 1) == ' ' || string2.charAt(n + 1) == '\t')) {
                    n += 2;
                    continue;
                }
                if (!bl2 || string2.charAt(n - 1) != '=' && string2.charAt(n - 2) != '=') break;
                ++n;
            }
            if (n < 0) {
                n = n2;
                continue;
            }
            if (n > n3) {
                if (vector == null) {
                    vector = new Vector<String>(1);
                }
                if (string2.charAt(n - 1) == '\r') {
                    --n;
                }
                string3 = string2.substring(n3, n);
                if (bl) {
                    string3 = string3.trim();
                }
                string3 = bl2 ? VCardResultParser.decodeQuotedPrintable(string3, string4) : VCardResultParser.stripContinuationCRLF(string3);
                vector.addElement(string3);
                ++n;
                continue;
            }
            ++n;
        }
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        return VCardResultParser.toStringArray(vector);
    }

    private static String stripContinuationCRLF(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = false;
        block4: for (int i = 0; i < n; ++i) {
            if (bl) {
                bl = false;
                continue;
            }
            char c = string.charAt(i);
            bl = false;
            switch (c) {
                case '\n': {
                    bl = true;
                    continue block4;
                }
                case '\r': {
                    continue block4;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String decodeQuotedPrintable(String string, String string2) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    continue block6;
                }
                case '=': {
                    char c2;
                    if (i >= n - 2 || (c2 = string.charAt(i + 1)) == '\r' || c2 == '\n') continue block6;
                    char c3 = string.charAt(i + 2);
                    try {
                        int n2 = 16 * VCardResultParser.toHexValue(c2) + VCardResultParser.toHexValue(c3);
                        byteArrayOutputStream.write(n2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    i += 2;
                    continue block6;
                }
                default: {
                    VCardResultParser.maybeAppendFragment(byteArrayOutputStream, string2, stringBuffer);
                    stringBuffer.append(c);
                }
            }
        }
        VCardResultParser.maybeAppendFragment(byteArrayOutputStream, string2, stringBuffer);
        return stringBuffer.toString();
    }

    private static int toHexValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException();
    }

    private static void maybeAppendFragment(ByteArrayOutputStream byteArrayOutputStream, String string, StringBuffer stringBuffer) {
        if (byteArrayOutputStream.size() > 0) {
            String string2;
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (string == null) {
                string2 = new String(byArray);
            } else {
                try {
                    string2 = new String(byArray, string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string2 = new String(byArray);
                }
            }
            byteArrayOutputStream.reset();
            stringBuffer.append(string2);
        }
    }

    static String matchSingleVCardPrefixedField(String string, String string2, boolean bl) {
        String[] stringArray = VCardResultParser.matchVCardPrefixedField(string, string2, bl);
        return stringArray == null ? null : stringArray[0];
    }

    private static boolean isLikeVCardDate(String string) {
        if (string == null) {
            return true;
        }
        if (VCardResultParser.isStringOfDigits(string, 8)) {
            return true;
        }
        return string.length() == 10 && string.charAt(4) == '-' && string.charAt(7) == '-' && VCardResultParser.isSubstringOfDigits(string, 0, 4) && VCardResultParser.isSubstringOfDigits(string, 5, 2) && VCardResultParser.isSubstringOfDigits(string, 8, 2);
    }

    private static String formatAddress(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ';') {
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString().trim();
    }

    private static void formatNames(String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                String string = stringArray[i];
                String[] stringArray2 = new String[5];
                int n2 = 0;
                int n3 = 0;
                while ((n = string.indexOf(59, n2)) > 0) {
                    stringArray2[n3] = string.substring(n2, n);
                    ++n3;
                    n2 = n + 1;
                }
                stringArray2[n3] = string.substring(n2);
                StringBuffer stringBuffer = new StringBuffer(100);
                VCardResultParser.maybeAppendComponent(stringArray2, 3, stringBuffer);
                VCardResultParser.maybeAppendComponent(stringArray2, 1, stringBuffer);
                VCardResultParser.maybeAppendComponent(stringArray2, 2, stringBuffer);
                VCardResultParser.maybeAppendComponent(stringArray2, 0, stringBuffer);
                VCardResultParser.maybeAppendComponent(stringArray2, 4, stringBuffer);
                stringArray[i] = stringBuffer.toString().trim();
            }
        }
    }

    private static void maybeAppendComponent(String[] stringArray, int n, StringBuffer stringBuffer) {
        if (stringArray[n] != null) {
            stringBuffer.append(' ');
            stringBuffer.append(stringArray[n]);
        }
    }
}

