/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.reedsolomon;

import com.google.zxing.common.reedsolomon.GF256;
import com.google.zxing.common.reedsolomon.GF256Poly;
import com.google.zxing.common.reedsolomon.ReedSolomonException;

public final class ReedSolomonDecoder {
    private final GF256 field;

    public ReedSolomonDecoder(GF256 gF256) {
        this.field = gF256;
    }

    public void decode(int[] nArray, int n) throws ReedSolomonException {
        GF256Poly gF256Poly = new GF256Poly(this.field, nArray);
        int[] nArray2 = new int[n];
        boolean bl = this.field.equals(GF256.DATA_MATRIX_FIELD);
        boolean bl2 = true;
        for (int i = 0; i < n; ++i) {
            int n2;
            nArray2[nArray2.length - 1 - i] = n2 = gF256Poly.evaluateAt(this.field.exp(bl ? i + 1 : i));
            if (n2 == 0) continue;
            bl2 = false;
        }
        if (bl2) {
            return;
        }
        GF256Poly gF256Poly2 = new GF256Poly(this.field, nArray2);
        GF256Poly[] gF256PolyArray = this.runEuclideanAlgorithm(this.field.buildMonomial(n, 1), gF256Poly2, n);
        GF256Poly gF256Poly3 = gF256PolyArray[0];
        GF256Poly gF256Poly4 = gF256PolyArray[1];
        int[] nArray3 = this.findErrorLocations(gF256Poly3);
        int[] nArray4 = this.findErrorMagnitudes(gF256Poly4, nArray3, bl);
        for (int i = 0; i < nArray3.length; ++i) {
            int n3 = nArray.length - 1 - this.field.log(nArray3[i]);
            if (n3 < 0) {
                throw new ReedSolomonException("Bad error location");
            }
            nArray[n3] = GF256.addOrSubtract(nArray[n3], nArray4[i]);
        }
    }

    private GF256Poly[] runEuclideanAlgorithm(GF256Poly gF256Poly, GF256Poly gF256Poly2, int n) throws ReedSolomonException {
        GF256Poly gF256Poly3;
        GF256Poly gF256Poly4;
        GF256Poly gF256Poly5;
        if (gF256Poly.getDegree() < gF256Poly2.getDegree()) {
            gF256Poly5 = gF256Poly;
            gF256Poly = gF256Poly2;
            gF256Poly2 = gF256Poly5;
        }
        gF256Poly5 = gF256Poly;
        GF256Poly gF256Poly6 = gF256Poly2;
        GF256Poly gF256Poly7 = this.field.getOne();
        GF256Poly gF256Poly8 = this.field.getZero();
        GF256Poly gF256Poly9 = this.field.getZero();
        GF256Poly gF256Poly10 = this.field.getOne();
        while (gF256Poly6.getDegree() >= n / 2) {
            GF256Poly gF256Poly11 = gF256Poly5;
            GF256Poly gF256Poly12 = gF256Poly7;
            gF256Poly4 = gF256Poly9;
            gF256Poly5 = gF256Poly6;
            gF256Poly7 = gF256Poly8;
            gF256Poly9 = gF256Poly10;
            if (gF256Poly5.isZero()) {
                throw new ReedSolomonException("r_{i-1} was zero");
            }
            gF256Poly6 = gF256Poly11;
            gF256Poly3 = this.field.getZero();
            int n2 = gF256Poly5.getCoefficient(gF256Poly5.getDegree());
            int n3 = this.field.inverse(n2);
            while (gF256Poly6.getDegree() >= gF256Poly5.getDegree() && !gF256Poly6.isZero()) {
                int n4 = gF256Poly6.getDegree() - gF256Poly5.getDegree();
                int n5 = this.field.multiply(gF256Poly6.getCoefficient(gF256Poly6.getDegree()), n3);
                gF256Poly3 = gF256Poly3.addOrSubtract(this.field.buildMonomial(n4, n5));
                gF256Poly6 = gF256Poly6.addOrSubtract(gF256Poly5.multiplyByMonomial(n4, n5));
            }
            gF256Poly8 = gF256Poly3.multiply(gF256Poly7).addOrSubtract(gF256Poly12);
            gF256Poly10 = gF256Poly3.multiply(gF256Poly9).addOrSubtract(gF256Poly4);
        }
        int n6 = gF256Poly10.getCoefficient(0);
        if (n6 == 0) {
            throw new ReedSolomonException("sigmaTilde(0) was zero");
        }
        int n7 = this.field.inverse(n6);
        gF256Poly4 = gF256Poly10.multiply(n7);
        gF256Poly3 = gF256Poly6.multiply(n7);
        return new GF256Poly[]{gF256Poly4, gF256Poly3};
    }

    private int[] findErrorLocations(GF256Poly gF256Poly) throws ReedSolomonException {
        int n = gF256Poly.getDegree();
        if (n == 1) {
            return new int[]{gF256Poly.getCoefficient(1)};
        }
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 1; i < 256 && n2 < n; ++i) {
            if (gF256Poly.evaluateAt(i) != 0) continue;
            nArray[n2] = this.field.inverse(i);
            ++n2;
        }
        if (n2 != n) {
            throw new ReedSolomonException("Error locator degree does not match number of roots");
        }
        return nArray;
    }

    private int[] findErrorMagnitudes(GF256Poly gF256Poly, int[] nArray, boolean bl) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = this.field.inverse(nArray[i]);
            int n3 = 1;
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                int n4 = this.field.multiply(nArray[j], n2);
                int n5 = (n4 & 1) == 0 ? n4 | 1 : n4 & 0xFFFFFFFE;
                n3 = this.field.multiply(n3, n5);
            }
            nArray2[i] = this.field.multiply(gF256Poly.evaluateAt(n2), this.field.inverse(n3));
            if (!bl) continue;
            nArray2[i] = this.field.multiply(nArray2[i], n2);
        }
        return nArray2;
    }
}

