/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.datamatrix.decoder.Decoder;
import com.google.zxing.datamatrix.detector.Detector;
import java.util.Hashtable;

public final class DataMatrixReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder = new Decoder();

    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    public Result decode(BinaryBitmap binaryBitmap, Hashtable hashtable) throws NotFoundException, ChecksumException, FormatException {
        ResultPoint[] resultPointArray;
        DecoderResult decoderResult;
        Object object;
        if (hashtable != null && hashtable.containsKey(DecodeHintType.PURE_BARCODE)) {
            object = DataMatrixReader.extractPureBits(binaryBitmap.getBlackMatrix());
            decoderResult = this.decoder.decode((BitMatrix)object);
            resultPointArray = NO_POINTS;
        } else {
            object = new Detector(binaryBitmap.getBlackMatrix()).detect();
            decoderResult = this.decoder.decode(((DetectorResult)object).getBits());
            resultPointArray = ((DetectorResult)object).getPoints();
        }
        object = new Result(decoderResult.getText(), decoderResult.getRawBytes(), resultPointArray, BarcodeFormat.DATA_MATRIX);
        if (decoderResult.getByteSegments() != null) {
            ((Result)object).putMetadata(ResultMetadataType.BYTE_SEGMENTS, decoderResult.getByteSegments());
        }
        if (decoderResult.getECLevel() != null) {
            ((Result)object).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, decoderResult.getECLevel().toString());
        }
        return object;
    }

    public void reset() {
    }

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) throws NotFoundException {
        int n;
        int n2;
        int n3 = bitMatrix.getHeight();
        int n4 = bitMatrix.getWidth();
        int n5 = Math.min(n3, n4);
        int[] nArray = bitMatrix.getTopLeftOnBit();
        if (nArray == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n6 = nArray[1];
        for (n2 = nArray[0]; n2 < n5 && n6 < n5 && bitMatrix.get(n2, n6); ++n2) {
        }
        if (n2 == n5) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n7 = n2 - nArray[0];
        for (n = n4 - 1; n >= 0 && !bitMatrix.get(n, n6); --n) {
        }
        if (n < 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        if ((++n - n2) % n7 != 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n8 = 2 + (n - n2) / n7;
        n6 += n7;
        if ((n2 -= n7 >> 1) + (n8 - 1) * n7 >= n4 || (n6 -= n7 >> 1) + (n8 - 1) * n7 >= n3) {
            throw NotFoundException.getNotFoundInstance();
        }
        BitMatrix bitMatrix2 = new BitMatrix(n8);
        for (int i = 0; i < n8; ++i) {
            int n9 = n6 + i * n7;
            for (int j = 0; j < n8; ++j) {
                if (!bitMatrix.get(n2 + j * n7, n9)) continue;
                bitMatrix2.set(j, i);
            }
        }
        return bitMatrix2;
    }
}

