/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.BitSource;
import com.google.zxing.common.DecoderResult;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

final class DecodedBitStreamParser {
    private static final char[] C40_BASIC_SET_CHARS = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] C40_SHIFT2_SET_CHARS = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_'};
    private static final char[] TEXT_BASIC_SET_CHARS = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] TEXT_SHIFT3_SET_CHARS = new char[]{'\'', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}', '~', '\u007f'};
    private static final int PAD_ENCODE = 0;
    private static final int ASCII_ENCODE = 1;
    private static final int C40_ENCODE = 2;
    private static final int TEXT_ENCODE = 3;
    private static final int ANSIX12_ENCODE = 4;
    private static final int EDIFACT_ENCODE = 5;
    private static final int BASE256_ENCODE = 6;

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(byte[] byArray) throws FormatException {
        BitSource bitSource = new BitSource(byArray);
        StringBuffer stringBuffer = new StringBuffer(100);
        StringBuffer stringBuffer2 = new StringBuffer(0);
        Vector vector = new Vector(1);
        int n = 1;
        do {
            if (n == 1) {
                n = DecodedBitStreamParser.decodeAsciiSegment(bitSource, stringBuffer, stringBuffer2);
                continue;
            }
            switch (n) {
                case 2: {
                    DecodedBitStreamParser.decodeC40Segment(bitSource, stringBuffer);
                    break;
                }
                case 3: {
                    DecodedBitStreamParser.decodeTextSegment(bitSource, stringBuffer);
                    break;
                }
                case 4: {
                    DecodedBitStreamParser.decodeAnsiX12Segment(bitSource, stringBuffer);
                    break;
                }
                case 5: {
                    DecodedBitStreamParser.decodeEdifactSegment(bitSource, stringBuffer);
                    break;
                }
                case 6: {
                    DecodedBitStreamParser.decodeBase256Segment(bitSource, stringBuffer, vector);
                    break;
                }
                default: {
                    throw FormatException.getFormatInstance();
                }
            }
            n = 1;
        } while (n != 0 && bitSource.available() > 0);
        if (stringBuffer2.length() > 0) {
            stringBuffer.append(stringBuffer2.toString());
        }
        return new DecoderResult(byArray, stringBuffer.toString(), vector.isEmpty() ? null : vector, null);
    }

    private static int decodeAsciiSegment(BitSource bitSource, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws FormatException {
        boolean bl = false;
        do {
            int n;
            if ((n = bitSource.readBits(8)) == 0) {
                throw FormatException.getFormatInstance();
            }
            if (n <= 128) {
                n = bl ? n + 128 : n;
                bl = false;
                stringBuffer.append((char)(n - 1));
                return 1;
            }
            if (n == 129) {
                return 0;
            }
            if (n <= 229) {
                int n2 = n - 130;
                if (n2 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n2);
                continue;
            }
            if (n == 230) {
                return 2;
            }
            if (n == 231) {
                return 6;
            }
            if (n == 232 || n == 233 || n == 234) continue;
            if (n == 235) {
                bl = true;
                continue;
            }
            if (n == 236) {
                stringBuffer.append("[)>\u001e05\u001d");
                stringBuffer2.insert(0, "\u001e\u0004");
                continue;
            }
            if (n == 237) {
                stringBuffer.append("[)>\u001e06\u001d");
                stringBuffer2.insert(0, "\u001e\u0004");
                continue;
            }
            if (n == 238) {
                return 4;
            }
            if (n == 239) {
                return 3;
            }
            if (n == 240) {
                return 5;
            }
            if (n == 241 || n < 242) continue;
            throw FormatException.getFormatInstance();
        } while (bitSource.available() > 0);
        return 1;
    }

    private static void decodeC40Segment(BitSource bitSource, StringBuffer stringBuffer) throws FormatException {
        boolean bl = false;
        int[] nArray = new int[3];
        do {
            if (bitSource.available() == 8) {
                return;
            }
            int n = bitSource.readBits(8);
            if (n == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(n, bitSource.readBits(8), nArray);
            int n2 = 0;
            block7: for (int i = 0; i < 3; ++i) {
                int n3 = nArray[i];
                switch (n2) {
                    case 0: {
                        if (n3 < 3) {
                            n2 = n3 + 1;
                            continue block7;
                        }
                        if (bl) {
                            stringBuffer.append((char)(C40_BASIC_SET_CHARS[n3] + 128));
                            bl = false;
                            continue block7;
                        }
                        stringBuffer.append(C40_BASIC_SET_CHARS[n3]);
                        continue block7;
                    }
                    case 1: {
                        if (bl) {
                            stringBuffer.append((char)(n3 + 128));
                            bl = false;
                        } else {
                            stringBuffer.append(n3);
                        }
                        n2 = 0;
                        continue block7;
                    }
                    case 2: {
                        if (n3 < 27) {
                            if (bl) {
                                stringBuffer.append((char)(C40_SHIFT2_SET_CHARS[n3] + 128));
                                bl = false;
                            } else {
                                stringBuffer.append(C40_SHIFT2_SET_CHARS[n3]);
                            }
                        } else {
                            if (n3 == 27) {
                                throw FormatException.getFormatInstance();
                            }
                            if (n3 == 30) {
                                bl = true;
                            } else {
                                throw FormatException.getFormatInstance();
                            }
                        }
                        n2 = 0;
                        continue block7;
                    }
                    case 3: {
                        if (bl) {
                            stringBuffer.append((char)(n3 + 224));
                            bl = false;
                        } else {
                            stringBuffer.append((char)(n3 + 96));
                        }
                        n2 = 0;
                        continue block7;
                    }
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                }
            }
        } while (bitSource.available() > 0);
    }

    private static void decodeTextSegment(BitSource bitSource, StringBuffer stringBuffer) throws FormatException {
        boolean bl = false;
        int[] nArray = new int[3];
        do {
            if (bitSource.available() == 8) {
                return;
            }
            int n = bitSource.readBits(8);
            if (n == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(n, bitSource.readBits(8), nArray);
            int n2 = 0;
            block7: for (int i = 0; i < 3; ++i) {
                int n3 = nArray[i];
                switch (n2) {
                    case 0: {
                        if (n3 < 3) {
                            n2 = n3 + 1;
                            continue block7;
                        }
                        if (bl) {
                            stringBuffer.append((char)(TEXT_BASIC_SET_CHARS[n3] + 128));
                            bl = false;
                            continue block7;
                        }
                        stringBuffer.append(TEXT_BASIC_SET_CHARS[n3]);
                        continue block7;
                    }
                    case 1: {
                        if (bl) {
                            stringBuffer.append((char)(n3 + 128));
                            bl = false;
                        } else {
                            stringBuffer.append(n3);
                        }
                        n2 = 0;
                        continue block7;
                    }
                    case 2: {
                        if (n3 < 27) {
                            if (bl) {
                                stringBuffer.append((char)(C40_SHIFT2_SET_CHARS[n3] + 128));
                                bl = false;
                            } else {
                                stringBuffer.append(C40_SHIFT2_SET_CHARS[n3]);
                            }
                        } else {
                            if (n3 == 27) {
                                throw FormatException.getFormatInstance();
                            }
                            if (n3 == 30) {
                                bl = true;
                            } else {
                                throw FormatException.getFormatInstance();
                            }
                        }
                        n2 = 0;
                        continue block7;
                    }
                    case 3: {
                        if (bl) {
                            stringBuffer.append((char)(TEXT_SHIFT3_SET_CHARS[n3] + 128));
                            bl = false;
                        } else {
                            stringBuffer.append(TEXT_SHIFT3_SET_CHARS[n3]);
                        }
                        n2 = 0;
                        continue block7;
                    }
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                }
            }
        } while (bitSource.available() > 0);
    }

    private static void decodeAnsiX12Segment(BitSource bitSource, StringBuffer stringBuffer) throws FormatException {
        int[] nArray = new int[3];
        do {
            if (bitSource.available() == 8) {
                return;
            }
            int n = bitSource.readBits(8);
            if (n == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(n, bitSource.readBits(8), nArray);
            for (int i = 0; i < 3; ++i) {
                int n2 = nArray[i];
                if (n2 == 0) {
                    stringBuffer.append('\r');
                    continue;
                }
                if (n2 == 1) {
                    stringBuffer.append('*');
                    continue;
                }
                if (n2 == 2) {
                    stringBuffer.append('>');
                    continue;
                }
                if (n2 == 3) {
                    stringBuffer.append(' ');
                    continue;
                }
                if (n2 < 14) {
                    stringBuffer.append((char)(n2 + 44));
                    continue;
                }
                if (n2 < 40) {
                    stringBuffer.append((char)(n2 + 51));
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
        } while (bitSource.available() > 0);
    }

    private static void parseTwoBytes(int n, int n2, int[] nArray) {
        int n3;
        int n4 = (n << 8) + n2 - 1;
        nArray[0] = n3 = n4 / 1600;
        n4 -= n3 * 1600;
        nArray[1] = n3 = n4 / 40;
        nArray[2] = n4 - n3 * 40;
    }

    private static void decodeEdifactSegment(BitSource bitSource, StringBuffer stringBuffer) {
        boolean bl = false;
        do {
            if (bitSource.available() <= 16) {
                return;
            }
            for (int i = 0; i < 4; ++i) {
                int n = bitSource.readBits(6);
                if (n == 11111) {
                    bl = true;
                }
                if (bl) continue;
                if ((n & 0x20) == 0) {
                    n |= 0x40;
                }
                stringBuffer.append(n);
            }
        } while (!bl && bitSource.available() > 0);
    }

    private static void decodeBase256Segment(BitSource bitSource, StringBuffer stringBuffer, Vector vector) throws FormatException {
        int n = bitSource.readBits(8);
        int n2 = n == 0 ? bitSource.available() / 8 : (n < 250 ? n : 250 * (n - 249) + bitSource.readBits(8));
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            if (bitSource.available() < 8) {
                throw FormatException.getFormatInstance();
            }
            byArray[i] = DecodedBitStreamParser.unrandomize255State(bitSource.readBits(8), i);
        }
        vector.addElement(byArray);
        try {
            stringBuffer.append(new String(byArray, "ISO8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Platform does not support required encoding: " + unsupportedEncodingException);
        }
    }

    private static byte unrandomize255State(int n, int n2) {
        int n3 = 149 * n2 % 255 + 1;
        int n4 = n - n3;
        return (byte)(n4 >= 0 ? n4 : n4 + 256);
    }
}

