/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.Collections;
import com.google.zxing.common.Comparator;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.common.GridSampler;
import com.google.zxing.common.detector.WhiteRectangleDetector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Detector {
    private static final Integer[] INTEGERS = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4)};
    private final BitMatrix image;
    private final WhiteRectangleDetector rectangleDetector;

    public Detector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
        this.rectangleDetector = new WhiteRectangleDetector(bitMatrix);
    }

    public DetectorResult detect() throws NotFoundException {
        ResultPoint resultPoint;
        Object object;
        ResultPoint[] resultPointArray;
        ResultPoint[] resultPointArray2 = this.rectangleDetector.detect();
        ResultPoint resultPoint2 = resultPointArray2[0];
        ResultPoint resultPoint3 = resultPointArray2[1];
        ResultPoint resultPoint4 = resultPointArray2[2];
        ResultPoint resultPoint5 = resultPointArray2[3];
        Vector<ResultPointsAndTransitions> vector = new Vector<ResultPointsAndTransitions>(4);
        vector.addElement(this.transitionsBetween(resultPoint2, resultPoint3));
        vector.addElement(this.transitionsBetween(resultPoint2, resultPoint4));
        vector.addElement(this.transitionsBetween(resultPoint3, resultPoint5));
        vector.addElement(this.transitionsBetween(resultPoint4, resultPoint5));
        Collections.insertionSort(vector, new ResultPointsAndTransitionsComparator());
        ResultPointsAndTransitions resultPointsAndTransitions = (ResultPointsAndTransitions)vector.elementAt(0);
        ResultPointsAndTransitions resultPointsAndTransitions2 = (ResultPointsAndTransitions)vector.elementAt(1);
        Hashtable hashtable = new Hashtable();
        Detector.increment(hashtable, resultPointsAndTransitions.getFrom());
        Detector.increment(hashtable, resultPointsAndTransitions.getTo());
        Detector.increment(hashtable, resultPointsAndTransitions2.getFrom());
        Detector.increment(hashtable, resultPointsAndTransitions2.getTo());
        ResultPoint[] resultPointArray3 = null;
        Object object2 = null;
        ResultPoint[] resultPointArray4 = null;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            resultPointArray = (ResultPoint[])enumeration.nextElement();
            object = (Integer)hashtable.get(resultPointArray);
            if ((Integer)object == 2) {
                object2 = resultPointArray;
                continue;
            }
            if (resultPointArray3 == null) {
                resultPointArray3 = resultPointArray;
                continue;
            }
            resultPointArray4 = resultPointArray;
        }
        if (resultPointArray3 == null || object2 == null || resultPointArray4 == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        resultPointArray = new ResultPoint[]{resultPointArray3, object2, resultPointArray4};
        ResultPoint.orderBestPatterns(resultPointArray);
        object = resultPointArray[0];
        object2 = resultPointArray[1];
        ResultPoint resultPoint6 = resultPointArray[2];
        ResultPoint resultPoint7 = !hashtable.containsKey(resultPoint2) ? resultPoint2 : (!hashtable.containsKey(resultPoint3) ? resultPoint3 : (!hashtable.containsKey(resultPoint4) ? resultPoint4 : resultPoint5));
        int n = Math.min(this.transitionsBetween(resultPoint6, resultPoint7).getTransitions(), this.transitionsBetween((ResultPoint)object, resultPoint7).getTransitions());
        if ((n & 1) == 1) {
            ++n;
        }
        if ((resultPoint = this.correctTopRight((ResultPoint)object2, (ResultPoint)object, resultPoint6, resultPoint7, n += 2)) == null) {
            resultPoint = resultPoint7;
        }
        int n2 = Math.max(this.transitionsBetween(resultPoint6, resultPoint).getTransitions(), this.transitionsBetween((ResultPoint)object, resultPoint).getTransitions());
        if ((++n2 & 1) == 1) {
            ++n2;
        }
        BitMatrix bitMatrix = Detector.sampleGrid(this.image, resultPoint6, (ResultPoint)object2, (ResultPoint)object, resultPoint, n2);
        return new DetectorResult(bitMatrix, new ResultPoint[]{resultPoint6, object2, object, resultPoint});
    }

    private ResultPoint correctTopRight(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n) {
        int n2;
        float f = (float)Detector.distance(resultPoint, resultPoint2) / (float)n;
        int n3 = Detector.distance(resultPoint3, resultPoint4);
        float f2 = (resultPoint4.getX() - resultPoint3.getX()) / (float)n3;
        float f3 = (resultPoint4.getY() - resultPoint3.getY()) / (float)n3;
        ResultPoint resultPoint5 = new ResultPoint(resultPoint4.getX() + f * f2, resultPoint4.getY() + f * f3);
        f = (float)Detector.distance(resultPoint, resultPoint2) / (float)n;
        n3 = Detector.distance(resultPoint2, resultPoint4);
        f2 = (resultPoint4.getX() - resultPoint2.getX()) / (float)n3;
        f3 = (resultPoint4.getY() - resultPoint2.getY()) / (float)n3;
        ResultPoint resultPoint6 = new ResultPoint(resultPoint4.getX() + f * f2, resultPoint4.getY() + f * f3);
        if (!this.isValid(resultPoint5)) {
            if (this.isValid(resultPoint6)) {
                return resultPoint6;
            }
            return null;
        }
        if (!this.isValid(resultPoint6)) {
            return resultPoint5;
        }
        int n4 = Math.abs(this.transitionsBetween(resultPoint3, resultPoint5).getTransitions() - this.transitionsBetween(resultPoint2, resultPoint5).getTransitions());
        if (n4 <= (n2 = Math.abs(this.transitionsBetween(resultPoint3, resultPoint6).getTransitions() - this.transitionsBetween(resultPoint2, resultPoint6).getTransitions()))) {
            return resultPoint5;
        }
        return resultPoint6;
    }

    private boolean isValid(ResultPoint resultPoint) {
        return resultPoint.getX() >= 0.0f && resultPoint.getX() < (float)this.image.width && resultPoint.getY() > 0.0f && resultPoint.getY() < (float)this.image.height;
    }

    private static int round(float f) {
        return (int)(f + 0.5f);
    }

    private static int distance(ResultPoint resultPoint, ResultPoint resultPoint2) {
        return Detector.round((float)Math.sqrt((resultPoint.getX() - resultPoint2.getX()) * (resultPoint.getX() - resultPoint2.getX()) + (resultPoint.getY() - resultPoint2.getY()) * (resultPoint.getY() - resultPoint2.getY())));
    }

    private static void increment(Hashtable hashtable, ResultPoint resultPoint) {
        Integer n = (Integer)hashtable.get(resultPoint);
        hashtable.put(resultPoint, n == null ? INTEGERS[1] : INTEGERS[n + 1]);
    }

    private static BitMatrix sampleGrid(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n) throws NotFoundException {
        GridSampler gridSampler = GridSampler.getInstance();
        return gridSampler.sampleGrid(bitMatrix, n, 0.5f, 0.5f, (float)n - 0.5f, 0.5f, (float)n - 0.5f, (float)n - 0.5f, 0.5f, (float)n - 0.5f, resultPoint.getX(), resultPoint.getY(), resultPoint4.getX(), resultPoint4.getY(), resultPoint3.getX(), resultPoint3.getY(), resultPoint2.getX(), resultPoint2.getY());
    }

    private ResultPointsAndTransitions transitionsBetween(ResultPoint resultPoint, ResultPoint resultPoint2) {
        int n;
        boolean bl;
        int n2 = (int)resultPoint.getX();
        int n3 = (int)resultPoint.getY();
        int n4 = (int)resultPoint2.getX();
        int n5 = (int)resultPoint2.getY();
        boolean bl2 = bl = Math.abs(n5 - n3) > Math.abs(n4 - n2);
        if (bl) {
            n = n2;
            n2 = n3;
            n3 = n;
            n = n4;
            n4 = n5;
            n5 = n;
        }
        n = Math.abs(n4 - n2);
        int n6 = Math.abs(n5 - n3);
        int n7 = -n >> 1;
        int n8 = n3 < n5 ? 1 : -1;
        int n9 = n2 < n4 ? 1 : -1;
        int n10 = 0;
        boolean bl3 = this.image.get(bl ? n3 : n2, bl ? n2 : n3);
        int n11 = n3;
        for (int i = n2; i != n4; i += n9) {
            boolean bl4 = this.image.get(bl ? n11 : i, bl ? i : n11);
            if (bl4 != bl3) {
                ++n10;
                bl3 = bl4;
            }
            if ((n7 += n6) <= 0) continue;
            if (n11 == n5) break;
            n11 += n8;
            n7 -= n;
        }
        return new ResultPointsAndTransitions(resultPoint, resultPoint2, n10);
    }

    private static class ResultPointsAndTransitionsComparator
    implements Comparator {
        private ResultPointsAndTransitionsComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((ResultPointsAndTransitions)object).getTransitions() - ((ResultPointsAndTransitions)object2).getTransitions();
        }
    }

    private static class ResultPointsAndTransitions {
        private final ResultPoint from;
        private final ResultPoint to;
        private final int transitions;

        private ResultPointsAndTransitions(ResultPoint resultPoint, ResultPoint resultPoint2, int n) {
            this.from = resultPoint;
            this.to = resultPoint2;
            this.transitions = n;
        }

        public ResultPoint getFrom() {
            return this.from;
        }

        public ResultPoint getTo() {
            return this.to;
        }

        public int getTransitions() {
            return this.transitions;
        }

        public String toString() {
            return this.from + "/" + this.to + '/' + this.transitions;
        }
    }
}

