/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.NotFoundException;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.multi.MultipleBarcodeReader;
import com.google.zxing.multi.qrcode.detector.MultiDetector;
import com.google.zxing.qrcode.QRCodeReader;
import java.util.Hashtable;
import java.util.Vector;

public final class QRCodeMultiReader
extends QRCodeReader
implements MultipleBarcodeReader {
    private static final Result[] EMPTY_RESULT_ARRAY = new Result[0];

    public Result[] decodeMultiple(BinaryBitmap binaryBitmap) throws NotFoundException {
        return this.decodeMultiple(binaryBitmap, null);
    }

    public Result[] decodeMultiple(BinaryBitmap binaryBitmap, Hashtable hashtable) throws NotFoundException {
        Vector<Result> vector = new Vector<Result>();
        DetectorResult[] detectorResultArray = new MultiDetector(binaryBitmap.getBlackMatrix()).detectMulti(hashtable);
        for (int i = 0; i < detectorResultArray.length; ++i) {
            try {
                DecoderResult decoderResult = this.getDecoder().decode(detectorResultArray[i].getBits());
                ResultPoint[] resultPointArray = detectorResultArray[i].getPoints();
                Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), resultPointArray, BarcodeFormat.QR_CODE);
                if (decoderResult.getByteSegments() != null) {
                    result.putMetadata(ResultMetadataType.BYTE_SEGMENTS, decoderResult.getByteSegments());
                }
                if (decoderResult.getECLevel() != null) {
                    result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, decoderResult.getECLevel().toString());
                }
                vector.addElement(result);
                continue;
            }
            catch (ReaderException readerException) {
                // empty catch block
            }
        }
        if (vector.isEmpty()) {
            return EMPTY_RESULT_ARRAY;
        }
        Result[] resultArray = new Result[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            resultArray[i] = (Result)vector.elementAt(i);
        }
        return resultArray;
    }
}

