/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi.qrcode.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ReaderException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.multi.qrcode.detector.MultiFinderPatternFinder;
import com.google.zxing.qrcode.detector.Detector;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.util.Hashtable;
import java.util.Vector;

public final class MultiDetector
extends Detector {
    private static final DetectorResult[] EMPTY_DETECTOR_RESULTS = new DetectorResult[0];

    public MultiDetector(BitMatrix bitMatrix) {
        super(bitMatrix);
    }

    public DetectorResult[] detectMulti(Hashtable hashtable) throws NotFoundException {
        BitMatrix bitMatrix = this.getImage();
        MultiFinderPatternFinder multiFinderPatternFinder = new MultiFinderPatternFinder(bitMatrix);
        FinderPatternInfo[] finderPatternInfoArray = multiFinderPatternFinder.findMulti(hashtable);
        if (finderPatternInfoArray == null || finderPatternInfoArray.length == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        Vector<DetectorResult> vector = new Vector<DetectorResult>();
        for (int i = 0; i < finderPatternInfoArray.length; ++i) {
            try {
                vector.addElement(this.processFinderPatternInfo(finderPatternInfoArray[i]));
                continue;
            }
            catch (ReaderException readerException) {
                // empty catch block
            }
        }
        if (vector.isEmpty()) {
            return EMPTY_DETECTOR_RESULTS;
        }
        DetectorResult[] detectorResultArray = new DetectorResult[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            detectorResultArray[i] = (DetectorResult)vector.elementAt(i);
        }
        return detectorResultArray;
    }
}

