/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi.qrcode.detector;

import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.Collections;
import com.google.zxing.common.Comparator;
import com.google.zxing.qrcode.detector.FinderPattern;
import com.google.zxing.qrcode.detector.FinderPatternFinder;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.util.Hashtable;
import java.util.Vector;

final class MultiFinderPatternFinder
extends FinderPatternFinder {
    private static final FinderPatternInfo[] EMPTY_RESULT_ARRAY = new FinderPatternInfo[0];
    private static final float MAX_MODULE_COUNT_PER_EDGE = 180.0f;
    private static final float MIN_MODULE_COUNT_PER_EDGE = 9.0f;
    private static final float DIFF_MODSIZE_CUTOFF_PERCENT = 0.05f;
    private static final float DIFF_MODSIZE_CUTOFF = 0.5f;

    MultiFinderPatternFinder(BitMatrix bitMatrix) {
        super(bitMatrix);
    }

    MultiFinderPatternFinder(BitMatrix bitMatrix, ResultPointCallback resultPointCallback) {
        super(bitMatrix, resultPointCallback);
    }

    private FinderPattern[][] selectBestPatterns() throws NotFoundException {
        Vector vector = this.getPossibleCenters();
        int n = vector.size();
        if (n < 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (n == 3) {
            return new FinderPattern[][]{{(FinderPattern)vector.elementAt(0), (FinderPattern)vector.elementAt(1), (FinderPattern)vector.elementAt(2)}};
        }
        Collections.insertionSort(vector, new ModuleSizeComparator());
        Vector<ResultPoint[]> vector2 = new Vector<ResultPoint[]>();
        block0: for (int i = 0; i < n - 2; ++i) {
            FinderPattern finderPattern = (FinderPattern)vector.elementAt(i);
            if (finderPattern == null) continue;
            block1: for (int j = i + 1; j < n - 1; ++j) {
                FinderPattern finderPattern2 = (FinderPattern)vector.elementAt(j);
                if (finderPattern2 == null) continue;
                float f = (finderPattern.getEstimatedModuleSize() - finderPattern2.getEstimatedModuleSize()) / Math.min(finderPattern.getEstimatedModuleSize(), finderPattern2.getEstimatedModuleSize());
                float f2 = Math.abs(finderPattern.getEstimatedModuleSize() - finderPattern2.getEstimatedModuleSize());
                if (f2 > 0.5f && f >= 0.05f) continue block0;
                for (int k = j + 1; k < n; ++k) {
                    float f3;
                    float f4;
                    float f5;
                    FinderPattern finderPattern3 = (FinderPattern)vector.elementAt(k);
                    if (finderPattern3 == null) continue;
                    float f6 = (finderPattern2.getEstimatedModuleSize() - finderPattern3.getEstimatedModuleSize()) / Math.min(finderPattern2.getEstimatedModuleSize(), finderPattern3.getEstimatedModuleSize());
                    float f7 = Math.abs(finderPattern2.getEstimatedModuleSize() - finderPattern3.getEstimatedModuleSize());
                    if (f7 > 0.5f && f6 >= 0.05f) continue block1;
                    ResultPoint[] resultPointArray = new FinderPattern[]{finderPattern, finderPattern2, finderPattern3};
                    ResultPoint.orderBestPatterns(resultPointArray);
                    FinderPatternInfo finderPatternInfo = new FinderPatternInfo((FinderPattern[])resultPointArray);
                    float f8 = ResultPoint.distance(finderPatternInfo.getTopLeft(), finderPatternInfo.getBottomLeft());
                    float f9 = ResultPoint.distance(finderPatternInfo.getTopRight(), finderPatternInfo.getBottomLeft());
                    float f10 = ResultPoint.distance(finderPatternInfo.getTopLeft(), finderPatternInfo.getTopRight());
                    float f11 = (f8 + f10) / finderPattern.getEstimatedModuleSize() / 2.0f;
                    if (f11 > 180.0f || f11 < 9.0f || (f5 = Math.abs((f8 - f10) / Math.min(f8, f10))) >= 0.1f || (f4 = Math.abs((f9 - (f3 = (float)Math.sqrt(f8 * f8 + f10 * f10))) / Math.min(f9, f3))) >= 0.1f) continue;
                    vector2.addElement(resultPointArray);
                }
            }
        }
        if (!vector2.isEmpty()) {
            FinderPattern[][] finderPatternArray = new FinderPattern[vector2.size()][];
            for (int i = 0; i < vector2.size(); ++i) {
                finderPatternArray[i] = (FinderPattern[])vector2.elementAt(i);
            }
            return finderPatternArray;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    public FinderPatternInfo[] findMulti(Hashtable hashtable) throws NotFoundException {
        int n;
        boolean bl = hashtable != null && hashtable.containsKey(DecodeHintType.TRY_HARDER);
        BitMatrix bitMatrix = this.getImage();
        int n2 = bitMatrix.getHeight();
        int n3 = bitMatrix.getWidth();
        int n4 = (int)((float)n2 / 228.0f * 3.0f);
        if (n4 < 3 || bl) {
            n4 = 3;
        }
        int[] nArray = new int[5];
        for (int i = n4 - 1; i < n2; i += n4) {
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 0;
            nArray[3] = 0;
            nArray[4] = 0;
            int n5 = 0;
            for (n = 0; n < n3; ++n) {
                if (bitMatrix.get(n, i)) {
                    if (n5 & true) {
                        // empty if block
                    }
                    int n6 = ++n5;
                    nArray[n6] = nArray[n6] + 1;
                    continue;
                }
                if (!(n5 & true)) {
                    if (n5 == 4) {
                        if (MultiFinderPatternFinder.foundPatternCross(nArray)) {
                            boolean bl2 = this.handlePossibleCenter(nArray, i, n);
                            if (!bl2) {
                                while (++n < n3 && !bitMatrix.get(n, i)) {
                                }
                                --n;
                            }
                            n5 = 0;
                            nArray[0] = 0;
                            nArray[1] = 0;
                            nArray[2] = 0;
                            nArray[3] = 0;
                            nArray[4] = 0;
                            continue;
                        }
                        nArray[0] = nArray[2];
                        nArray[1] = nArray[3];
                        nArray[2] = nArray[4];
                        nArray[3] = 1;
                        nArray[4] = 0;
                        n5 = 3;
                        continue;
                    }
                    int n7 = ++n5;
                    nArray[n7] = nArray[n7] + 1;
                    continue;
                }
                int n8 = n5;
                nArray[n8] = nArray[n8] + 1;
            }
            if (!MultiFinderPatternFinder.foundPatternCross(nArray)) continue;
            this.handlePossibleCenter(nArray, i, n3);
        }
        FinderPattern[][] finderPatternArray = this.selectBestPatterns();
        Vector<FinderPatternInfo> vector = new Vector<FinderPatternInfo>();
        for (n = 0; n < finderPatternArray.length; ++n) {
            ResultPoint[] resultPointArray = finderPatternArray[n];
            ResultPoint.orderBestPatterns(resultPointArray);
            vector.addElement(new FinderPatternInfo((FinderPattern[])resultPointArray));
        }
        if (vector.isEmpty()) {
            return EMPTY_RESULT_ARRAY;
        }
        FinderPatternInfo[] finderPatternInfoArray = new FinderPatternInfo[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            finderPatternInfoArray[i] = (FinderPatternInfo)vector.elementAt(i);
        }
        return finderPatternInfoArray;
    }

    private static class ModuleSizeComparator
    implements Comparator {
        private ModuleSizeComparator() {
        }

        public int compare(Object object, Object object2) {
            float f = ((FinderPattern)object2).getEstimatedModuleSize() - ((FinderPattern)object).getEstimatedModuleSize();
            return (double)f < 0.0 ? -1 : ((double)f > 0.0 ? 1 : 0);
        }
    }
}

