/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.Hashtable;

public final class CodaBarReader
extends OneDReader {
    private static final String ALPHABET_STRING = "0123456789-$:/.+ABCDTN";
    private static final char[] ALPHABET = "0123456789-$:/.+ABCDTN".toCharArray();
    private static final int[] CHARACTER_ENCODINGS = new int[]{3, 6, 9, 96, 18, 66, 33, 36, 48, 72, 12, 24, 37, 81, 84, 21, 26, 41, 11, 14, 26, 41};
    private static final int minCharacterLength = 6;
    private static final char[] STARTEND_ENCODING = new char[]{'E', '*', 'A', 'B', 'C', 'D', 'T', 'N'};

    public Result decodeRow(int n, BitArray bitArray, Hashtable hashtable) throws NotFoundException {
        int n2;
        int n3;
        int n4;
        int[] nArray;
        int n5;
        int[] nArray2 = CodaBarReader.findAsteriskPattern(bitArray);
        nArray2[1] = 0;
        int n6 = bitArray.getSize();
        for (n5 = nArray2[1]; n5 < n6 && !bitArray.get(n5); ++n5) {
        }
        StringBuffer stringBuffer = new StringBuffer();
        do {
            nArray = new int[]{0, 0, 0, 0, 0, 0, 0};
            CodaBarReader.recordPattern(bitArray, n5, nArray);
            n4 = CodaBarReader.toNarrowWidePattern(nArray);
            if (n4 == 33) {
                throw NotFoundException.getNotFoundInstance();
            }
            stringBuffer.append((char)n4);
            n3 = n5;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                n5 += nArray[n2];
            }
            while (n5 < n6 && !bitArray.get(n5)) {
                ++n5;
            }
        } while (n5 < n6);
        n4 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n4 += nArray[n2];
        }
        n2 = n5 - n3 - n4;
        if (n5 != n6 && n2 / 2 < n4) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (stringBuffer.length() < 2) {
            throw NotFoundException.getNotFoundInstance();
        }
        char c = stringBuffer.charAt(0);
        if (!CodaBarReader.arrayContains(STARTEND_ENCODING, c)) {
            throw NotFoundException.getNotFoundInstance();
        }
        for (int i = 1; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != c || i + 1 == stringBuffer.length()) continue;
            stringBuffer.delete(i + 1, stringBuffer.length() - 1);
            i = stringBuffer.length();
        }
        if (stringBuffer.length() <= 6) {
            throw NotFoundException.getNotFoundInstance();
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.deleteCharAt(0);
        float f = (float)(nArray2[1] + nArray2[0]) / 2.0f;
        float f2 = (float)(n5 + n3) / 2.0f;
        return new Result(stringBuffer.toString(), null, new ResultPoint[]{new ResultPoint(f, n), new ResultPoint(f2, n)}, BarcodeFormat.CODABAR);
    }

    private static int[] findAsteriskPattern(BitArray bitArray) throws NotFoundException {
        int n;
        int n2 = bitArray.getSize();
        for (n = 0; n < n2 && !bitArray.get(n); ++n) {
        }
        int n3 = 0;
        int[] nArray = new int[7];
        int n4 = n;
        boolean bl = false;
        int n5 = nArray.length;
        for (int i = n; i < n2; ++i) {
            boolean bl2 = bitArray.get(i);
            if (bl2 ^ bl) {
                int n6 = n3;
                nArray[n6] = nArray[n6] + 1;
                continue;
            }
            if (n3 == n5 - 1) {
                try {
                    if (CodaBarReader.arrayContains(STARTEND_ENCODING, CodaBarReader.toNarrowWidePattern(nArray)) && bitArray.isRange(Math.max(0, n4 - (i - n4) / 2), n4, false)) {
                        return new int[]{n4, i};
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                n4 += nArray[0] + nArray[1];
                for (int j = 2; j < n5; ++j) {
                    nArray[j - 2] = nArray[j];
                }
                nArray[n5 - 2] = 0;
                nArray[n5 - 1] = 0;
                --n3;
            } else {
                ++n3;
            }
            nArray[n3] = 1;
            bl ^= true;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static boolean arrayContains(char[] cArray, char c) {
        if (cArray != null) {
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] != c) continue;
                return true;
            }
        }
        return false;
    }

    private static char toNarrowWidePattern(int[] nArray) {
        int n;
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        for (n = 0; n < n2; ++n) {
            if (nArray[n] < n4) {
                n4 = nArray[n];
            }
            if (nArray[n] <= n3) continue;
            n3 = nArray[n];
        }
        do {
            int n5;
            n = 0;
            int n6 = 0;
            for (n5 = 0; n5 < n2; ++n5) {
                if (nArray[n5] <= n3) continue;
                n6 |= 1 << n2 - 1 - n5;
                ++n;
            }
            if (n != 2 && n != 3) continue;
            for (n5 = 0; n5 < CHARACTER_ENCODINGS.length; ++n5) {
                if (CHARACTER_ENCODINGS[n5] != n6) continue;
                return ALPHABET[n5];
            }
        } while (--n3 > n4);
        return '!';
    }
}

