/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Reader;
import com.google.zxing.oned.UPCEANWriter;
import java.util.Hashtable;

public final class Code128Writer
extends UPCEANWriter {
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Hashtable hashtable) throws WriterException {
        if (barcodeFormat != BarcodeFormat.CODE_128) {
            throw new IllegalArgumentException("Can only encode CODE_128, but got " + barcodeFormat);
        }
        return super.encode(string, barcodeFormat, n, n2, hashtable);
    }

    public byte[] encode(String string) {
        int n;
        int n2 = string.length();
        if (n2 > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + n2);
        }
        int n3 = 35;
        for (int i = 0; i < n2; ++i) {
            int[] nArray = Code128Reader.CODE_PATTERNS[string.charAt(i) - 32];
            for (n = 0; n < nArray.length; ++n) {
                n3 += nArray[n];
            }
        }
        byte[] byArray = new byte[n3];
        int n4 = Code128Writer.appendPattern(byArray, 0, Code128Reader.CODE_PATTERNS[104], 1);
        n = 104;
        for (int i = 0; i < n2; ++i) {
            n += (string.charAt(i) - 32) * (i + 1);
            n4 += Code128Writer.appendPattern(byArray, n4, Code128Reader.CODE_PATTERNS[string.charAt(i) - 32], 1);
        }
        n4 += Code128Writer.appendPattern(byArray, n4, Code128Reader.CODE_PATTERNS[n %= 103], 1);
        n4 += Code128Writer.appendPattern(byArray, n4, Code128Reader.CODE_PATTERNS[106], 1);
        return byArray;
    }
}

