/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code39Reader;
import com.google.zxing.oned.UPCEANWriter;
import java.util.Hashtable;

public final class Code39Writer
extends UPCEANWriter {
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Hashtable hashtable) throws WriterException {
        if (barcodeFormat != BarcodeFormat.CODE_39) {
            throw new IllegalArgumentException("Can only encode CODE_39, but got " + barcodeFormat);
        }
        return super.encode(string, barcodeFormat, n, n2, hashtable);
    }

    public byte[] encode(String string) {
        int n;
        int n2 = string.length();
        if (n2 > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + n2);
        }
        int[] nArray = new int[9];
        int n3 = 25 + n2;
        for (int i = 0; i < n2; ++i) {
            n = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".indexOf(string.charAt(i));
            Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[n], nArray);
            for (int j = 0; j < nArray.length; ++j) {
                n3 += nArray[j];
            }
        }
        byte[] byArray = new byte[n3];
        Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[39], nArray);
        n = Code39Writer.appendPattern(byArray, 0, nArray, 1);
        int[] nArray2 = new int[]{1};
        n += Code39Writer.appendPattern(byArray, n, nArray2, 0);
        for (int i = n2 - 1; i >= 0; --i) {
            int n4 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".indexOf(string.charAt(i));
            Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[n4], nArray);
            n += Code39Writer.appendPattern(byArray, n, nArray, 1);
            n += Code39Writer.appendPattern(byArray, n, nArray2, 0);
        }
        Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[39], nArray);
        n += Code39Writer.appendPattern(byArray, n, nArray, 1);
        return byArray;
    }

    private static void toIntArray(int n, int[] nArray) {
        for (int i = 0; i < 9; ++i) {
            int n2 = n & 1 << i;
            nArray[i] = n2 == 0 ? 1 : 2;
        }
    }
}

