/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.UPCEANReader;
import com.google.zxing.oned.UPCEANWriter;
import java.util.Hashtable;

public final class EAN8Writer
extends UPCEANWriter {
    private static final int codeWidth = 67;

    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Hashtable hashtable) throws WriterException {
        if (barcodeFormat != BarcodeFormat.EAN_8) {
            throw new IllegalArgumentException("Can only encode EAN_8, but got " + barcodeFormat);
        }
        return super.encode(string, barcodeFormat, n, n2, hashtable);
    }

    public byte[] encode(String string) {
        int n;
        int n2;
        if (string.length() != 8) {
            throw new IllegalArgumentException("Requested contents should be 8 digits long, but got " + string.length());
        }
        byte[] byArray = new byte[67];
        int n3 = 0;
        n3 += EAN8Writer.appendPattern(byArray, n3, UPCEANReader.START_END_PATTERN, 1);
        for (n2 = 0; n2 <= 3; ++n2) {
            n = Integer.parseInt(string.substring(n2, n2 + 1));
            n3 += EAN8Writer.appendPattern(byArray, n3, UPCEANReader.L_PATTERNS[n], 0);
        }
        n3 += EAN8Writer.appendPattern(byArray, n3, UPCEANReader.MIDDLE_PATTERN, 0);
        for (n2 = 4; n2 <= 7; ++n2) {
            n = Integer.parseInt(string.substring(n2, n2 + 1));
            n3 += EAN8Writer.appendPattern(byArray, n3, UPCEANReader.L_PATTERNS[n], 1);
        }
        n3 += EAN8Writer.appendPattern(byArray, n3, UPCEANReader.START_END_PATTERN, 1);
        return byArray;
    }
}

