/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.ITFReader;
import com.google.zxing.oned.UPCEANWriter;
import java.util.Hashtable;

public final class ITFWriter
extends UPCEANWriter {
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Hashtable hashtable) throws WriterException {
        if (barcodeFormat != BarcodeFormat.ITF) {
            throw new IllegalArgumentException("Can only encode ITF, but got " + barcodeFormat);
        }
        return super.encode(string, barcodeFormat, n, n2, hashtable);
    }

    public byte[] encode(String string) {
        int n = string.length();
        if (n > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + n);
        }
        byte[] byArray = new byte[9 + 9 * n];
        int[] nArray = new int[]{1, 1, 1, 1};
        int n2 = ITFWriter.appendPattern(byArray, 0, nArray, 1);
        for (int i = 0; i < n; i += 2) {
            int n3 = Character.digit(string.charAt(i), 10);
            int n4 = Character.digit(string.charAt(i + 1), 10);
            int[] nArray2 = new int[18];
            for (int j = 0; j < 5; ++j) {
                nArray2[j << 1] = ITFReader.PATTERNS[n3][j];
                nArray2[(j << 1) + 1] = ITFReader.PATTERNS[n4][j];
            }
            n2 += ITFWriter.appendPattern(byArray, n2, nArray2, 1);
        }
        int[] nArray3 = new int[]{3, 1, 1};
        n2 += ITFWriter.appendPattern(byArray, n2, nArray3, 1);
        return byArray;
    }
}

