/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.EAN13Reader;
import com.google.zxing.oned.EAN8Reader;
import com.google.zxing.oned.OneDReader;
import com.google.zxing.oned.UPCAReader;
import com.google.zxing.oned.UPCEANReader;
import com.google.zxing.oned.UPCEReader;
import java.util.Hashtable;
import java.util.Vector;

public final class MultiFormatUPCEANReader
extends OneDReader {
    private final Vector readers;

    public MultiFormatUPCEANReader(Hashtable hashtable) {
        Vector vector = hashtable == null ? null : (Vector)hashtable.get(DecodeHintType.POSSIBLE_FORMATS);
        this.readers = new Vector();
        if (vector != null) {
            if (vector.contains(BarcodeFormat.EAN_13)) {
                this.readers.addElement(new EAN13Reader());
            } else if (vector.contains(BarcodeFormat.UPC_A)) {
                this.readers.addElement(new UPCAReader());
            }
            if (vector.contains(BarcodeFormat.EAN_8)) {
                this.readers.addElement(new EAN8Reader());
            }
            if (vector.contains(BarcodeFormat.UPC_E)) {
                this.readers.addElement(new UPCEReader());
            }
        }
        if (this.readers.isEmpty()) {
            this.readers.addElement(new EAN13Reader());
            this.readers.addElement(new EAN8Reader());
            this.readers.addElement(new UPCEReader());
        }
    }

    public Result decodeRow(int n, BitArray bitArray, Hashtable hashtable) throws NotFoundException {
        int[] nArray = UPCEANReader.findStartGuardPattern(bitArray);
        int n2 = this.readers.size();
        for (int i = 0; i < n2; ++i) {
            boolean bl;
            Result result;
            UPCEANReader uPCEANReader = (UPCEANReader)this.readers.elementAt(i);
            try {
                result = uPCEANReader.decodeRow(n, bitArray, nArray, hashtable);
            }
            catch (ReaderException readerException) {
                continue;
            }
            boolean bl2 = BarcodeFormat.EAN_13.equals(result.getBarcodeFormat()) && result.getText().charAt(0) == '0';
            Vector vector = hashtable == null ? null : (Vector)hashtable.get(DecodeHintType.POSSIBLE_FORMATS);
            boolean bl3 = bl = vector == null || vector.contains(BarcodeFormat.UPC_A);
            if (bl2 && bl) {
                return new Result(result.getText().substring(1), null, result.getResultPoints(), BarcodeFormat.UPC_A);
            }
            return result;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    public void reset() {
        int n = this.readers.size();
        for (int i = 0; i < n; ++i) {
            Reader reader = (Reader)this.readers.elementAt(i);
            reader.reset();
        }
    }
}

