/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import java.util.Hashtable;

public abstract class OneDReader
implements Reader {
    protected static final int INTEGER_MATH_SHIFT = 8;
    protected static final int PATTERN_MATCH_RESULT_SCALE_FACTOR = 256;

    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    public Result decode(BinaryBitmap binaryBitmap, Hashtable hashtable) throws NotFoundException, FormatException {
        try {
            return this.doDecode(binaryBitmap, hashtable);
        }
        catch (NotFoundException notFoundException) {
            boolean bl;
            boolean bl2 = bl = hashtable != null && hashtable.containsKey(DecodeHintType.TRY_HARDER);
            if (bl && binaryBitmap.isRotateSupported()) {
                BinaryBitmap binaryBitmap2 = binaryBitmap.rotateCounterClockwise();
                Result result = this.doDecode(binaryBitmap2, hashtable);
                Hashtable hashtable2 = result.getResultMetadata();
                int n = 270;
                if (hashtable2 != null && hashtable2.containsKey(ResultMetadataType.ORIENTATION)) {
                    n = (n + (Integer)hashtable2.get(ResultMetadataType.ORIENTATION)) % 360;
                }
                result.putMetadata(ResultMetadataType.ORIENTATION, new Integer(n));
                ResultPoint[] resultPointArray = result.getResultPoints();
                int n2 = binaryBitmap2.getHeight();
                for (int i = 0; i < resultPointArray.length; ++i) {
                    resultPointArray[i] = new ResultPoint((float)n2 - resultPointArray[i].getY() - 1.0f, resultPointArray[i].getX());
                }
                return result;
            }
            throw notFoundException;
        }
    }

    public void reset() {
    }

    private Result doDecode(BinaryBitmap binaryBitmap, Hashtable object) throws NotFoundException {
        int n = binaryBitmap.getWidth();
        int n2 = binaryBitmap.getHeight();
        BitArray bitArray = new BitArray(n);
        int n3 = n2 >> 1;
        boolean bl = object != null && ((Hashtable)object).containsKey(DecodeHintType.TRY_HARDER);
        int n4 = Math.max(1, n2 >> (bl ? 8 : 5));
        int n5 = bl ? n2 : 15;
        for (int i = 0; i < n5; ++i) {
            int n6 = i + 1 >> 1;
            boolean bl2 = (i & 1) == 0;
            int n7 = n3 + n4 * (bl2 ? n6 : -n6);
            if (n7 < 0 || n7 >= n2) break;
            try {
                bitArray = binaryBitmap.getBlackRow(n7, bitArray);
            }
            catch (NotFoundException notFoundException) {
                continue;
            }
            for (int j = 0; j < 2; ++j) {
                ResultPoint[] resultPointArray;
                Object object2;
                if (j == 1) {
                    bitArray.reverse();
                    if (object != null && ((Hashtable)object).containsKey(DecodeHintType.NEED_RESULT_POINT_CALLBACK)) {
                        object2 = new Hashtable();
                        resultPointArray = ((Hashtable)object).keys();
                        while (resultPointArray.hasMoreElements()) {
                            Object k = resultPointArray.nextElement();
                            if (k.equals(DecodeHintType.NEED_RESULT_POINT_CALLBACK)) continue;
                            ((Hashtable)object2).put(k, ((Hashtable)object).get(k));
                        }
                        object = object2;
                    }
                }
                try {
                    object2 = this.decodeRow(n7, bitArray, (Hashtable)object);
                    if (j == 1) {
                        ((Result)object2).putMetadata(ResultMetadataType.ORIENTATION, new Integer(180));
                        resultPointArray = ((Result)object2).getResultPoints();
                        resultPointArray[0] = new ResultPoint((float)n - resultPointArray[0].getX() - 1.0f, resultPointArray[0].getY());
                        resultPointArray[1] = new ResultPoint((float)n - resultPointArray[1].getX() - 1.0f, resultPointArray[1].getY());
                    }
                    return object2;
                }
                catch (ReaderException readerException) {
                    continue;
                }
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected static void recordPattern(BitArray bitArray, int n, int[] nArray) throws NotFoundException {
        int n2;
        int n3;
        int n4 = nArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = 0;
        }
        n3 = bitArray.getSize();
        if (n >= n3) {
            throw NotFoundException.getNotFoundInstance();
        }
        boolean bl = !bitArray.get(n);
        int n5 = 0;
        for (n2 = n; n2 < n3; ++n2) {
            boolean bl2 = bitArray.get(n2);
            if (bl2 ^ bl) {
                int n6 = n5;
                nArray[n6] = nArray[n6] + 1;
                continue;
            }
            if (++n5 == n4) break;
            nArray[n5] = 1;
            bl = !bl;
        }
        if (n5 != n4 && (n5 != n4 - 1 || n2 != n3)) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    protected static void recordPatternInReverse(BitArray bitArray, int n, int[] nArray) throws NotFoundException {
        int n2 = nArray.length;
        boolean bl = bitArray.get(n);
        while (n > 0 && n2 >= 0) {
            if (bitArray.get(--n) == bl) continue;
            --n2;
            bl = !bl;
        }
        if (n2 >= 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        OneDReader.recordPattern(bitArray, n + 1, nArray);
    }

    protected static int patternMatchVariance(int[] nArray, int[] nArray2, int n) {
        int n2;
        int n3 = nArray.length;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += nArray[n2];
            n5 += nArray2[n2];
        }
        if (n4 < n5) {
            return Integer.MAX_VALUE;
        }
        n2 = (n4 << 8) / n5;
        n = n * n2 >> 8;
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            int n7;
            int n8 = nArray[i] << 8;
            int n9 = nArray2[i] * n2;
            int n10 = n7 = n8 > n9 ? n8 - n9 : n9 - n8;
            if (n7 > n) {
                return Integer.MAX_VALUE;
            }
            n6 += n7;
        }
        return n6 / n4;
    }

    public abstract Result decodeRow(int var1, BitArray var2, Hashtable var3) throws NotFoundException, ChecksumException, FormatException;
}

