/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss;

import com.google.zxing.NotFoundException;
import com.google.zxing.oned.OneDReader;

public abstract class AbstractRSSReader
extends OneDReader {
    private static final int MAX_AVG_VARIANCE = 51;
    private static final int MAX_INDIVIDUAL_VARIANCE = 102;
    private static final float MIN_FINDER_PATTERN_RATIO = 0.7916667f;
    private static final float MAX_FINDER_PATTERN_RATIO = 0.89285713f;
    protected final int[] decodeFinderCounters = new int[4];
    protected final int[] dataCharacterCounters = new int[8];
    protected final float[] oddRoundingErrors = new float[4];
    protected final float[] evenRoundingErrors = new float[4];
    protected final int[] oddCounts = new int[this.dataCharacterCounters.length / 2];
    protected final int[] evenCounts = new int[this.dataCharacterCounters.length / 2];

    protected AbstractRSSReader() {
    }

    protected static int parseFinderValue(int[] nArray, int[][] nArray2) throws NotFoundException {
        for (int i = 0; i < nArray2.length; ++i) {
            if (AbstractRSSReader.patternMatchVariance(nArray, nArray2[i], 102) >= 51) continue;
            return i;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected static int count(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    protected static void increment(int[] nArray, float[] fArray) {
        int n = 0;
        float f = fArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (!(fArray[i] > f)) continue;
            f = fArray[i];
            n = i;
        }
        int n2 = n;
        nArray[n2] = nArray[n2] + 1;
    }

    protected static void decrement(int[] nArray, float[] fArray) {
        int n = 0;
        float f = fArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (!(fArray[i] < f)) continue;
            f = fArray[i];
            n = i;
        }
        int n2 = n;
        nArray[n2] = nArray[n2] - 1;
    }

    protected static boolean isFinderPattern(int[] nArray) {
        int n = nArray[0] + nArray[1];
        int n2 = n + nArray[2] + nArray[3];
        float f = (float)n / (float)n2;
        if (f >= 0.7916667f && f <= 0.89285713f) {
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MIN_VALUE;
            for (int i = 0; i < nArray.length; ++i) {
                int n5 = nArray[i];
                if (n5 > n4) {
                    n4 = n5;
                }
                if (n5 >= n3) continue;
                n3 = n5;
            }
            return n4 < 10 * n3;
        }
        return false;
    }
}

