/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss.expanded.decoders;

import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.rss.expanded.decoders.AI01weightDecoder;

final class AI013x0x1xDecoder
extends AI01weightDecoder {
    private static final int headerSize = 8;
    private static final int weightSize = 20;
    private static final int dateSize = 16;
    private final String dateCode;
    private final String firstAIdigits;

    AI013x0x1xDecoder(BitArray bitArray, String string, String string2) {
        super(bitArray);
        this.dateCode = string2;
        this.firstAIdigits = string;
    }

    public String parseInformation() throws NotFoundException {
        if (this.information.size != 84) {
            throw NotFoundException.getNotFoundInstance();
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.encodeCompressedGtin(stringBuffer, 8);
        this.encodeCompressedWeight(stringBuffer, 48, 20);
        this.encodeCompressedDate(stringBuffer, 68);
        return stringBuffer.toString();
    }

    private void encodeCompressedDate(StringBuffer stringBuffer, int n) {
        int n2 = this.generalDecoder.extractNumericValueFromBitArray(n, 16);
        if (n2 == 38400) {
            return;
        }
        stringBuffer.append('(');
        stringBuffer.append(this.dateCode);
        stringBuffer.append(')');
        int n3 = n2 % 32;
        int n4 = (n2 /= 32) % 12 + 1;
        int n5 = n2 /= 12;
        if (n5 / 10 == 0) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n5);
        if (n4 / 10 == 0) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n4);
        if (n3 / 10 == 0) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3);
    }

    protected void addWeightCode(StringBuffer stringBuffer, int n) {
        int n2 = n / 100000;
        stringBuffer.append('(');
        stringBuffer.append(this.firstAIdigits);
        stringBuffer.append(n2);
        stringBuffer.append(')');
    }

    protected int checkWeight(int n) {
        return n % 100000;
    }
}

