/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.DecoderResult;

final class DecodedBitStreamParser {
    private static final int TEXT_COMPACTION_MODE_LATCH = 900;
    private static final int BYTE_COMPACTION_MODE_LATCH = 901;
    private static final int NUMERIC_COMPACTION_MODE_LATCH = 902;
    private static final int BYTE_COMPACTION_MODE_LATCH_6 = 924;
    private static final int BEGIN_MACRO_PDF417_CONTROL_BLOCK = 928;
    private static final int BEGIN_MACRO_PDF417_OPTIONAL_FIELD = 923;
    private static final int MACRO_PDF417_TERMINATOR = 922;
    private static final int MODE_SHIFT_TO_BYTE_COMPACTION_MODE = 913;
    private static final int MAX_NUMERIC_CODEWORDS = 15;
    private static final int ALPHA = 0;
    private static final int LOWER = 1;
    private static final int MIXED = 2;
    private static final int PUNCT = 3;
    private static final int PUNCT_SHIFT = 4;
    private static final int PL = 25;
    private static final int LL = 27;
    private static final int AS = 27;
    private static final int ML = 28;
    private static final int AL = 28;
    private static final int PS = 29;
    private static final int PAL = 29;
    private static final char[] PUNCT_CHARS = new char[]{';', '<', '>', '@', '[', '\\', '}', '_', '`', '~', '!', '\r', '\t', ',', ':', '\n', '-', '.', '$', '/', '\"', '|', '*', '(', ')', '?', '{', '}', '\''};
    private static final char[] MIXED_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '&', '\r', '\t', ',', ':', '#', '-', '.', '$', '/', '+', '%', '*', '=', '^'};
    private static final String[] EXP900 = new String[]{"000000000000000000000000000000000000000000001", "000000000000000000000000000000000000000000900", "000000000000000000000000000000000000000810000", "000000000000000000000000000000000000729000000", "000000000000000000000000000000000656100000000", "000000000000000000000000000000590490000000000", "000000000000000000000000000531441000000000000", "000000000000000000000000478296900000000000000", "000000000000000000000430467210000000000000000", "000000000000000000387420489000000000000000000", "000000000000000348678440100000000000000000000", "000000000000313810596090000000000000000000000", "000000000282429536481000000000000000000000000", "000000254186582832900000000000000000000000000", "000228767924549610000000000000000000000000000", "205891132094649000000000000000000000000000000"};

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(int[] nArray) throws FormatException {
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = 1;
        int n2 = nArray[n++];
        while (n < nArray[0]) {
            switch (n2) {
                case 900: {
                    n = DecodedBitStreamParser.textCompaction(nArray, n, stringBuffer);
                    break;
                }
                case 901: {
                    n = DecodedBitStreamParser.byteCompaction(n2, nArray, n, stringBuffer);
                    break;
                }
                case 902: {
                    n = DecodedBitStreamParser.numericCompaction(nArray, n, stringBuffer);
                    break;
                }
                case 913: {
                    n = DecodedBitStreamParser.byteCompaction(n2, nArray, n, stringBuffer);
                    break;
                }
                case 924: {
                    n = DecodedBitStreamParser.byteCompaction(n2, nArray, n, stringBuffer);
                    break;
                }
                default: {
                    --n;
                    n = DecodedBitStreamParser.textCompaction(nArray, n, stringBuffer);
                }
            }
            if (n < nArray.length) {
                n2 = nArray[n++];
                continue;
            }
            throw FormatException.getFormatInstance();
        }
        return new DecoderResult(null, stringBuffer.toString(), null, null);
    }

    private static int textCompaction(int[] nArray, int n, StringBuffer stringBuffer) {
        int[] nArray2 = new int[nArray[0] << 1];
        int[] nArray3 = new int[nArray[0] << 1];
        int n2 = 0;
        boolean bl = false;
        while (n < nArray[0] && !bl) {
            int n3;
            if ((n3 = nArray[n++]) < 900) {
                nArray2[n2] = n3 / 30;
                nArray2[n2 + 1] = n3 % 30;
                n2 += 2;
                continue;
            }
            switch (n3) {
                case 900: {
                    --n;
                    bl = true;
                    break;
                }
                case 901: {
                    --n;
                    bl = true;
                    break;
                }
                case 902: {
                    --n;
                    bl = true;
                    break;
                }
                case 913: {
                    nArray2[n2] = 913;
                    nArray3[n2] = n3;
                    ++n2;
                    break;
                }
                case 924: {
                    --n;
                    bl = true;
                }
            }
        }
        DecodedBitStreamParser.decodeTextCompaction(nArray2, nArray3, n2, stringBuffer);
        return n;
    }

    private static void decodeTextCompaction(int[] nArray, int[] nArray2, int n, StringBuffer stringBuffer) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[i];
            int n5 = 0;
            switch (n2) {
                case 0: {
                    if (n4 < 26) {
                        n5 = (char)(65 + n4);
                        break;
                    }
                    if (n4 == 26) {
                        n5 = 32;
                        break;
                    }
                    if (n4 == 27) {
                        n2 = 1;
                        break;
                    }
                    if (n4 == 28) {
                        n2 = 2;
                        break;
                    }
                    if (n4 == 29) {
                        n3 = n2;
                        n2 = 4;
                        break;
                    }
                    if (n4 != 913) break;
                    stringBuffer.append((char)nArray2[i]);
                    break;
                }
                case 1: {
                    if (n4 < 26) {
                        n5 = (char)(97 + n4);
                        break;
                    }
                    if (n4 == 26) {
                        n5 = 32;
                        break;
                    }
                    if (n4 == 28) {
                        n2 = 0;
                        break;
                    }
                    if (n4 == 28) {
                        n2 = 2;
                        break;
                    }
                    if (n4 == 29) {
                        n3 = n2;
                        n2 = 4;
                        break;
                    }
                    if (n4 != 913) break;
                    stringBuffer.append((char)nArray2[i]);
                    break;
                }
                case 2: {
                    if (n4 < 25) {
                        n5 = MIXED_CHARS[n4];
                        break;
                    }
                    if (n4 == 25) {
                        n2 = 3;
                        break;
                    }
                    if (n4 == 26) {
                        n5 = 32;
                        break;
                    }
                    if (n4 == 27) break;
                    if (n4 == 28) {
                        n2 = 0;
                        break;
                    }
                    if (n4 == 29) {
                        n3 = n2;
                        n2 = 4;
                        break;
                    }
                    if (n4 != 913) break;
                    stringBuffer.append((char)nArray2[i]);
                    break;
                }
                case 3: {
                    if (n4 < 29) {
                        n5 = PUNCT_CHARS[n4];
                        break;
                    }
                    if (n4 == 29) {
                        n2 = 0;
                        break;
                    }
                    if (n4 != 913) break;
                    stringBuffer.append((char)nArray2[i]);
                    break;
                }
                case 4: {
                    n2 = n3;
                    if (n4 < 29) {
                        n5 = PUNCT_CHARS[n4];
                        break;
                    }
                    if (n4 != 29) break;
                    n2 = 0;
                }
            }
            if (n5 == 0) continue;
            stringBuffer.append((char)n5);
        }
    }

    private static int byteCompaction(int n, int[] nArray, int n2, StringBuffer stringBuffer) {
        block12: {
            block11: {
                int n3;
                if (n != 901) break block11;
                int n4 = 0;
                long l = 0L;
                char[] cArray = new char[6];
                int[] nArray2 = new int[6];
                boolean bl = false;
                while (n2 < nArray[0] && !bl) {
                    if ((n3 = nArray[n2++]) < 900) {
                        nArray2[n4] = n3;
                        ++n4;
                        l = 900L * l + (long)n3;
                    } else if (n3 == 900 || n3 == 901 || n3 == 902 || n3 == 924 || n3 == 928 || n3 == 923 || n3 == 922) {
                        --n2;
                        bl = true;
                    }
                    if (n4 % 5 != 0 || n4 <= 0) continue;
                    for (int i = 0; i < 6; ++i) {
                        cArray[5 - i] = (char)(l % 256L);
                        l >>= 8;
                    }
                    stringBuffer.append(cArray);
                    n4 = 0;
                }
                for (n3 = n4 / 5 * 5; n3 < n4; ++n3) {
                    stringBuffer.append((char)nArray2[n3]);
                }
                break block12;
            }
            if (n != 924) break block12;
            int n5 = 0;
            long l = 0L;
            boolean bl = false;
            while (n2 < nArray[0] && !bl) {
                int n6;
                if ((n6 = nArray[n2++]) < 900) {
                    ++n5;
                    l = 900L * l + (long)n6;
                } else if (n6 == 900 || n6 == 901 || n6 == 902 || n6 == 924 || n6 == 928 || n6 == 923 || n6 == 922) {
                    --n2;
                    bl = true;
                }
                if (n5 % 5 != 0 || n5 <= 0) continue;
                char[] cArray = new char[6];
                for (int i = 0; i < 6; ++i) {
                    cArray[5 - i] = (char)(l & 0xFFL);
                    l >>= 8;
                }
                stringBuffer.append(cArray);
            }
        }
        return n2;
    }

    private static int numericCompaction(int[] nArray, int n, StringBuffer stringBuffer) {
        int n2 = 0;
        boolean bl = false;
        int[] nArray2 = new int[15];
        while (n < nArray[0] && !bl) {
            int n3 = nArray[n++];
            if (n == nArray[0]) {
                bl = true;
            }
            if (n3 < 900) {
                nArray2[n2] = n3;
                ++n2;
            } else if (n3 == 900 || n3 == 901 || n3 == 924 || n3 == 928 || n3 == 923 || n3 == 922) {
                --n;
                bl = true;
            }
            if (n2 % 15 != 0 && n3 != 902 && !bl) continue;
            String string = DecodedBitStreamParser.decodeBase900toBase10(nArray2, n2);
            stringBuffer.append(string);
            n2 = 0;
        }
        return n;
    }

    private static String decodeBase900toBase10(int[] nArray, int n) {
        StringBuffer stringBuffer = null;
        for (int i = 0; i < n; ++i) {
            StringBuffer stringBuffer2 = DecodedBitStreamParser.multiply(EXP900[n - i - 1], nArray[i]);
            stringBuffer = stringBuffer == null ? stringBuffer2 : DecodedBitStreamParser.add(stringBuffer.toString(), stringBuffer2.toString());
        }
        String string = null;
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != '1') continue;
            string = stringBuffer.toString().substring(i + 1);
            break;
        }
        if (string == null) {
            string = stringBuffer.toString();
        }
        return string;
    }

    private static StringBuffer multiply(String string, int n) {
        int n2;
        int n3;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (n3 = 0; n3 < string.length(); ++n3) {
            stringBuffer.append('0');
        }
        n3 = n / 100;
        int n4 = n / 10 % 10;
        int n5 = n % 10;
        for (n2 = 0; n2 < n5; ++n2) {
            stringBuffer = DecodedBitStreamParser.add(stringBuffer.toString(), string);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            stringBuffer = DecodedBitStreamParser.add(stringBuffer.toString(), (string + '0').substring(1));
        }
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer = DecodedBitStreamParser.add(stringBuffer.toString(), (string + "00").substring(2));
        }
        return stringBuffer;
    }

    private static StringBuffer add(String string, String string2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(5);
        StringBuffer stringBuffer2 = new StringBuffer(5);
        StringBuffer stringBuffer3 = new StringBuffer(string.length());
        for (n = 0; n < string.length(); ++n) {
            stringBuffer3.append('0');
        }
        n = 0;
        for (int i = string.length() - 3; i > -1; i -= 3) {
            stringBuffer.setLength(0);
            stringBuffer.append(string.charAt(i));
            stringBuffer.append(string.charAt(i + 1));
            stringBuffer.append(string.charAt(i + 2));
            stringBuffer2.setLength(0);
            stringBuffer2.append(string2.charAt(i));
            stringBuffer2.append(string2.charAt(i + 1));
            stringBuffer2.append(string2.charAt(i + 2));
            int n2 = Integer.parseInt(stringBuffer.toString());
            int n3 = Integer.parseInt(stringBuffer2.toString());
            int n4 = (n2 + n3 + n) % 1000;
            n = (n2 + n3 + n) / 1000;
            stringBuffer3.setCharAt(i + 2, (char)(n4 % 10 + 48));
            stringBuffer3.setCharAt(i + 1, (char)(n4 / 10 % 10 + 48));
            stringBuffer3.setCharAt(i, (char)(n4 / 100 + 48));
        }
        return stringBuffer3;
    }
}

