/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.pdf417.decoder.BitMatrixParser;
import com.google.zxing.pdf417.decoder.DecodedBitStreamParser;

public final class Decoder {
    private static final int MAX_ERRORS = 3;
    private static final int MAX_EC_CODEWORDS = 512;

    public DecoderResult decode(boolean[][] blArray) throws FormatException {
        int n = blArray.length;
        BitMatrix bitMatrix = new BitMatrix(n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!blArray[j][i]) continue;
                bitMatrix.set(j, i);
            }
        }
        return this.decode(bitMatrix);
    }

    public DecoderResult decode(BitMatrix bitMatrix) throws FormatException {
        BitMatrixParser bitMatrixParser = new BitMatrixParser(bitMatrix);
        int[] nArray = bitMatrixParser.readCodewords();
        if (nArray == null || nArray.length == 0) {
            throw FormatException.getFormatInstance();
        }
        int n = bitMatrixParser.getECLevel();
        int n2 = 1 << n + 1;
        int[] nArray2 = bitMatrixParser.getErasures();
        Decoder.correctErrors(nArray, nArray2, n2);
        Decoder.verifyCodewordCount(nArray, n2);
        return DecodedBitStreamParser.decode(nArray);
    }

    private static void verifyCodewordCount(int[] nArray, int n) throws FormatException {
        if (nArray.length < 4) {
            throw FormatException.getFormatInstance();
        }
        int n2 = nArray[0];
        if (n2 > nArray.length) {
            throw FormatException.getFormatInstance();
        }
        if (n2 == 0) {
            if (n < nArray.length) {
                nArray[0] = nArray.length - n;
            } else {
                throw FormatException.getFormatInstance();
            }
        }
    }

    private static int correctErrors(int[] nArray, int[] nArray2, int n) throws FormatException {
        if (nArray2 != null && nArray2.length > n / 2 + 3 || n < 0 || n > 512) {
            throw FormatException.getFormatInstance();
        }
        int n2 = 0;
        if (nArray2 != null) {
            int n3 = nArray2.length;
            if (n2 > 0) {
                n3 -= n2;
            }
            if (n3 > 3) {
                throw FormatException.getFormatInstance();
            }
        }
        return n2;
    }
}

