/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.qrcode.decoder.Decoder;
import com.google.zxing.qrcode.detector.Detector;
import java.util.Hashtable;

public class QRCodeReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder = new Decoder();

    protected Decoder getDecoder() {
        return this.decoder;
    }

    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    public Result decode(BinaryBitmap binaryBitmap, Hashtable hashtable) throws NotFoundException, ChecksumException, FormatException {
        ResultPoint[] resultPointArray;
        DecoderResult decoderResult;
        Object object;
        if (hashtable != null && hashtable.containsKey(DecodeHintType.PURE_BARCODE)) {
            object = QRCodeReader.extractPureBits(binaryBitmap.getBlackMatrix());
            decoderResult = this.decoder.decode((BitMatrix)object, hashtable);
            resultPointArray = NO_POINTS;
        } else {
            object = new Detector(binaryBitmap.getBlackMatrix()).detect(hashtable);
            decoderResult = this.decoder.decode(((DetectorResult)object).getBits(), hashtable);
            resultPointArray = ((DetectorResult)object).getPoints();
        }
        object = new Result(decoderResult.getText(), decoderResult.getRawBytes(), resultPointArray, BarcodeFormat.QR_CODE);
        if (decoderResult.getByteSegments() != null) {
            ((Result)object).putMetadata(ResultMetadataType.BYTE_SEGMENTS, decoderResult.getByteSegments());
        }
        if (decoderResult.getECLevel() != null) {
            ((Result)object).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, decoderResult.getECLevel().toString());
        }
        return object;
    }

    public void reset() {
    }

    public static BitMatrix extractPureBits(BitMatrix bitMatrix) throws NotFoundException {
        int n;
        int n2;
        int n3;
        int n4 = bitMatrix.getHeight();
        int n5 = bitMatrix.getWidth();
        int n6 = Math.min(n4, n5);
        int[] nArray = bitMatrix.getTopLeftOnBit();
        if (nArray == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n7 = nArray[0];
        for (n3 = nArray[1]; n7 < n6 && n3 < n6 && bitMatrix.get(n7, n3); ++n7, ++n3) {
        }
        if (n7 == n6 || n3 == n6) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n8 = n7 - nArray[0];
        if (n8 == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        for (n2 = n5 - 1; n2 > n7 && !bitMatrix.get(n2, n3); --n2) {
        }
        if (n2 <= n7) {
            throw NotFoundException.getNotFoundInstance();
        }
        if ((++n2 - n7) % n8 != 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n9 = n8 == 1 ? 1 : n8 >> 1;
        if ((n7 -= n9) + ((n = 1 + (n2 - n7) / n8) - 1) * n8 >= n5 || (n3 -= n9) + (n - 1) * n8 >= n4) {
            throw NotFoundException.getNotFoundInstance();
        }
        BitMatrix bitMatrix2 = new BitMatrix(n);
        for (int i = 0; i < n; ++i) {
            int n10 = n3 + i * n8;
            for (int j = 0; j < n; ++j) {
                if (!bitMatrix.get(n7 + j * n8, n10)) continue;
                bitMatrix2.set(j, i);
            }
        }
        return bitMatrix2;
    }
}

