/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.ChecksumException;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.reedsolomon.GF256;
import com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.google.zxing.common.reedsolomon.ReedSolomonException;
import com.google.zxing.qrcode.decoder.BitMatrixParser;
import com.google.zxing.qrcode.decoder.DataBlock;
import com.google.zxing.qrcode.decoder.DecodedBitStreamParser;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Version;
import java.util.Hashtable;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GF256.QR_CODE_FIELD);

    public DecoderResult decode(boolean[][] blArray) throws ChecksumException, FormatException, NotFoundException {
        return this.decode(blArray, null);
    }

    public DecoderResult decode(boolean[][] blArray, Hashtable hashtable) throws ChecksumException, FormatException, NotFoundException {
        int n = blArray.length;
        BitMatrix bitMatrix = new BitMatrix(n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!blArray[i][j]) continue;
                bitMatrix.set(j, i);
            }
        }
        return this.decode(bitMatrix, hashtable);
    }

    public DecoderResult decode(BitMatrix bitMatrix) throws ChecksumException, FormatException, NotFoundException {
        return this.decode(bitMatrix, null);
    }

    public DecoderResult decode(BitMatrix bitMatrix, Hashtable hashtable) throws FormatException, ChecksumException {
        BitMatrixParser bitMatrixParser = new BitMatrixParser(bitMatrix);
        Version version = bitMatrixParser.readVersion();
        ErrorCorrectionLevel errorCorrectionLevel = bitMatrixParser.readFormatInformation().getErrorCorrectionLevel();
        byte[] byArray = bitMatrixParser.readCodewords();
        DataBlock[] dataBlockArray = DataBlock.getDataBlocks(byArray, version, errorCorrectionLevel);
        int n = 0;
        for (int i = 0; i < dataBlockArray.length; ++i) {
            n += dataBlockArray[i].getNumDataCodewords();
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        for (int i = 0; i < dataBlockArray.length; ++i) {
            DataBlock dataBlock = dataBlockArray[i];
            byte[] byArray3 = dataBlock.getCodewords();
            int n3 = dataBlock.getNumDataCodewords();
            this.correctErrors(byArray3, n3);
            for (int j = 0; j < n3; ++j) {
                byArray2[n2++] = byArray3[j];
            }
        }
        return DecodedBitStreamParser.decode(byArray2, version, errorCorrectionLevel, hashtable);
    }

    private void correctErrors(byte[] byArray, int n) throws ChecksumException {
        int n2;
        int n3 = byArray.length;
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = byArray.length - n;
        try {
            this.rsDecoder.decode(nArray, n2);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)nArray[i];
        }
    }
}

