/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.detector.AlignmentPattern;
import java.util.Vector;

final class AlignmentPatternFinder {
    private final BitMatrix image;
    private final Vector possibleCenters;
    private final int startX;
    private final int startY;
    private final int width;
    private final int height;
    private final float moduleSize;
    private final int[] crossCheckStateCount;
    private final ResultPointCallback resultPointCallback;

    AlignmentPatternFinder(BitMatrix bitMatrix, int n, int n2, int n3, int n4, float f, ResultPointCallback resultPointCallback) {
        this.image = bitMatrix;
        this.possibleCenters = new Vector(5);
        this.startX = n;
        this.startY = n2;
        this.width = n3;
        this.height = n4;
        this.moduleSize = f;
        this.crossCheckStateCount = new int[3];
        this.resultPointCallback = resultPointCallback;
    }

    AlignmentPattern find() throws NotFoundException {
        int n = this.startX;
        int n2 = this.height;
        int n3 = n + this.width;
        int n4 = this.startY + (n2 >> 1);
        int[] nArray = new int[3];
        for (int i = 0; i < n2; ++i) {
            AlignmentPattern alignmentPattern;
            int n5;
            int n6 = n4 + ((i & 1) == 0 ? i + 1 >> 1 : -(i + 1 >> 1));
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 0;
            for (n5 = n; n5 < n3 && !this.image.get(n5, n6); ++n5) {
            }
            int n7 = 0;
            while (n5 < n3) {
                if (this.image.get(n5, n6)) {
                    if (n7 == 1) {
                        int n8 = n7;
                        nArray[n8] = nArray[n8] + 1;
                    } else if (n7 == 2) {
                        if (this.foundPatternCross(nArray) && (alignmentPattern = this.handlePossibleCenter(nArray, n6, n5)) != null) {
                            return alignmentPattern;
                        }
                        nArray[0] = nArray[2];
                        nArray[1] = 1;
                        nArray[2] = 0;
                        n7 = 1;
                    } else {
                        int n9 = ++n7;
                        nArray[n9] = nArray[n9] + 1;
                    }
                } else {
                    if (n7 == 1) {
                        // empty if block
                    }
                    int n10 = ++n7;
                    nArray[n10] = nArray[n10] + 1;
                }
                ++n5;
            }
            if (!this.foundPatternCross(nArray) || (alignmentPattern = this.handlePossibleCenter(nArray, n6, n3)) == null) continue;
            return alignmentPattern;
        }
        if (!this.possibleCenters.isEmpty()) {
            return (AlignmentPattern)this.possibleCenters.elementAt(0);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static float centerFromEnd(int[] nArray, int n) {
        return (float)(n - nArray[2]) - (float)nArray[1] / 2.0f;
    }

    private boolean foundPatternCross(int[] nArray) {
        float f = this.moduleSize;
        float f2 = f / 2.0f;
        for (int i = 0; i < 3; ++i) {
            if (!(Math.abs(f - (float)nArray[i]) >= f2)) continue;
            return false;
        }
        return true;
    }

    private float crossCheckVertical(int n, int n2, int n3, int n4) {
        int n5;
        BitMatrix bitMatrix = this.image;
        int n6 = bitMatrix.getHeight();
        int[] nArray = this.crossCheckStateCount;
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        for (n5 = n; n5 >= 0 && bitMatrix.get(n2, n5) && nArray[1] <= n3; --n5) {
            nArray[1] = nArray[1] + 1;
        }
        if (n5 < 0 || nArray[1] > n3) {
            return Float.NaN;
        }
        while (n5 >= 0 && !bitMatrix.get(n2, n5) && nArray[0] <= n3) {
            nArray[0] = nArray[0] + 1;
            --n5;
        }
        if (nArray[0] > n3) {
            return Float.NaN;
        }
        for (n5 = n + 1; n5 < n6 && bitMatrix.get(n2, n5) && nArray[1] <= n3; ++n5) {
            nArray[1] = nArray[1] + 1;
        }
        if (n5 == n6 || nArray[1] > n3) {
            return Float.NaN;
        }
        while (n5 < n6 && !bitMatrix.get(n2, n5) && nArray[2] <= n3) {
            nArray[2] = nArray[2] + 1;
            ++n5;
        }
        if (nArray[2] > n3) {
            return Float.NaN;
        }
        int n7 = nArray[0] + nArray[1] + nArray[2];
        if (5 * Math.abs(n7 - n4) >= 2 * n4) {
            return Float.NaN;
        }
        return this.foundPatternCross(nArray) ? AlignmentPatternFinder.centerFromEnd(nArray, n5) : Float.NaN;
    }

    private AlignmentPattern handlePossibleCenter(int[] nArray, int n, int n2) {
        int n3 = nArray[0] + nArray[1] + nArray[2];
        float f = AlignmentPatternFinder.centerFromEnd(nArray, n2);
        float f2 = this.crossCheckVertical(n, (int)f, 2 * nArray[1], n3);
        if (!Float.isNaN(f2)) {
            float f3 = (float)(nArray[0] + nArray[1] + nArray[2]) / 3.0f;
            int n4 = this.possibleCenters.size();
            for (int i = 0; i < n4; ++i) {
                AlignmentPattern alignmentPattern = (AlignmentPattern)this.possibleCenters.elementAt(i);
                if (!alignmentPattern.aboutEquals(f3, f2, f)) continue;
                return new AlignmentPattern(f, f2, f3);
            }
            AlignmentPattern alignmentPattern = new AlignmentPattern(f, f2, f3);
            this.possibleCenters.addElement(alignmentPattern);
            if (this.resultPointCallback != null) {
                this.resultPointCallback.foundPossibleResultPoint(alignmentPattern);
            }
        }
        return null;
    }
}

