/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import java.util.Hashtable;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDefaultFilePersistence;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.DestinationProvider;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.LocalNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.internal.SSLNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.TCPNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.comms.MqttDirectException;
import org.eclipse.paho.client.mqttv3.internal.security.SSLSocketFactoryFactory;
import org.eclipse.paho.client.mqttv3.internal.trace.Trace;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSubscribe;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttUnsubscribe;

public class MqttClient
implements DestinationProvider {
    private static final int URI_TYPE_TCP = 0;
    private static final int URI_TYPE_SSL = 1;
    private static final int URI_TYPE_LOCAL = 2;
    private String clientId;
    private String serverURI;
    private int serverURIType;
    private ClientComms comms;
    private Hashtable topics;
    private MqttClientPersistence persistence;
    private Trace trace;

    public MqttClient(String serverURI, String clientId) throws MqttException {
        this(serverURI, clientId, new MqttDefaultFilePersistence());
    }

    public MqttClient(String serverURI, String clientId, MqttClientPersistence persistence) throws MqttException {
        if (clientId == null || clientId.length() == 0 || clientId.length() > 23) {
            throw new IllegalArgumentException();
        }
        this.trace = Trace.getTrace(clientId);
        this.serverURI = serverURI;
        this.serverURIType = this.validateURI(serverURI);
        this.clientId = clientId;
        this.persistence = persistence;
        if (this.persistence == null) {
            this.persistence = new MemoryPersistence();
        }
        this.trace.trace((byte)1, 101, new Object[]{clientId, serverURI, persistence});
        this.persistence.open(clientId, serverURI);
        this.comms = new ClientComms(this, this.persistence, this.trace);
        this.persistence.close();
        this.topics = new Hashtable();
    }

    private int validateURI(String serverURI) {
        if (serverURI.startsWith("tcp://")) {
            return 0;
        }
        if (serverURI.startsWith("ssl://")) {
            return 1;
        }
        if (serverURI.startsWith("local://")) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    protected NetworkModule createNetworkModule(String address, MqttConnectOptions options) throws MqttException {
        NetworkModule netModule;
        SocketFactory factory = options.getSocketFactory();
        switch (this.serverURIType) {
            case 0: {
                String shortAddress = address.substring(6);
                String host = this.getHostName(shortAddress);
                int port = this.getPort(shortAddress, 1883);
                if (factory == null) {
                    factory = SocketFactory.getDefault();
                    options.setSocketFactory(factory);
                } else if (factory instanceof SSLSocketFactory) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new TCPNetworkModule(this.trace, factory, host, port);
                break;
            }
            case 1: {
                String[] enabledCiphers;
                String shortAddress = address.substring(6);
                String host = this.getHostName(shortAddress);
                int port = this.getPort(shortAddress, 8883);
                SSLSocketFactoryFactory factoryFactory = null;
                if (factory == null) {
                    try {
                        factoryFactory = new SSLSocketFactoryFactory();
                        Properties sslClientProps = options.getSSLProperties();
                        if (null != sslClientProps) {
                            factoryFactory.initialize(sslClientProps, null);
                        }
                        factory = factoryFactory.createSocketFactory(null);
                    }
                    catch (MqttDirectException ex) {
                        throw ExceptionHelper.createMqttException(ex.getCause());
                    }
                } else if (!(factory instanceof SSLSocketFactory)) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new SSLNetworkModule(this.trace, (SSLSocketFactory)factory, host, port);
                ((SSLNetworkModule)netModule).setSSLhandshakeTimeout(options.getConnectionTimeout());
                if (factoryFactory == null || (enabledCiphers = factoryFactory.getEnabledCipherSuites(null)) == null) break;
                ((SSLNetworkModule)netModule).setEnabledCiphers(enabledCiphers);
                break;
            }
            case 2: {
                netModule = new LocalNetworkModule(address.substring(8));
                break;
            }
            default: {
                netModule = null;
            }
        }
        return netModule;
    }

    private int getPort(String uri, int defaultPort) {
        int portIndex = uri.lastIndexOf(58);
        int port = portIndex == -1 ? defaultPort : Integer.valueOf(uri.substring(portIndex + 1));
        return port;
    }

    private String getHostName(String uri) {
        int schemeIndex = uri.lastIndexOf(47);
        int portIndex = uri.lastIndexOf(58);
        if (portIndex == -1) {
            portIndex = uri.length();
        }
        return uri.substring(schemeIndex + 1, portIndex);
    }

    public void connect() throws MqttSecurityException, MqttException {
        this.connect(new MqttConnectOptions());
    }

    public void connect(MqttConnectOptions options) throws MqttSecurityException, MqttException {
        if (this.isConnected()) {
            throw ExceptionHelper.createMqttException(32100);
        }
        if (this.trace.isOn()) {
            this.trace.trace((byte)1, 103, new Object[]{new Boolean(options.isCleanSession()), new Integer(options.getConnectionTimeout()), new Integer(options.getKeepAliveInterval()), options.getUserName(), null == options.getPassword() ? "[null]" : "[notnull]", null == options.getWillMessage() ? "[null]" : "[notnull]"});
        }
        this.comms.setNetworkModule(this.createNetworkModule(this.serverURI, options));
        this.persistence.open(this.clientId, this.serverURI);
        if (options.isCleanSession()) {
            this.persistence.clear();
        }
        this.comms.connect(new MqttConnect(this.clientId, options.isCleanSession(), options.getKeepAliveInterval(), options.getUserName(), options.getPassword(), options.getWillMessage(), options.getWillDestination()), options.getConnectionTimeout(), options.getKeepAliveInterval(), options.isCleanSession());
    }

    public void disconnect() throws MqttException {
        this.disconnect(30000L);
    }

    public void disconnect(long quiesceTimeout) throws MqttException {
        this.trace.trace((byte)1, 104, new Object[]{new Long(quiesceTimeout)});
        MqttDisconnect disconnect = new MqttDisconnect();
        try {
            this.comms.disconnect(disconnect, quiesceTimeout);
        }
        catch (MqttException ex) {
            this.trace.trace((byte)1, 105, null, ex);
            throw ex;
        }
    }

    public boolean isConnected() {
        return this.comms.isConnected();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getServerURI() {
        return this.serverURI;
    }

    public MqttTopic getTopic(String topic) {
        if (topic.indexOf(35) == -1 && topic.indexOf(43) == -1) {
            MqttTopic result = (MqttTopic)this.topics.get(topic);
            if (result == null) {
                result = new MqttTopic(topic, this.comms);
                this.topics.put(topic, result);
            }
            return result;
        }
        throw new IllegalArgumentException();
    }

    public void subscribe(String topicFilter) throws MqttException, MqttSecurityException {
        this.subscribe(new String[]{topicFilter}, new int[]{1});
    }

    public void subscribe(String[] topicFilters) throws MqttException, MqttSecurityException {
        int[] qos = new int[topicFilters.length];
        for (int i = 0; i < qos.length; ++i) {
            qos[i] = 1;
        }
        this.subscribe(topicFilters, qos);
    }

    public void subscribe(String topicFilter, int qos) throws MqttException, MqttSecurityException {
        this.subscribe(new String[]{topicFilter}, new int[]{qos});
    }

    public void subscribe(String[] topicFilters, int[] qos) throws MqttException, MqttSecurityException {
        if (topicFilters.length != qos.length) {
            throw new IllegalArgumentException();
        }
        if (this.trace.isOn()) {
            String subs = "";
            for (int i = 0; i < topicFilters.length; ++i) {
                if (i > 0) {
                    subs = subs + ", ";
                }
                subs = subs + topicFilters[i] + ":" + qos[i];
            }
            this.trace.trace((byte)1, 106, new Object[]{subs});
        }
        MqttSubscribe register = new MqttSubscribe(topicFilters, qos);
        this.comms.sendAndWait(register);
    }

    public void unsubscribe(String topicFilter) throws MqttException {
        this.unsubscribe(new String[]{topicFilter});
    }

    public void unsubscribe(String[] topicFilters) throws MqttException {
        if (this.trace.isOn()) {
            String subs = "";
            for (int i = 0; i < topicFilters.length; ++i) {
                if (i > 0) {
                    subs = subs + ", ";
                }
                subs = subs + topicFilters[i];
            }
            this.trace.trace((byte)1, 107, new Object[]{subs});
        }
        MqttUnsubscribe unregister = new MqttUnsubscribe(topicFilters);
        this.comms.sendAndWait(unregister);
    }

    public void setCallback(MqttCallback callback) throws MqttException {
        this.comms.setCallback(callback);
    }

    public static String generateClientId() {
        return System.getProperty("user.name") + "." + System.currentTimeMillis();
    }

    public MqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.comms.getPendingDeliveryTokens();
    }
}

