/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.EOFException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistable;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.internal.CommsCallback;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.MqttDeliveryTokenImpl;
import org.eclipse.paho.client.mqttv3.internal.trace.Trace;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnack;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPingReq;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPingResp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRec;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRel;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSubscribe;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttUnsubscribe;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class ClientState {
    private static final String PERSISTENCE_SENT_PREFIX = "s-";
    private static final String PERSISTENCE_CONFIRMED_PREFIX = "sc-";
    private static final String PERSISTENCE_RECEIVED_PREFIX = "r-";
    private static final int MIN_MSG_ID = 1;
    private static final int MAX_MSG_ID = 65535;
    private int nextMsgId = 0;
    private Hashtable inUseMsgIds;
    private Vector pendingMessages;
    private Vector pendingFlows;
    private CommsTokenStore tokenStore;
    private long keepAlive;
    private boolean cleanSession;
    private int maxInflight = 10;
    private MqttClientPersistence persistence;
    private int actualInFlight = 0;
    private int inFlightPubRels = 0;
    private Object queueLock = new Object();
    private Object quiesceLock = new Object();
    private boolean quiescing = false;
    private long lastOutboundActivity = 0L;
    private long lastInboundActivity = 0L;
    private boolean connected = false;
    private boolean sentConnect = false;
    private boolean connectFailed = false;
    private CommsCallback callback = null;
    private Hashtable outboundQoS2 = null;
    private Hashtable outboundQoS1 = null;
    private Hashtable inboundQoS2 = null;
    private MqttWireMessage pingCommand;
    private boolean pingOutstanding = false;
    private Trace trace;
    private int waitingTokens = 0;
    private Object waitingTokensLock = new Object();

    protected ClientState(Trace trace, MqttClientPersistence persistence, CommsTokenStore tokenStore, CommsCallback callback) throws MqttException {
        this.trace = trace;
        this.inUseMsgIds = new Hashtable();
        this.pendingMessages = new Vector(this.maxInflight);
        this.pendingFlows = new Vector();
        this.outboundQoS2 = new Hashtable();
        this.outboundQoS1 = new Hashtable();
        this.inboundQoS2 = new Hashtable();
        this.pingCommand = new MqttPingReq();
        this.inFlightPubRels = 0;
        this.actualInFlight = 0;
        this.persistence = persistence;
        this.callback = callback;
        this.tokenStore = tokenStore;
        this.restoreState();
    }

    protected void setKeepAliveSecs(long keepAliveSecs) {
        this.keepAlive = keepAliveSecs * 1000L;
    }

    protected void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    private String getSendPersistenceKey(MqttWireMessage message) {
        return PERSISTENCE_SENT_PREFIX + message.getMessageId();
    }

    private String getSendConfirmPersistenceKey(MqttWireMessage message) {
        return PERSISTENCE_CONFIRMED_PREFIX + message.getMessageId();
    }

    private String getReceivedPersistenceKey(MqttWireMessage message) {
        return PERSISTENCE_RECEIVED_PREFIX + message.getMessageId();
    }

    protected void clearState() throws MqttException {
        this.trace.trace((byte)1, 603);
        this.persistence.clear();
        this.inUseMsgIds.clear();
        this.pendingMessages.clear();
        this.pendingFlows.clear();
        this.outboundQoS2.clear();
        this.outboundQoS1.clear();
        this.inboundQoS2.clear();
        this.tokenStore.clear();
    }

    private MqttWireMessage restoreMessage(String key, MqttPersistable persistable) throws MqttException {
        MqttWireMessage message = null;
        try {
            message = MqttWireMessage.createWireMessage(persistable);
        }
        catch (MqttException ex) {
            this.trace.trace((byte)1, 602, new Object[]{key}, ex);
            if (ex.getCause() instanceof EOFException) {
                if (key != null) {
                    this.persistence.remove(key);
                }
            }
            throw ex;
        }
        this.trace.trace((byte)1, 601, new Object[]{key, message});
        return message;
    }

    private void insertInOrder(Vector list, MqttWireMessage newMsg) {
        int newMsgId = newMsg.getMessageId();
        for (int i = 0; i < list.size(); ++i) {
            MqttWireMessage otherMsg = (MqttWireMessage)list.elementAt(i);
            int otherMsgId = otherMsg.getMessageId();
            if (otherMsgId <= newMsgId) continue;
            list.insertElementAt(newMsg, i);
            return;
        }
        list.addElement(newMsg);
    }

    private Vector reOrder(Vector list) {
        int i;
        Vector newList = new Vector();
        if (list.size() == 0) {
            return newList;
        }
        int previousMsgId = 0;
        int largestGap = 0;
        int largestGapMsgIdPosInList = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int currentMsgId = ((MqttWireMessage)list.elementAt(i2)).getMessageId();
            if (currentMsgId - previousMsgId > largestGap) {
                largestGap = currentMsgId - previousMsgId;
                largestGapMsgIdPosInList = i2;
            }
            previousMsgId = currentMsgId;
        }
        int highestMsgId = previousMsgId;
        int lowestMsgId = ((MqttWireMessage)list.elementAt(0)).getMessageId();
        if (65535 - highestMsgId + lowestMsgId > largestGap) {
            largestGapMsgIdPosInList = 0;
        }
        for (i = largestGapMsgIdPosInList; i < list.size(); ++i) {
            newList.addElement(list.elementAt(i));
        }
        for (i = 0; i < largestGapMsgIdPosInList; ++i) {
            newList.addElement(list.elementAt(i));
        }
        return newList;
    }

    protected void restoreState() throws MqttException {
        String key;
        Enumeration messageKeys = this.persistence.keys();
        int highestMsgId = this.nextMsgId;
        Vector<String> orphanedPubRels = new Vector<String>();
        this.trace.trace((byte)1, 600);
        while (messageKeys.hasMoreElements()) {
            MqttPubRel pubRelMessage;
            MqttPersistable persistable;
            key = (String)messageKeys.nextElement();
            MqttWireMessage message = this.restoreMessage(key, persistable = this.persistence.get(key));
            if (message == null) continue;
            if (key.startsWith(PERSISTENCE_RECEIVED_PREFIX)) {
                this.trace.trace((byte)1, 604, new Object[]{key, message});
                this.inboundQoS2.put(new Integer(message.getMessageId()), message);
                continue;
            }
            if (key.startsWith(PERSISTENCE_SENT_PREFIX)) {
                MqttPublish sendMessage = (MqttPublish)message;
                highestMsgId = Math.max(sendMessage.getMessageId(), highestMsgId);
                if (this.persistence.containsKey(this.getSendConfirmPersistenceKey(sendMessage))) {
                    MqttPersistable persistedConfirm = this.persistence.get(this.getSendConfirmPersistenceKey(sendMessage));
                    MqttPubRel confirmMessage = (MqttPubRel)this.restoreMessage(key, persistedConfirm);
                    if (confirmMessage != null) {
                        this.trace.trace((byte)1, 605, new Object[]{key, message});
                        this.outboundQoS2.put(new Integer(confirmMessage.getMessageId()), confirmMessage);
                    } else {
                        this.trace.trace((byte)1, 606, new Object[]{key, message});
                    }
                } else if (sendMessage.getMessage().getQos() == 2) {
                    this.trace.trace((byte)1, 607, new Object[]{key, message});
                    this.outboundQoS2.put(new Integer(sendMessage.getMessageId()), sendMessage);
                } else {
                    this.trace.trace((byte)1, 608, new Object[]{key, message});
                    this.outboundQoS1.put(new Integer(sendMessage.getMessageId()), sendMessage);
                }
                this.tokenStore.restoreToken(sendMessage);
                this.inUseMsgIds.put(new Integer(sendMessage.getMessageId()), new Integer(sendMessage.getMessageId()));
                continue;
            }
            if (!key.startsWith(PERSISTENCE_CONFIRMED_PREFIX) || this.persistence.containsKey(this.getSendPersistenceKey(pubRelMessage = (MqttPubRel)message))) continue;
            orphanedPubRels.addElement(key);
        }
        messageKeys = orphanedPubRels.elements();
        while (messageKeys.hasMoreElements()) {
            key = (String)messageKeys.nextElement();
            this.trace.trace((byte)1, 609, new Object[]{key});
            this.persistence.remove(key);
        }
        this.nextMsgId = highestMsgId;
    }

    private void restoreInflightMessages() {
        Object msg;
        Object key;
        this.pendingMessages = new Vector(this.maxInflight);
        this.pendingFlows = new Vector();
        Enumeration keys = this.outboundQoS2.keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            msg = this.outboundQoS2.get(key);
            if (msg instanceof MqttPublish) {
                this.trace.trace((byte)1, 610, new Object[]{key});
                this.insertInOrder(this.pendingMessages, (MqttPublish)msg);
                continue;
            }
            if (!(msg instanceof MqttPubRel)) continue;
            this.trace.trace((byte)1, 611, new Object[]{key});
            this.insertInOrder(this.pendingFlows, (MqttPubRel)msg);
        }
        keys = this.outboundQoS1.keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            msg = (MqttPublish)this.outboundQoS1.get(key);
            this.trace.trace((byte)1, 612, new Object[]{key});
            this.insertInOrder(this.pendingMessages, (MqttWireMessage)msg);
        }
        this.pendingFlows = this.reOrder(this.pendingFlows);
        this.pendingMessages = this.reOrder(this.pendingMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MqttDeliveryTokenImpl send(MqttWireMessage message) throws MqttException {
        MqttDeliveryTokenImpl token = null;
        if (message instanceof MqttConnect) {
            this.sentConnect = false;
            this.connectFailed = false;
        }
        if (message.isMessageIdRequired() && message.getMessageId() == 0) {
            message.setMessageId(this.getNextMessageId());
        }
        if (message instanceof MqttPublish) {
            Object object = this.queueLock;
            synchronized (object) {
                if (this.quiescing) {
                    if (this.trace.isOn()) {
                        this.trace.trace((byte)1, 613, new Object[]{message});
                    }
                    throw ExceptionHelper.createMqttException(32102);
                }
                MqttMessage innerMessage = ((MqttPublish)message).getMessage();
                if (this.trace.isOn()) {
                    this.trace.trace((byte)1, 612, new Object[]{new Integer(message.getMessageId()), new Integer(innerMessage.getQos()), message});
                }
                switch (innerMessage.getQos()) {
                    case 2: {
                        this.outboundQoS2.put(new Integer(message.getMessageId()), message);
                        this.persistence.put(this.getSendPersistenceKey(message), (MqttPublish)message);
                        break;
                    }
                    case 1: {
                        this.outboundQoS1.put(new Integer(message.getMessageId()), message);
                        this.persistence.put(this.getSendPersistenceKey(message), (MqttPublish)message);
                    }
                }
                this.pendingMessages.addElement(message);
                token = this.tokenStore.saveToken(message);
                this.queueLock.notifyAll();
            }
        }
        if (message instanceof MqttConnect) {
            Object object = this.queueLock;
            synchronized (object) {
                this.pendingFlows.insertElementAt(message, 0);
                token = this.tokenStore.saveToken(message);
                this.queueLock.notifyAll();
            }
        }
        if (this.quiescing && (message instanceof MqttSubscribe || message instanceof MqttUnsubscribe)) {
            if (this.trace.isOn()) {
                this.trace.trace((byte)1, 614, new Object[]{message});
            }
            throw ExceptionHelper.createMqttException(32102);
        }
        if (message instanceof MqttPingReq) {
            this.pingCommand = message;
        } else if (message instanceof MqttPubRel) {
            if (this.trace.isOn()) {
                this.trace.trace((byte)1, 615, new Object[]{new Integer(message.getMessageId())});
            }
            this.outboundQoS2.put(new Integer(message.getMessageId()), message);
            this.persistence.put(this.getSendConfirmPersistenceKey(message), (MqttPubRel)message);
        } else if (message instanceof MqttPubComp) {
            if (this.trace.isOn()) {
                this.trace.trace((byte)1, 616, new Object[]{new Integer(message.getMessageId())});
            }
            this.persistence.remove(this.getReceivedPersistenceKey(message));
        }
        Object object = this.queueLock;
        synchronized (object) {
            this.pendingFlows.addElement(message);
            if (!(message instanceof MqttAck)) {
                token = this.tokenStore.saveToken(message);
            }
            if (message instanceof MqttPubRel) {
                ++this.inFlightPubRels;
                if (this.trace.isOn()) {
                    this.trace.trace((byte)1, 617, new Object[]{new Integer(this.inFlightPubRels)});
                }
            }
            this.queueLock.notifyAll();
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undo(MqttPublish message) throws MqttPersistenceException {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.trace.isOn()) {
                this.trace.trace((byte)1, 618, new Object[]{new Integer(message.getMessage().getQos()), new Integer(message.getMessageId())});
            }
            if (message.getMessage().getQos() == 1) {
                this.outboundQoS1.remove(new Integer(message.getMessageId()));
            } else {
                this.outboundQoS2.remove(new Integer(message.getMessageId()));
            }
            this.pendingMessages.removeElement(message);
            this.persistence.remove(this.getSendPersistenceKey(message));
            this.tokenStore.removeToken(message);
        }
    }

    private MqttWireMessage checkForActivity() throws MqttException {
        MqttWireMessage result = null;
        if (System.currentTimeMillis() - this.lastOutboundActivity >= this.keepAlive || System.currentTimeMillis() - this.lastInboundActivity >= this.keepAlive) {
            if (this.pingOutstanding) {
                if (this.trace.isOn()) {
                    this.trace.trace((byte)1, 619, new Object[]{new Long(this.keepAlive), new Long(this.lastOutboundActivity), new Long(this.lastInboundActivity)});
                }
                throw ExceptionHelper.createMqttException(32000);
            }
            if (this.trace.isOn()) {
                this.trace.trace((byte)1, 620, new Object[]{new Long(this.keepAlive), new Long(this.lastOutboundActivity), new Long(this.lastInboundActivity)});
            }
            this.pingOutstanding = true;
            result = this.pingCommand;
            this.tokenStore.saveToken(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MqttWireMessage get() throws MqttException {
        MqttWireMessage result = null;
        Object object = this.queueLock;
        synchronized (object) {
            if (this.sentConnect && this.connectFailed && !this.connected) {
                this.trace.trace((byte)1, 648);
                return null;
            }
            while (result == null) {
                if (this.pendingMessages.isEmpty() && this.pendingFlows.isEmpty()) {
                    try {
                        this.trace.trace((byte)1, 644);
                        this.queueLock.wait(this.keepAlive);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (!(!this.pendingFlows.isEmpty() && (MqttWireMessage)this.pendingFlows.elementAt(0) instanceof MqttConnect || this.connected)) {
                    this.trace.trace((byte)1, 621);
                    return null;
                }
                if (this.pendingMessages.isEmpty() && this.pendingFlows.isEmpty()) {
                    result = this.checkForActivity();
                    continue;
                }
                if (!this.pendingFlows.isEmpty()) {
                    result = (MqttWireMessage)this.pendingFlows.elementAt(0);
                    this.pendingFlows.removeElementAt(0);
                    this.checkQuiesceLock();
                    continue;
                }
                if (this.pendingMessages.isEmpty()) continue;
                if (this.actualInFlight == this.maxInflight) {
                    this.trace.trace((byte)1, 622);
                    try {
                        this.queueLock.wait(this.keepAlive);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.connected) {
                        this.trace.trace((byte)1, 647);
                        return null;
                    }
                }
                if (this.actualInFlight >= this.maxInflight) continue;
                result = (MqttWireMessage)this.pendingMessages.elementAt(0);
                this.pendingMessages.removeElementAt(0);
                if (result == null) {
                    result = this.checkForActivity();
                    continue;
                }
                ++this.actualInFlight;
                if (!this.trace.isOn()) continue;
                this.trace.trace((byte)1, 623, new Object[]{new Integer(this.actualInFlight)});
            }
        }
        if (this.trace.isOn()) {
            int msgId = 0;
            if (result != null) {
                msgId = result.getMessageId();
            }
            this.trace.trace((byte)1, 624, new Object[]{result, new Integer(msgId)});
        }
        if (result instanceof MqttConnect) {
            this.sentConnect = true;
        }
        return result;
    }

    public void setKeepAliveInterval(long interval) {
        this.keepAlive = interval;
    }

    protected void notifySent(MqttWireMessage message) {
        this.lastOutboundActivity = System.currentTimeMillis();
        if (this.trace.isOn()) {
            this.trace.trace((byte)1, 625, new Object[]{message});
        }
        MqttDeliveryTokenImpl token = this.tokenStore.getToken(message);
        token.notifySent();
        if (message instanceof MqttPublish && ((MqttPublish)message).getMessage().getQos() == 0) {
            token.notifyReceived(null);
            this.tokenStore.removeToken(message);
            this.callback.deliveryComplete(token);
            this.decrementInFlight();
            this.releaseMessageId(message.getMessageId());
        }
        if (message instanceof MqttDisconnect) {
            this.tokenStore.removeToken(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementInFlight() {
        Object object = this.queueLock;
        synchronized (object) {
            --this.actualInFlight;
            if (this.trace.isOn()) {
                this.trace.trace((byte)1, 646, new Object[]{new Integer(this.actualInFlight)});
            }
            if (!this.checkQuiesceLock()) {
                this.queueLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkQuiesceLock() {
        if (this.trace.isOn()) {
            this.trace.trace((byte)1, 626, new Object[]{new Boolean(this.quiescing), new Integer(this.actualInFlight), new Integer(this.pendingFlows.size()), new Integer(this.inFlightPubRels)});
        }
        if (this.quiescing && this.actualInFlight == 0 && this.pendingFlows.size() == 0 && this.inFlightPubRels == 0) {
            Object object = this.quiesceLock;
            synchronized (object) {
                this.quiesceLock.notifyAll();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReceived(MqttWireMessage message) throws MqttException {
        this.lastInboundActivity = System.currentTimeMillis();
        if (this.trace.isOn()) {
            this.trace.trace((byte)1, 627, new Object[]{message, new Integer(message.getMessageId())});
        }
        if (message instanceof MqttAck) {
            MqttAck ack = (MqttAck)message;
            MqttDeliveryTokenImpl token = this.tokenStore.getToken(message);
            if (ack instanceof MqttPubRec && this.outboundQoS2.containsKey(new Integer(ack.getMessageId()))) {
                MqttPubRel rel = new MqttPubRel((MqttPubRec)ack);
                this.send(rel);
            } else {
                if (ack instanceof MqttPubAck) {
                    if (this.trace.isOn()) {
                        this.trace.trace((byte)1, 628, new Object[]{new Integer(ack.getMessageId())});
                    }
                    this.persistence.remove(this.getSendPersistenceKey(message));
                    this.outboundQoS1.remove(new Integer(ack.getMessageId()));
                } else if (ack instanceof MqttPubComp) {
                    this.outboundQoS2.remove(new Integer(ack.getMessageId()));
                    this.persistence.remove(this.getSendPersistenceKey(message));
                    this.persistence.remove(this.getSendConfirmPersistenceKey(message));
                    --this.inFlightPubRels;
                    if (this.trace.isOn()) {
                        this.trace.trace((byte)1, 645, new Object[]{new Integer(ack.getMessageId()), new Integer(this.inFlightPubRels)});
                    }
                }
                this.releaseMessageId(message.getMessageId());
                if (ack instanceof MqttPubAck || ack instanceof MqttPubRec || ack instanceof MqttPubComp) {
                    this.decrementInFlight();
                }
                if (ack instanceof MqttPingResp) {
                    this.trace.trace((byte)1, 629);
                    this.pingOutstanding = false;
                } else if (message instanceof MqttConnack) {
                    if (((MqttConnack)message).getReturnCode() == 0) {
                        if (this.cleanSession) {
                            this.clearState();
                        }
                        this.inFlightPubRels = 0;
                        this.actualInFlight = 0;
                        this.restoreInflightMessages();
                        this.connected();
                    } else {
                        this.connectFailed = true;
                    }
                    Object object = this.queueLock;
                    synchronized (object) {
                        this.queueLock.notifyAll();
                    }
                }
                this.tokenStore.responseReceived((MqttAck)message);
                if (ack instanceof MqttPubAck || ack instanceof MqttPubComp) {
                    this.callback.deliveryComplete(token);
                }
                this.checkQuiesceLock();
            }
        } else if (!this.quiescing) {
            if (message instanceof MqttPublish) {
                MqttPublish send = (MqttPublish)message;
                switch (send.getMessage().getQos()) {
                    case 0: 
                    case 1: {
                        if (this.callback == null) break;
                        this.callback.messageArrived(send);
                        break;
                    }
                    case 2: {
                        if (this.trace.isOn()) {
                            this.trace.trace((byte)1, 630, new Object[]{new Integer(send.getMessageId())});
                        }
                        this.persistence.put(this.getReceivedPersistenceKey(message), (MqttPublish)message);
                        this.inboundQoS2.put(new Integer(send.getMessageId()), send);
                        this.send(new MqttPubRec(send));
                    }
                }
            } else if (message instanceof MqttPubRel) {
                MqttPublish sendMsg = (MqttPublish)this.inboundQoS2.get(new Integer(message.getMessageId()));
                if (sendMsg != null) {
                    if (this.callback != null) {
                        this.callback.messageArrived(sendMsg);
                    }
                } else {
                    MqttPubComp pubComp = new MqttPubComp(message.getMessageId());
                    this.send(pubComp);
                }
            }
        }
    }

    public void connected() {
        this.trace.trace((byte)1, 631);
        this.connected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnecting(MqttException reason) {
        this.trace.trace((byte)1, 632, null, reason);
        Object object = this.queueLock;
        synchronized (object) {
            this.queueLock.notifyAll();
        }
        this.tokenStore.noMoreResponses(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected(MqttException reason) {
        this.trace.trace((byte)1, 633, null, reason);
        this.connected = false;
        Object object = this.queueLock;
        synchronized (object) {
            this.queueLock.notifyAll();
        }
        try {
            if (this.cleanSession) {
                this.clearState();
            }
            this.pendingMessages.clear();
            this.pendingFlows.clear();
            this.pingOutstanding = false;
            object = this.waitingTokensLock;
            synchronized (object) {
                if (this.trace.isOn()) {
                    this.trace.trace((byte)1, 634, new Object[]{new Integer(this.waitingTokens)});
                }
                while (this.waitingTokens > 0) {
                    try {
                        this.waitingTokensLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.trace.trace((byte)1, 635);
            this.persistence.close();
        }
        catch (MqttException mqttException) {
            // empty catch block
        }
    }

    private synchronized void releaseMessageId(int msgId) {
        this.inUseMsgIds.remove(new Integer(msgId));
    }

    private synchronized int getNextMessageId() throws MqttException {
        int startingMessageId = this.nextMsgId;
        int loopCount = 0;
        do {
            ++this.nextMsgId;
            if (this.nextMsgId > 65535) {
                this.nextMsgId = 1;
            }
            if (this.nextMsgId != startingMessageId || ++loopCount != 2) continue;
            throw ExceptionHelper.createMqttException(32001);
        } while (this.inUseMsgIds.containsKey(new Integer(this.nextMsgId)));
        Integer id = new Integer(this.nextMsgId);
        this.inUseMsgIds.put(id, id);
        return this.nextMsgId;
    }

    private void cleanUpQueue(Vector queue) {
        this.trace.trace((byte)1, 636);
        Enumeration e = queue.elements();
        MqttException ex = ExceptionHelper.createMqttException(32102);
        while (e.hasMoreElements()) {
            MqttWireMessage message = (MqttWireMessage)e.nextElement();
            MqttDeliveryTokenImpl token = this.tokenStore.getToken(message);
            Integer messageId = new Integer(message.getMessageId());
            if (this.outboundQoS2.containsKey(messageId)) {
                this.outboundQoS2.remove(messageId);
            }
            if (token != null) {
                token.notifyException(ex);
                this.tokenStore.removeToken(message);
            }
            queue.removeElement(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce(long timeout) {
        this.trace.trace((byte)1, 637, new Object[]{new Long(timeout)});
        if (timeout > 0L) {
            Object object = this.queueLock;
            synchronized (object) {
                this.quiescing = true;
            }
            this.callback.quiesce();
            object = this.queueLock;
            synchronized (object) {
                this.trace.trace((byte)1, 638);
                this.queueLock.notifyAll();
            }
            object = this.quiesceLock;
            synchronized (object) {
                try {
                    if (this.actualInFlight > 0 || this.pendingFlows.size() > 0 || this.inFlightPubRels > 0) {
                        if (this.trace.isOn()) {
                            this.trace.trace((byte)1, 639, new Object[]{new Integer(this.actualInFlight), new Integer(this.pendingFlows.size()), new Integer(this.inFlightPubRels)});
                        }
                        this.quiesceLock.wait(timeout);
                        this.trace.trace((byte)1, 640);
                    }
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            object = this.queueLock;
            synchronized (object) {
                this.cleanUpQueue(this.pendingMessages);
                this.cleanUpQueue(this.pendingFlows);
                this.quiescing = false;
                this.actualInFlight = 0;
            }
        }
    }

    protected void deliveryComplete(MqttPublish message) throws MqttPersistenceException {
        if (this.trace.isOn()) {
            this.trace.trace((byte)1, 641, new Object[]{new Integer(message.getMessageId())});
        }
        this.persistence.remove(this.getReceivedPersistenceKey(message));
        this.inboundQoS2.remove(new Integer(message.getMessageId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementWaitingTokens() {
        Object object = this.waitingTokensLock;
        synchronized (object) {
            ++this.waitingTokens;
            if (this.trace.isOn()) {
                this.trace.trace((byte)1, 642, new Object[]{new Integer(this.waitingTokens)});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementWaitingTokens() {
        Object object = this.waitingTokensLock;
        synchronized (object) {
            --this.waitingTokens;
            if (this.trace.isOn()) {
                this.trace.trace((byte)1, 643, new Object[]{new Integer(this.waitingTokens)});
            }
            if (this.waitingTokens == 0) {
                this.waitingTokensLock.notifyAll();
            }
        }
    }
}

