/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.MqttDeliveryTokenImpl;
import org.eclipse.paho.client.mqttv3.internal.trace.Trace;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnack;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttInputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class CommsReceiver
implements Runnable {
    private boolean running = false;
    private Object lifecycle = new Object();
    private ClientState clientState = null;
    private ClientComms clientComms = null;
    private MqttInputStream in;
    private CommsTokenStore tokenStore = null;
    private boolean disconnecting = false;
    private Trace trace;

    public CommsReceiver(Trace trace, ClientComms clientComms, ClientState clientState, CommsTokenStore tokenStore, InputStream in) {
        this.in = new MqttInputStream(in);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = tokenStore;
        this.trace = trace;
    }

    public void start() {
        if (!this.running) {
            this.running = true;
            new Thread((Runnable)this, "MQTT Client Comms Receiver").start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        Object object = this.lifecycle;
        synchronized (object) {
            this.trace.trace((byte)1, 850);
            if (this.running) {
                this.running = false;
                try {
                    this.trace.trace((byte)1, 851);
                    this.lifecycle.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.running && this.in != null) {
            try {
                this.trace.trace((byte)1, 852);
                MqttWireMessage message = this.in.readMqttWireMessage();
                if (message instanceof MqttAck) {
                    MqttDeliveryTokenImpl token = this.tokenStore.getToken(message);
                    if (token != null) {
                        MqttDeliveryTokenImpl mqttDeliveryTokenImpl = token;
                        synchronized (mqttDeliveryTokenImpl) {
                            this.clientState.notifyReceived(message);
                            if (message instanceof MqttConnack && ((MqttConnack)message).getReturnCode() != 0) {
                                Object object = this.lifecycle;
                                synchronized (object) {
                                    this.running = false;
                                }
                            }
                            continue;
                        }
                    }
                    this.clientState.notifyReceived(message);
                    continue;
                }
                this.clientState.notifyReceived(message);
            }
            catch (MqttException ex) {
                this.running = false;
                this.clientComms.shutdownConnection(ex);
            }
            catch (IOException ioe) {
                this.trace.trace((byte)1, 853, null, ioe);
                this.running = false;
                if (!this.disconnecting) {
                    this.clientComms.shutdownConnection(new MqttException(32109, (Throwable)ioe));
                    continue;
                }
                this.clientComms.shutdownConnection(null);
            }
        }
        Object object = this.lifecycle;
        synchronized (object) {
            this.trace.trace((byte)1, 854);
            this.lifecycle.notifyAll();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setDisconnecting(boolean disconnecting) {
        this.trace.trace((byte)1, 855, new Object[]{new Boolean(disconnecting)});
        this.disconnecting = disconnecting;
    }
}

