/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.trace.Trace;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttOutputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class CommsSender
implements Runnable {
    private boolean running = false;
    private Object lifecycle = new Object();
    private ClientState clientState = null;
    private MqttOutputStream out;
    private ClientComms clientComms = null;
    private CommsTokenStore tokenStore = null;
    private Trace trace;

    public CommsSender(Trace trace, ClientComms clientComms, ClientState clientState, CommsTokenStore tokenStore, OutputStream out) {
        this.trace = trace;
        this.out = new MqttOutputStream(out);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = tokenStore;
    }

    public void start() {
        if (!this.running) {
            this.running = true;
            new Thread((Runnable)this, "MQTT Client Comms Sender").start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        Object object = this.lifecycle;
        synchronized (object) {
            this.trace.trace((byte)1, 800);
            if (this.running) {
                this.running = false;
                try {
                    this.trace.trace((byte)1, 801);
                    this.lifecycle.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        MqttWireMessage message = null;
        while (this.running && this.out != null) {
            Object object;
            try {
                Object token;
                this.trace.trace((byte)1, 802);
                message = this.clientState.get();
                if (message != null) {
                    if (message instanceof MqttAck) {
                        this.out.write(message);
                        this.out.flush();
                    } else {
                        object = token = this.tokenStore.getToken(message);
                        synchronized (object) {
                            this.out.write(message);
                            this.out.flush();
                            this.clientState.notifySent(message);
                        }
                    }
                    if (!(message instanceof MqttDisconnect)) continue;
                    token = this.lifecycle;
                    synchronized (token) {
                        this.trace.trace((byte)1, 803);
                        this.running = false;
                        continue;
                    }
                }
                token = this.lifecycle;
                synchronized (token) {
                    this.running = false;
                }
            }
            catch (MqttException me) {
                object = this.lifecycle;
                synchronized (object) {
                    this.running = false;
                }
                this.clientComms.shutdownConnection(me);
            }
            catch (Exception ioe) {
                this.trace.trace((byte)1, 804, null, ioe);
                if (message != null && message instanceof MqttDisconnect) {
                    this.clientState.notifySent(message);
                }
                this.running = false;
                this.clientComms.shutdownConnection(new MqttException(32109, (Throwable)ioe));
            }
        }
        Object object = this.lifecycle;
        synchronized (object) {
            this.trace.trace((byte)1, 805);
            this.lifecycle.notifyAll();
        }
    }

    public boolean isRunning() {
        return this.running;
    }
}

