/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.MqttDeliveryTokenImpl;
import org.eclipse.paho.client.mqttv3.internal.trace.Trace;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnack;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPingReq;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPingResp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRel;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class CommsTokenStore {
    private Hashtable tokens = new Hashtable();
    private MqttDeliveryTokenImpl pingToken;
    private MqttDeliveryTokenImpl connectToken;
    private MqttDeliveryTokenImpl disconnectToken;
    private MqttException noMoreResponsesException = null;
    private boolean noMoreResponses = false;
    private Trace trace;

    public CommsTokenStore(Trace trace) {
        this.trace = trace;
        this.pingToken = new MqttDeliveryTokenImpl(trace);
        this.connectToken = new MqttDeliveryTokenImpl(trace);
        this.disconnectToken = new MqttDeliveryTokenImpl(trace);
    }

    public MqttDeliveryTokenImpl getToken(MqttWireMessage message) {
        if (message instanceof MqttAck) {
            return this.getTokenForAck((MqttAck)message);
        }
        Object key = message instanceof MqttPingReq ? this.pingToken : (message instanceof MqttConnect ? this.connectToken : (message instanceof MqttDisconnect ? this.disconnectToken : new Integer(message.getMessageId())));
        return (MqttDeliveryTokenImpl)this.tokens.get(key);
    }

    private MqttDeliveryTokenImpl getTokenForAck(MqttWireMessage message) {
        MqttDeliveryTokenImpl token = message instanceof MqttPingResp ? this.pingToken : (message instanceof MqttConnack ? this.connectToken : (MqttDeliveryTokenImpl)this.tokens.get(new Integer(message.getMessageId())));
        return token;
    }

    public MqttDeliveryTokenImpl removeToken(MqttWireMessage message) {
        Object key = message instanceof MqttConnack ? this.connectToken : (message instanceof MqttDisconnect ? this.disconnectToken : new Integer(message.getMessageId()));
        if (this.trace.isOn()) {
            this.trace.trace((byte)1, 301, new Object[]{message, key});
        }
        return (MqttDeliveryTokenImpl)this.tokens.remove(key);
    }

    protected MqttDeliveryTokenImpl restoreToken(MqttPublish message) {
        MqttDeliveryTokenImpl token;
        Integer key = new Integer(message.getMessageId());
        if (this.tokens.containsKey(key)) {
            token = (MqttDeliveryTokenImpl)this.tokens.get(key);
            if (this.trace.isOn()) {
                this.trace.trace((byte)1, 302, new Object[]{message, key, token});
            }
        } else {
            token = new MqttDeliveryTokenImpl(this.trace, message);
            this.tokens.put(key, token);
            if (this.trace.isOn()) {
                this.trace.trace((byte)1, 303, new Object[]{message, key, token});
            }
        }
        return token;
    }

    protected MqttDeliveryTokenImpl saveToken(MqttWireMessage message) {
        Object key;
        MqttDeliveryTokenImpl token;
        if (message instanceof MqttPingReq) {
            token = this.pingToken;
            key = token;
        } else if (message instanceof MqttConnect) {
            this.noMoreResponses = false;
            this.noMoreResponsesException = null;
            token = this.connectToken = new MqttDeliveryTokenImpl(this.trace);
            key = token;
        } else if (message instanceof MqttDisconnect) {
            token = this.disconnectToken = new MqttDeliveryTokenImpl(this.trace);
            key = token;
        } else if (message instanceof MqttPubRel) {
            key = new Integer(message.getMessageId());
            token = this.getToken(message);
        } else if (message instanceof MqttPublish) {
            key = new Integer(message.getMessageId());
            token = new MqttDeliveryTokenImpl(this.trace, (MqttPublish)message);
        } else {
            key = new Integer(message.getMessageId());
            token = new MqttDeliveryTokenImpl(this.trace);
        }
        if (this.trace.isOn()) {
            this.trace.trace((byte)1, 300, new Object[]{message, key, token.toString()});
        }
        this.tokens.put(key, token);
        if (this.noMoreResponses) {
            token.notifyException(this.noMoreResponsesException);
        }
        return token;
    }

    protected void responseReceived(MqttAck ack) {
        MqttDeliveryTokenImpl token = this.getTokenForAck(ack);
        this.removeToken(ack);
        if (token != null) {
            token.notifyReceived(ack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void noMoreResponses(MqttException reason) {
        this.noMoreResponses = true;
        this.noMoreResponsesException = reason;
        Enumeration enumeration = this.tokens.elements();
        this.trace.trace((byte)1, 304, null, reason);
        while (enumeration.hasMoreElements()) {
            Object token = enumeration.nextElement();
            if (token == null) continue;
            Object v = token;
            synchronized (v) {
                ((MqttDeliveryTokenImpl)token).notifyException(reason);
            }
        }
    }

    public MqttDeliveryToken[] getOutstandingTokens() {
        Vector<MqttDeliveryToken> list = new Vector<MqttDeliveryToken>();
        Enumeration enumeration = this.tokens.elements();
        while (enumeration.hasMoreElements()) {
            MqttDeliveryToken token = (MqttDeliveryToken)enumeration.nextElement();
            if (token == null || token.equals(this.pingToken) || token.equals(this.connectToken) || token.equals(this.disconnectToken)) continue;
            list.addElement(token);
        }
        MqttDeliveryToken[] result = new MqttDeliveryToken[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = (MqttDeliveryToken)list.elementAt(i);
        }
        return result;
    }

    public void clear() {
        this.trace.trace((byte)1, 305);
        this.tokens.clear();
    }
}

