/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;

public class FileLock {
    private RandomAccessFile file;
    private Object fileLock;

    public FileLock(File lockFile) throws Exception {
        if (ExceptionHelper.isClassAvailable("java.nio.channels.FileLock")) {
            try {
                this.file = new RandomAccessFile(lockFile, "rw");
                Method m = this.file.getClass().getMethod("getChannel", new Class[0]);
                Object channel = m.invoke((Object)this.file, new Object[0]);
                m = channel.getClass().getMethod("tryLock", new Class[0]);
                this.fileLock = m.invoke(channel, new Object[0]);
                this.file.close();
            }
            catch (NoSuchMethodException nsme) {
                this.fileLock = null;
            }
            catch (IllegalArgumentException iae) {
                this.fileLock = null;
            }
            catch (IllegalAccessException iae) {
                this.fileLock = null;
            }
        }
    }

    public void release() {
        try {
            if (this.fileLock != null) {
                Method m = this.fileLock.getClass().getMethod("release", new Class[0]);
                m.invoke(this.fileLock, new Object[0]);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

