/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class MqttConnect
extends MqttWireMessage {
    private String clientId;
    private boolean cleanSession;
    private MqttMessage willMessage;
    private String userName;
    private char[] password;
    private int keepAliveInterval;
    private MqttTopic willDestination;

    public MqttConnect(String clientId, boolean cleanSession, int keepAliveInterval, String userName, char[] password, MqttMessage willMessage, MqttTopic willDestination) {
        super((byte)1);
        this.clientId = clientId;
        this.cleanSession = cleanSession;
        this.keepAliveInterval = keepAliveInterval;
        this.userName = userName;
        this.password = password;
        this.willMessage = willMessage;
        this.willDestination = willDestination;
    }

    protected byte getMessageInfo() {
        return 0;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeUTF("MQIsdp");
            dos.write(3);
            int connectFlags = 0;
            if (this.cleanSession) {
                connectFlags = (byte)(connectFlags | 2);
            }
            if (this.willMessage != null) {
                connectFlags = (byte)(connectFlags | 4);
                connectFlags = (byte)(connectFlags | this.willMessage.getQos() << 3);
                if (this.willMessage.isRetained()) {
                    connectFlags = (byte)(connectFlags | 0x20);
                }
            }
            if (this.userName != null) {
                connectFlags = (byte)(connectFlags | 0x80);
                if (this.password != null) {
                    connectFlags = (byte)(connectFlags | 0x40);
                }
            }
            dos.write(connectFlags);
            dos.writeShort(this.keepAliveInterval);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    public byte[] getPayload() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeUTF(this.clientId);
            if (this.willMessage != null) {
                dos.writeUTF(this.willDestination.getName());
                dos.writeShort(this.willMessage.getPayload().length);
                dos.write(this.willMessage.getPayload());
            }
            if (this.userName != null) {
                dos.writeUTF(this.userName);
                if (this.password != null) {
                    dos.writeUTF(new String(this.password));
                }
            }
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    public boolean isMessageIdRequired() {
        return false;
    }
}

