package com.example.fcm;

import android.os.AsyncTask;
import okhttp3.*;
import org.json.JSONObject;
import java.io.IOException;

public class FcmHttpV1Sender {

    private static final String FCM_BASE_URL = "https://fcm.googleapis.com/v1/projects/YOUR_PROJECT_ID/messages:send";
    private static final MediaType JSON = MediaType.get("application/json; charset=utf-8");
    
    private String oauthToken;
    private OkHttpClient client = new OkHttpClient();

    public FcmHttpV1Sender(String oauthToken) {
        this.oauthToken = oauthToken;
    }

    public void sendPushNotification(String token, String title, String body, String imageUrl) {
        new SendPushNotificationTask().execute(token, title, body, imageUrl);
    }

    private class SendPushNotificationTask extends AsyncTask<String, Void, Void> {

        @Override
        protected Void doInBackground(String... params) {
            String token = params[0];
            String title = params[1];
            String body = params[2];
            String imageUrl = params[3];

            try {
                JSONObject notification = new JSONObject();
                notification.put("title", title);
                notification.put("body", body);

                if (imageUrl != null && !imageUrl.isEmpty()) {
                    notification.put("image", imageUrl);
                }

                JSONObject message = new JSONObject();
                message.put("token", token);
                message.put("notification", notification);

                JSONObject payload = new JSONObject();
                payload.put("message", message);

                RequestBody requestBody = RequestBody.create(JSON, payload.toString());
                Request request = new Request.Builder()
                        .url(FCM_BASE_URL)
                        .post(requestBody)
                        .addHeader("Authorization", "Bearer " + oauthToken)
                        .addHeader("Content-Type", "application/json; UTF-8")
                        .build();

                Response response = client.newCall(request).execute();

                if (response.isSuccessful()) {
                    System.out.println("Notification sent successfully.");
                } else {
                    System.out.println("Failed to send notification: " + response.body().string());
                }

            } catch (Exception e) {
                e.printStackTrace();
            }

            return null;
        }
    }
}
