package com.example.fcm;

import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import com.google.firebase.messaging.FirebaseMessaging;
import java.io.IOException;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // Firebase Messaging Service to get the device token
        FirebaseMessaging.getInstance().getToken().addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                String token = task.getResult();

                try {
                    // Get the OAuth token
                    String oauthToken = GoogleAuthTokenGenerator.getAccessToken();

                    // Send a push notification with the device FCM token
                    FcmHttpV1Sender sender = new FcmHttpV1Sender(oauthToken);
                    sender.sendPushNotification(token, "Hello", "This is a test push notification", "https://example.com/image.jpg");

                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}
