# Mars App iOS

안드로이드 앱을 iOS로 변환한 프로젝트입니다.

## 주요 기능

- 웹뷰 기반 앱
- 카카오 로그인 연동
- 사용자 정보 관리
- JavaScript 인터페이스

## 설치 방법

### 요구 사항

- Xcode 12.0 이상
- iOS 13.0 이상
- CocoaPods

### 설치 단계

1. 저장소 클론
```bash
git clone <repository-url>
cd MarsApp
```

2. CocoaPods 의존성 설치
```bash
pod install
```

3. `MarsApp.xcworkspace` 파일을 Xcode로 열기

4. 카카오 개발자 계정에서 앱 등록 및 키 발급
   - [카카오 개발자 사이트](https://developers.kakao.com)에서 앱 등록
   - 발급받은 네이티브 앱 키를 프로젝트에 적용

5. 다음 파일에서 `YOUR_KAKAO_APP_KEY`를 실제 앱 키로 변경:
   - `AppDelegate.swift`
   - `Info.plist`

6. 빌드 및 실행

## 프로젝트 구조

- `AppDelegate.swift`: 앱 진입점 및 카카오 SDK 초기화
- `SceneDelegate.swift`: iOS 13 이상의 씬 관리
- `MainViewController.swift`: 메인 화면 및 웹뷰 관리
- `KakaoLogin.swift`: 카카오 로그인 처리
- `Info.plist`: 앱 설정 정보

## 주의 사항

- 카카오 로그인을 사용하려면 Info.plist에 URL 스킴 설정이 필요합니다.
- 웹뷰에서 JavaScript 인터페이스를 사용하려면 웹 페이지에서 다음과 같이 호출해야 합니다:
  ```javascript
  window.webkit.messageHandlers.appInterface.postMessage({action: "openKakaoLogin"});
  ```

## 라이센스

이 프로젝트는 MIT 라이센스 하에 배포됩니다. 