import UIKit
import KakaoSDKAuth

@available(iOS 13.0, *)
class SceneDelegate: UIResponder, UIWindowSceneDelegate {

    var window: UIWindow?

    func scene(_ scene: UIScene, willConnectTo session: UISceneSession, options connectionOptions: UIScene.ConnectionOptions) {
        guard let windowScene = (scene as? UIWindowScene) else { return }
        
        // 윈도우 설정
        window = UIWindow(windowScene: windowScene)
        
        // 메인 뷰 컨트롤러 설정
        let mainViewController = MainViewController()
        window?.rootViewController = mainViewController
        window?.makeKeyAndVisible()
        
        // AppDelegate에 웹뷰 참조 저장
        if let appDelegate = UIApplication.shared.delegate as? AppDelegate {
            appDelegate.webView = mainViewController.webView
        }
    }
    
    // 카카오 로그인 처리를 위한 URL 스킴 처리
    func scene(_ scene: UIScene, openURLContexts URLContexts: Set<UIOpenURLContext>) {
        if let url = URLContexts.first?.url {
            if AuthApi.isKakaoTalkLoginUrl(url) {
                _ = AuthController.handleOpenUrl(url: url)
            }
        }
    }

    func sceneDidDisconnect(_ scene: UIScene) {
        // 씬이 연결 해제될 때 호출
    }

    func sceneDidBecomeActive(_ scene: UIScene) {
        // 씬이 활성화될 때 호출
    }

    func sceneWillResignActive(_ scene: UIScene) {
        // 씬이 비활성화될 때 호출
    }

    func sceneWillEnterForeground(_ scene: UIScene) {
        // 앱이 포그라운드로 들어갈 때 호출
    }

    func sceneDidEnterBackground(_ scene: UIScene) {
        // 앱이 백그라운드로 들어갈 때 호출
    }
} 