package mars.mobile;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Build;
//import android.support.v4.content.ContextCompat;

import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowInsetsController;
import android.view.WindowManager;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.FrameLayout;

import static android.content.pm.ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE;
//import static com.kakao.auth.KakaoSDK.getCurrentActivity;

public abstract class ChromeClient extends WebChromeClient {
    private Activity mActivity = null;

    public static View mCustomView;
    private WebChromeClient.CustomViewCallback mCustomViewCallback;
    private int mOriginalOrientation;

    private FrameLayout mFullscreenContainer;

    private static final FrameLayout.LayoutParams COVER_SCREEN_PARAMS = new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
    public static boolean hided_custeomview = false;

    public ChromeClient(Activity activity) {
        this.mActivity = activity;
    }

    @Override
    public void onShowCustomView(View view, CustomViewCallback callback) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.ICE_CREAM_SANDWICH) {
            if (mCustomView != null) {
                callback.onCustomViewHidden();
                return;
            }

            mOriginalOrientation = mActivity.getRequestedOrientation();
            FrameLayout decor = (FrameLayout) mActivity.getWindow().getDecorView();
            mFullscreenContainer = new FullscreenHolder(mActivity);
            mFullscreenContainer.addView(view, COVER_SCREEN_PARAMS);
            decor.addView(mFullscreenContainer, COVER_SCREEN_PARAMS);
            mCustomView = view;
            mCustomView.setPadding(0, 0, 100, 0);
            setFullscreen(true);
            mCustomViewCallback = callback;
//         mActivity.setRequestedOrientation(requestedOrientation);
            mActivity.setRequestedOrientation(SCREEN_ORIENTATION_LANDSCAPE);

        }

        super.onShowCustomView(view, callback);
    }

    @SuppressWarnings("deprecation")
    @Override
    public void onShowCustomView(View view, int requestedOrientation, WebChromeClient.CustomViewCallback callback) {
        this.onShowCustomView(view, callback);
    }

    @Override
    public void onHideCustomView() {
        Log.d("bb","onHideCustomView called" );
        if (mCustomView == null) {
            return;
        }

        setFullscreen(false);
        FrameLayout decor = (FrameLayout) mActivity.getWindow().getDecorView();
        decor.removeView(mFullscreenContainer);
        mFullscreenContainer = null;
        mCustomView = null;
        mCustomViewCallback.onCustomViewHidden();
        mActivity.setRequestedOrientation(mOriginalOrientation);


    }

    private void setFullscreen(boolean enabled) {

        if(enabled) hided_custeomview = false;
        else hided_custeomview = true;
        Window win = mActivity.getWindow();
        WindowManager.LayoutParams winParams = win.getAttributes();
        final int bits = WindowManager.LayoutParams.FLAG_FULLSCREEN;


        if (enabled) {
            winParams.flags |= bits;
        } else {
            winParams.flags &= ~bits;
            if (mCustomView != null) {
               mCustomView.setSystemUiVisibility(View.SYSTEM_UI_FLAG_VISIBLE);
//                mCustomView.setSystemUiVisibility(View.SYSTEM_UI_FLAG_VISIBLE | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
//                        | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
//                        | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
//                        | View.SYSTEM_UI_FLAG_FULLSCREEN
//                        | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
                // win.clearFlags(bits);
            }
        }
        win.setAttributes(winParams);
    }


   // public int getNaviBarHeight(){
   //     int result = 0;
   //     Resources resources = getCurrentActivity().getApplicationContext().getResources();
    //    int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
   //     if (resourceId > 0) {
    //        result = resources.getDimensionPixelSize(resourceId);
     //   }
    //    return result;
    //}

    public int getNaviBarHeight() {
        int result = 0;
        // Context를 mActivity로 대체
        Resources resources = mActivity.getApplicationContext().getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = resources.getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public abstract void doUpdateVisitedHistory(WebView view,
                                                String url,
                                                boolean isReload);

    private static class FullscreenHolder extends FrameLayout {
        public FullscreenHolder(Context ctx) {
            super(ctx);
            setBackgroundColor(Color.parseColor("#000000"));
          //  setBackgroundColor(android.R.color.black);
        }

        @Override
        public boolean onTouchEvent(MotionEvent evt) {
            return true;
        }
    }
}