/*
 * Copyright (c) 2018. Lorem ipsum dolor sit amet, consectetur adipiscing elit.
 * Morbi non lorem porttitor neque feugiat blandit. Ut vitae ipsum eget quam lacinia accumsan.
 * Etiam sed turpis ac ipsum condimentum fringilla. Maecenas magna.
 * Proin dapibus sapien vel ante. Aliquam erat volutpat. Pellentesque sagittis ligula eget metus.
 * Vestibulum commodo. Ut rhoncus gravida arcu.
 */

package mars.mobile;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DBHelper extends SQLiteOpenHelper {
    public DBHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
    }

    @Override
    public void onCreate(SQLiteDatabase sqLiteDatabase) {

        sqLiteDatabase.execSQL("CREATE TABLE MONEYBOOK (_id INTEGER PRIMARY KEY AUTOINCREMENT, message TEXT, title TEXT, imgurl TEXT, weblink TEXT,create_at Date);");

    }


    // DB 업그레이드를 위해 버전이 변경될 때 호출되는 함수
    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {

    }

    public void insert(String message ,String title, String imgurl, String weburl, String create_at) {
        // 읽고 쓰기가 가능하게 DB 열기
        SQLiteDatabase db = getWritableDatabase();
        // DB에 입력한 값으로 행 추가
        db.execSQL("INSERT INTO MONEYBOOK VALUES(null, '" + message + "', " +"'"+ title +"'"+ ", '"+imgurl+"','"+weburl+"','" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "');");// 두개 추가해야 한다
        db.close();
    }

    public void update(String item, int price) {
        SQLiteDatabase db = getWritableDatabase();
        // 입력한 항목과 일치하는 행의 가격 정보 수정
        db.execSQL("UPDATE MONEYBOOK SET price=" + price + " WHERE item='" + item + "';");
        db.close();
    }

    public void delete(String item) {
        SQLiteDatabase db = getWritableDatabase();
        // 입력한 항목과 일치하는 행 삭제
        db.execSQL("DELETE FROM MONEYBOOK WHERE item='" + item + "';");
        db.close();
    }

    public String getResult() {
        // 읽기가 가능하게 DB 열기
        SQLiteDatabase db = getReadableDatabase();
        String result = "";

        // DB에 있는 데이터를 쉽게 처리하기 위해 Cursor를 사용하여 테이블에 있는 모든 데이터 출력
        Cursor cursor = db.rawQuery("SELECT * FROM MONEYBOOK  order by _id desc limit 10", null);
        String replasce_img;
        while (cursor.moveToNext()) {
            if(cursor.getString(3)!=null) {
                //이미지 주소는 1
                 replasce_img = cursor.getString(3);
              //  replasce_img="https://www.google.co.kr/images/branding/googlelogo/2x/googlelogo_color_272x92dp.png";
            }else replasce_img=null;
            String title=null,message = null;
            try {
                message=URLDecoder.decode( cursor.getString(1),  "UTF-8");
                title=URLDecoder.decode( cursor.getString(2),  "UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if(!TextUtils.isEmpty(replasce_img)) {
                result += "<p>"+cursor.getString(0)
                        + " : 제목 <"
                        + title+"></p>\n"
                        + "<p>"+ message+"</p>"
                        //+"<p><img alt=\\\"\\\" src=\\\""+replasce_img+"\\\" style=\\\"height:1024px; width:512px\\\" /></p>"
                        + "<p><img alt=\\\"\\\" src=\"" + replasce_img + "\" style=\\\"height:1024px; width:512px\\\" /></p>"
                        + "<p>사진 "
                        + cursor.getString(3)
                        + "</p><p><a href=\""
                        + cursor.getString(4)
                        + "\">" + "<b>"+cursor.getString(4)+"</b>" + "</a></p>\n"
                        + "수신날짜 "+cursor.getString(5)
                        +"<p></p><p></p>"+"\n"+"\n";
                //+"<p><img align=center src=http://ebadatv.com/images/underline.jpeg></p>"+"\n";
            }else  {
                result += "<p>"+cursor.getString(0)
                        + " : 제목 < "
                        + title+"></p>\n"
                        + message+"\n"
                        + "<p><a href=\""
                        + cursor.getString(4)
                        + "\">" + "<b>"+cursor.getString(4)+"</b>" + "</a></p>\n"
                        + "수신날짜 "+cursor.getString(5)
                        +"<p></p><p></p>"+"\n";
            }
        }

        return result;
    }



}
