package mars.mobile;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import android.util.Log;
import android.webkit.JavascriptInterface;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;


public class Mainlaw extends AppCompatActivity {

    private static WebView webView;
    private SharedPreferences prefs;
    private String TAG="Mainlaw";

    @Override
    protected void onDestroy() {
        super.onDestroy();
         /*  prefs = getSharedPreferences("pref", Context.MODE_PRIVATE);
           SharedPreferences.Editor editor = prefs.edit();
           if(!prefs.getBoolean("law_agree", false))//수신동의창 창을 백버튼으로 닫아 버리는 경우 수신 비동의로 간주
           editor.putBoolean("law_agree", false);

           editor.commit();*/
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_mainlaw);
        getSupportActionBar().setTitle(getResources().getString(R.string.app_name));
        webView = (WebView)findViewById(R.id.webView_law);
      ///  webView.loadUrl(getString(R.string.lawurl));
        //mainlaw 페이지 실행 안하고 바로 엑티비티 실행
        Intent returnIntent = new Intent();
        returnIntent.putExtra("result","agree");
        setResult(Activity.RESULT_OK,returnIntent);
        finish();



        webView.addJavascriptInterface(new WebAppInterface(this), "Android");
        WebSettings set = webView.getSettings();
        set.setJavaScriptEnabled(true);
        set.setJavaScriptCanOpenWindowsAutomatically(true);
        webView.getSettings().setSupportMultipleWindows(true);// webcronclient 의 oncreatewindow 연동
        webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
     // set.setTextSize(WebSettings.TextSize.NORMAL);

        webView.setWebChromeClient(new ChromeClient(this) {

            @Override
            public void doUpdateVisitedHistory(WebView view, String url, boolean isReload) {

            }
        });

        webView.setWebViewClient(new WebViewClient() {
        });

    }


        public class WebAppInterface {
        Context mContext;
        /** Instantiate the interface and set the context */
        WebAppInterface(Context c) {
            mContext = c;
        }

        /** Show a toast from the web page */
        @JavascriptInterface
        public void showToast(String toast) {
            Toast.makeText(mContext, toast, Toast.LENGTH_SHORT).show();
        }

        @JavascriptInterface
        public  void select_tag_excute(String string_check) {
             Log.d(TAG, string_check + " x string_check called");
            prefs = getSharedPreferences("pref", Context.MODE_PRIVATE);
            SharedPreferences.Editor editor = prefs.edit();
            if(string_check.equalsIgnoreCase("agree")==true) {
                Log.d(TAG, string_check + " 1string_check called");
                editor.putBoolean("law_agree", true);
                editor.commit();
                Log.d(TAG,"agree pushed");
                Intent returnIntent = new Intent();
                returnIntent.putExtra("result","agree");
                setResult(Activity.RESULT_OK,returnIntent);
                finish();

                Log.d(TAG, "law_agree=" + prefs.getBoolean("law_agree", false));



            }else if(string_check.equalsIgnoreCase("deny")==true){
                Log.d(TAG, string_check + " 2string_check called");
                editor.putBoolean("law_agree", false);
                editor.commit();

                Intent returnIntent = new Intent();
                setResult(Activity.RESULT_CANCELED, returnIntent);
                finish();
            }

            if(Build.VERSION.SDK_INT<23) {
                Intent intent = new Intent(mContext, MainActivity.class);
                mContext.startActivity(intent);
            }
        }
    }
}
