package mars.mobile;

import android.app.Dialog;
import android.content.SharedPreferences;
import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.Switch;
import android.widget.Toast;

import java.text.SimpleDateFormat;
import java.util.Date;

public class SettingActivity extends AppCompatActivity {
    Switch settings_swtich_push1,settings_swtich_push2,settings_swtich_push3,settings_swtich_push4,settings_swtich_push5,settings_swtich_push6;
    SharedPreferences prefs = null;
    SharedPreferences.Editor edit = null;
    String TAG= "SettingActivity";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.p_setting);
        this.setTitle("푸시 알람 설정");
        prefs = getSharedPreferences("pref", MODE_PRIVATE);
        edit = prefs.edit();

        settings_swtich_push1 = (Switch) findViewById(R.id.switch1);
        settings_swtich_push2 = (Switch) findViewById(R.id.switch2);
        settings_swtich_push3 = (Switch) findViewById(R.id.switch3);
        settings_swtich_push4 = (Switch) findViewById(R.id.switch4);
        settings_swtich_push5 = (Switch) findViewById(R.id.switch5);
        settings_swtich_push6 = (Switch) findViewById(R.id.switch6);

        if(prefs.getBoolean("nomal_push_value", true))   settings_swtich_push1.setChecked(true); // 수신에 체크가 안되있다면 true;
        else   settings_swtich_push1.setChecked(false);

        if(prefs.getBoolean("ad_push_value", true))   settings_swtich_push2.setChecked(true); // 수신에 체크가 안되있다면 true;
        else   settings_swtich_push2.setChecked(false);
      

        if(prefs.getBoolean("is_now_susin_sound", true))   settings_swtich_push6.setChecked(true); // 수신에 체크가 안되있다면 true;
        else   settings_swtich_push6.setChecked(false);

        if(prefs.getBoolean("is_now_susin_vibe", false))   settings_swtich_push4.setChecked(true); // 수신에 체크가 안되있다면 true;
        else   settings_swtich_push4.setChecked(false);

        if(prefs.getBoolean("is_now_susin_toast", false))   settings_swtich_push3.setChecked(true); // 수신에 체크가 안되있다면 true;
        else   settings_swtich_push3.setChecked(false);



        //일반 푸시 설정
        settings_swtich_push1.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener()
        {
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) //Line A
            {
      

                if(isChecked) {
                    Log.d("TAG","true");                  
                    edit.putBoolean("nomal_push_value", true);//설정함

                }
                else {
                    Log.d("TAG", "faslse");                   
                    settings_swtich_push2.setChecked(false);// 광고도 off
                    edit.putBoolean("nomal_push_value", false);//거부함
                }

                edit.commit();

            }
        });

    //광고 푸시 설정
        settings_swtich_push2.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener()
        {
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) //Line A
            {


                if(isChecked) {
                    MyCustomAlertDialog();
                    Log.d("TAG","true");                   

                }
                else {
                    Log.d("TAG", "faslse");
                    edit.putBoolean("ad_push_value", false);                
                }

                edit.commit();

            }
        });

        
        
        
        
        
        
        
        settings_swtich_push3.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener()
        {
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) //Line A
            {


                if(isChecked) {
                    Log.d("TAG","true");
                    edit.putBoolean("is_now_susin_sound", true);
                }
                else {
                    Log.d("TAG", "faslse");
                    edit.putBoolean("is_now_susin_sound", false);
                }

                edit.commit();

            }
        });

        settings_swtich_push4.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener()
        {
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) //Line A
            {


                if(isChecked) {
                    Log.d("TAG","true");
                    edit.putBoolean("is_now_susin_vibe", true);
                    edit.putBoolean("is_now_susin_sound", false);
                }
                else {
                    Log.d("TAG", "faslse");
                    edit.putBoolean("is_now_susin_vibe", false);
                    edit.putBoolean("is_now_susin_sound", true);
                }

                edit.commit();

            }
        });

        settings_swtich_push5.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener()
        {
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) //Line A
            {


                if(isChecked) {
                    Log.d("TAG","true");
                    edit.putBoolean("is_now_susin_toast", true);
                }
                else {
                    Log.d("TAG", "faslse");
                    edit.putBoolean("is_now_susin_toast", false);
                }

                edit.commit();

            }
        });

       



    }

    private void MyCustomAlertDialog() {

        final Dialog MyDialog = new Dialog(SettingActivity.this);
        MyDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        MyDialog.setContentView(R.layout.customdialog_push_question);
        MyDialog.setTitle("메시지");
        MyDialog.setCancelable(false);
        MyDialog.getWindow().getAttributes().windowAnimations = R.style.DialogSlide;

        Button hello = (Button)MyDialog.findViewById(R.id.hello);
        Button close = (Button)MyDialog.findViewById(R.id.close);

        hello.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //Toast.makeText(getApplicationContext(), "Hello, I'm Custom Alert Dialog", Toast.LENGTH_LONG).show();
                //finish();
                //미동의
                settings_swtich_push2.setChecked(false); 
                edit.putBoolean("ad_push_value", false);
                edit.commit();
                MyDialog.dismiss();               
                
            }
        });
        close.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                MyDialog.cancel();
                Log.d("TAG","dialog agreed");
                //동의
                edit.putBoolean("ad_push_value", true);
                edit.commit();

                long now = System.currentTimeMillis();
                Date date = new Date(now);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
                String getTime = sdf.format(date);
                Toast.makeText(getApplicationContext(), getTime+"에 수신동의 처리 되었습니다", Toast.LENGTH_LONG).show();
            }
        });

        MyDialog.show();
    }



}
