package mars.mobile;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.AsyncTask;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import org.apache.http.HttpResponse;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

import static mars.mobile.MainActivity.prefs;

public class message_popup_Activity extends AppCompatActivity {
    private ImageView img;
    private String p_messsage=null,weblink,imgUrl,subject,arg1;
    private String TAG="message_popup_Activity";
    private Bitmap imgBitmap;
    private URL url;
    private Dialog MyDialog;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_message_popup_);
        prefs =getSharedPreferences("pref", Context.MODE_PRIVATE);//
        p_messsage = prefs.getString("p_messsage", null);
        subject = prefs.getString("subject", null);
        weblink = prefs.getString("weblink", null);
        imgUrl = prefs.getString("imgUrl", null);
        arg1 = prefs.getString("arg1", null);
        if (imgUrl != null) new RetriveTweetTask().execute(imgUrl);

        MyPushCustomAlertDialog();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        MyDialog.dismiss();
    }

    private void MyPushCustomAlertDialog() {

         MyDialog = new Dialog(message_popup_Activity.this);
        MyDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        MyDialog.setContentView(R.layout.customdialog);
        MyDialog.setTitle("메시지");
        MyDialog.setCancelable(false);
        MyDialog.getWindow().getAttributes().windowAnimations = R.style.DialogSlide;

        Button hello = (Button)MyDialog.findViewById(R.id.hello);
        Button close = (Button)MyDialog.findViewById(R.id.close);
        TextView tv_subject = (TextView)MyDialog.findViewById(R.id.tv_subject);
        TextView tv_message = (TextView)MyDialog.findViewById(R.id.tv_message);
        TextView tv_weblink = (TextView)MyDialog.findViewById(R.id.tv_weblink);
        img = (ImageView)MyDialog.findViewById(R.id.img);
        tv_subject.setText(subject);
        tv_message.setText(p_messsage);
        tv_weblink.setText(weblink);
        Log.d(TAG,"imgUrl<==>"+imgUrl);
        if(imgUrl!=null)  img.setImageBitmap(imgBitmap);
        else img.setVisibility(View.GONE);
        hello.setEnabled(true);
        close.setEnabled(true);
        hello.setText("자세히 보기");


        hello.setOnClickListener(new View.OnClickListener() {
            @SuppressLint("SuspiciousIndentation")
            @Override
            public void onClick(View v) {

                try {
                    Intent intent = new Intent(getApplicationContext(),MainActivity.class);
                    if(weblink!=null)
                        intent.putExtra("url",weblink);
                    intent.putExtra("title", subject);
                    intent.putExtra("message", p_messsage);
                    intent.putExtra("arg1", arg1);
                    intent.putExtra("file_url", imgUrl);
                    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    MyDialog.cancel();

                    startActivity(intent);
                    finish();
                } catch (Exception e) {
                    e.printStackTrace();
                    Toast.makeText(getApplicationContext(), "오류가 발생했습니다.", Toast.LENGTH_SHORT).show();
                }



            }
        });
        close.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                MyDialog.cancel();

                finish();

            }
        });

        MyDialog.show();
    }

    // AsyncTask<Params,Progress,Result>
    public class RetriveTweetTask extends AsyncTask<String, Void, HttpResponse> {

        @Override
        protected HttpResponse doInBackground(String... urls) {



            try {
                Uri.parse("http://www.google.com");
                url = new URL(imgUrl);
                //  Log.d(TAG,file_url+"noti image pass1");

                URLConnection conn = url.openConnection();
                conn.connect();
                BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
                imgBitmap = BitmapFactory.decodeStream(bis);
                bis.close();
                Log.d(TAG,"noti image pass1");
            } catch (MalformedURLException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(HttpResponse result) {
            super.onPostExecute(result);
            if(imgUrl!=null)  img.setImageBitmap(imgBitmap);

        }
    }
    public void go_img_url(View v){
        Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(imgUrl));
        startActivity(intent);
    }


}
