# 알림이 안 가는 원인 분석

## 문제 상황
다음 특정 안드로이드 기기들에서만 FCM 알림이 수신되지 않음:

- 갤럭시 S25 울트라 (안드로이드 15)
- 갤럭시 S25+ (안드로이드 15)
- 갤럭시 S24 울트라 (가장 최신, 2일 전 업데이트)
- 갤럭시 Z 플립4
- 갤럭시 점프2
- 갤럭시 S23 (안드로이드 13)

## 현재 설정 확인

### FCM 버전
```gradle
implementation 'com.google.firebase:firebase-core:21.1.1'
implementation 'com.google.firebase:firebase-messaging:23.0.8'
```

- **firebase-messaging:23.0.8** (2023년 8월 릴리스)
- **firebase-core:21.1.1** (deprecated, 더 이상 사용되지 않음)

### Android 설정
- **compileSdk**: 34
- **targetSdk**: 34
- **minSdk**: 21

### Topic 구독
```java
FirebaseMessaging.getInstance().subscribeToTopic("news_test");
```

## 가능한 원인 분석

### 1. FCM SDK 버전 호환성 문제 ⚠️ **가장 유력**

**문제점:**
- `firebase-messaging:23.0.8`은 2023년 8월 버전으로, **안드로이드 15 (API 35)**와의 호환성 문제가 있을 수 있음
- 안드로이드 15는 2024년 10월에 출시되었으며, 최신 FCM SDK가 필요할 수 있음
- `firebase-core`는 deprecated되어 제거되었지만 여전히 사용 중

**해결 방안:**
- FCM SDK를 최신 버전으로 업데이트 (현재 최신: 24.x.x 이상)
- `firebase-core` 의존성 제거 (더 이상 필요 없음)

**권장 버전:**
```gradle
// firebase-core 제거
implementation 'com.google.firebase:firebase-messaging:24.0.0' // 또는 최신 버전
```

### 2. 안드로이드 15 (API 35) 호환성 문제

**문제점:**
- 안드로이드 15에서 알림 및 백그라운드 작업에 대한 새로운 제한사항이 도입됨
- FCM SDK 23.0.8은 안드로이드 15 출시 이전 버전으로, 새로운 API 변경사항을 반영하지 못했을 수 있음

**영향받는 기기:**
- 갤럭시 S25 울트라 (안드로이드 15)
- 갤럭시 S25+ (안드로이드 15)

### 3. 삼성 기기 배터리 최적화 (Doze 모드, App Standby)

**문제점:**
- 삼성 갤럭시 기기는 배터리 최적화를 위해 백그라운드 앱을 강력하게 제한
- FCM 서비스가 Doze 모드나 App Standby 상태에서 중단될 수 있음
- 특히 최신 기기(S24, S25)일수록 더 강력한 최적화 적용

**영향받는 기기:**
- 모든 갤럭시 기기 (특히 최신 모델)

**확인 방법:**
- 설정 > 앱 > MARS > 배터리 > 배터리 사용량 최적화 해제
- 설정 > 디바이스 케어 > 배터리 > 백그라운드 앱 제한 해제

### 4. 알림 채널 설정 문제

**현재 코드:**
```java
NotificationChannel channel = new NotificationChannel(channelId,
    getResources().getString(R.string.app_name)+"채널",
    NotificationManager.IMPORTANCE_HIGH);
```

**문제점:**
- 안드로이드 15에서는 알림 채널의 중요도 설정이 더 엄격해짐
- 사용자가 수동으로 알림 채널을 비활성화했을 수 있음

**확인 사항:**
- 앱 설정에서 알림 채널이 활성화되어 있는지 확인
- 채널 중요도가 올바르게 설정되어 있는지 확인

### 5. FCM 토큰 갱신 문제

**현재 코드:**
```java
@Override
public void onNewToken(String token) {
    // 토큰 갱신 로직
}
```

**문제점:**
- 안드로이드 15에서 토큰 갱신 주기가 변경되었을 수 있음
- 토큰이 만료되었거나 서버에 제대로 등록되지 않았을 수 있음

**확인 방법:**
- 각 기기의 FCM 토큰이 서버에 제대로 등록되어 있는지 확인
- 토큰 갱신 로그 확인

### 6. Google Play Services 버전 문제

**문제점:**
- FCM은 Google Play Services에 의존
- 최신 안드로이드 기기에서 Google Play Services 버전이 낮거나 업데이트되지 않았을 수 있음
- 특히 안드로이드 15에서는 최신 Google Play Services가 필요

**확인 방법:**
- Google Play Services 앱이 최신 버전인지 확인
- Google Play Services 업데이트 필요 여부 확인

### 7. 네트워크 연결 및 방화벽

**문제점:**
- FCM은 Google 서버와 통신해야 함
- 일부 네트워크 환경에서 FCM 포트가 차단될 수 있음
- Wi-Fi와 모바일 데이터 간 전환 시 토큰 갱신 문제

### 8. 앱 권한 문제

**확인 사항:**
- 알림 권한이 부여되어 있는지 확인 (안드로이드 13+)
- 백그라운드 실행 권한 확인
- 자동 시작 권한 (삼성 기기 특화)

### 9. ProGuard/R8 난독화 문제

**현재 설정:**
```gradle
buildTypes {
    release {
        minifyEnabled true
        proguardFiles getDefaultProguardFile('proguard-android.txt'), 'proguard-rules.pro'
    }
}
```

**문제점:**
- ProGuard/R8이 FCM 관련 클래스를 난독화하거나 제거했을 수 있음
- 특히 최신 FCM SDK와의 호환성 문제

**확인 사항:**
- `proguard-rules.pro`에 FCM 관련 keep 규칙이 있는지 확인

### 10. 서버 측 전송 방식 문제

**Topic vs Token 전송:**
- Topic으로 전송: 여러 기기에 동시 전송, 하지만 특정 기기에서 수신 실패 가능
- Token으로 전송: 개별 기기 전송, 더 안정적

**확인 사항:**
- 서버에서 알림을 Topic으로 보내는지, Token으로 보내는지 확인
- 특정 기기만 실패한다면 Token 기반 전송으로 변경 고려

## 우선순위별 해결 방안

### 🔴 긴급 (즉시 조치 필요)

1. **FCM SDK 업데이트**
   ```gradle
   // firebase-core 제거
   implementation 'com.google.firebase:firebase-messaging:24.0.0'
   ```

2. **Google Play Services 버전 확인**
   - 각 기기에서 Google Play Services가 최신 버전인지 확인

### 🟡 중요 (단기 조치)

3. **배터리 최적화 해제 안내**
   - 사용자에게 배터리 최적화 해제 방법 안내
   - 코드에서 배터리 최적화 해제 요청 다이얼로그 추가

4. **알림 권한 확인 및 요청**
   - 안드로이드 13+ 알림 권한 요청 코드 추가
   - 권한 상태 확인 로직 추가

5. **토큰 갱신 로직 강화**
   - 토큰 갱신 실패 시 재시도 로직 추가
   - 토큰 등록 상태 모니터링

### 🟢 개선 (중기 조치)

6. **ProGuard 규칙 확인**
   - FCM 관련 keep 규칙 추가

7. **에러 로깅 강화**
   - FCM 수신 실패 시 상세 로그 기록
   - 각 기기별 실패 원인 추적

8. **서버 측 전송 방식 개선**
   - Topic과 Token 전송 병행
   - 실패 시 Token 기반 재전송

## 테스트 방법

1. **각 기기에서 테스트:**
   - FCM 토큰 확인
   - Topic 구독 상태 확인
   - 알림 권한 상태 확인
   - 배터리 최적화 상태 확인

2. **로그 확인:**
   ```bash
   adb logcat | grep -i "firebase\|fcm\|notification"
   ```

3. **FCM 테스트 도구 사용:**
   - Firebase Console에서 직접 알림 전송 테스트
   - Topic과 Token 각각으로 테스트

## 참고 자료

- [Firebase Cloud Messaging 공식 문서](https://firebase.google.com/docs/cloud-messaging)
- [Android 15 알림 변경사항](https://developer.android.com/about/versions/15/features/notifications)
- [삼성 기기 배터리 최적화 가이드](https://developer.samsung.com/smart-view/developing-with-samsung-smart-view/optimizing-battery-life.html)

## 결론

**가장 유력한 원인:**
1. **FCM SDK 버전이 낮아서 안드로이드 15와 호환되지 않음** (firebase-messaging:23.0.8 → 24.0.0+ 필요)
2. **삼성 기기의 배터리 최적화로 인한 백그라운드 제한**
3. **Google Play Services 버전 문제**

**즉시 조치 권장:**
- FCM SDK를 최신 버전으로 업데이트
- 각 기기에서 Google Play Services 업데이트 확인
- 배터리 최적화 해제 안내

