/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.location.Location;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.skt.Tmap.TMapLayer;
import com.skt.Tmap.TMapView;

public class PointLocationLayer
implements TMapLayer {
    protected static final int RADIUS = 9;
    protected static final int HEADING_RADIUS = 60;
    protected static final float HEADING_ANGLE = 60.0f;
    private Paint location = null;
    private Paint bearingOver = null;
    private Paint headingPaint = null;
    private Paint headingLine = null;
    protected Location mLastKnownLocation = null;
    private DisplayMetrics dm = null;
    private TMapView mTMapView = null;
    private Float mHeading = null;
    private Bitmap btIcon = null;
    public boolean showIcon = false;
    public boolean showSight = false;

    private void initUI() {
        this.location = new Paint();
        this.location.setColor(Color.parseColor((String)"#5984FE"));
        this.location.setAntiAlias(true);
        this.bearingOver = new Paint();
        this.bearingOver.setColor(Color.parseColor((String)"#2C3457"));
        this.bearingOver.setAntiAlias(true);
        this.bearingOver.setStrokeWidth(4.0f);
        this.bearingOver.setStyle(Paint.Style.STROKE);
        this.headingPaint = new Paint();
        this.headingPaint.setColor(-1);
        this.headingPaint.setAlpha(120);
        this.headingPaint.setAntiAlias(true);
        this.headingPaint.setStyle(Paint.Style.FILL);
        this.headingLine = new Paint();
        this.headingLine.setColor(-16776961);
        this.headingLine.setAlpha(100);
        this.headingLine.setStyle(Paint.Style.STROKE);
        this.headingLine.setStrokeWidth(2.0f);
    }

    @Override
    public void initLayer(TMapView view) {
        this.mTMapView = view;
        this.initUI();
        this.dm = new DisplayMetrics();
        WindowManager wmgr = (WindowManager)view.getContext().getSystemService("window");
        wmgr.getDefaultDisplay().getMetrics(this.dm);
    }

    public void setIcon(Bitmap bt) {
        this.btIcon = bt;
    }

    private RectF getHeadingRect(int locationX, int locationY) {
        int rad = Math.min(3 * this.mTMapView.getWidth() / 12, 3 * this.mTMapView.getHeight() / 12);
        return new RectF((float)(locationX - rad), (float)(locationY - rad), (float)(locationX + rad), (float)(locationY + rad));
    }

    @Override
    public void draw(Canvas canvas, RectF TMapPointBounds, boolean nightMode) {
        if (this.mTMapView.getLocationPoint() != null) {
            int locationX = this.mTMapView.getMapXForPoint(this.mTMapView.getLocationPoint().getLongitude(), this.mTMapView.getLocationPoint().getLatitude());
            int locationY = this.mTMapView.getMapYForPoint(this.mTMapView.getLocationPoint().getLongitude(), this.mTMapView.getLocationPoint().getLatitude());
            if (this.showSight) {
                this.headingPaint.setShader((Shader)new RadialGradient((float)locationX, (float)locationY, 90.0f, -16711936, 0, Shader.TileMode.CLAMP));
                canvas.drawArc(this.getHeadingRect(locationX, locationY), -135.0f - this.mTMapView.getRotateData(), 90.0f, true, this.headingPaint);
                this.headingLine.setShader((Shader)new RadialGradient((float)locationX, (float)locationY, 70.0f, -16776961, 0, Shader.TileMode.CLAMP));
                canvas.drawArc(this.getHeadingRect(locationX, locationY), -135.0f - this.mTMapView.getRotateData(), 90.0f, true, this.headingLine);
            }
            if (this.showIcon) {
                if (this.btIcon == null) {
                    canvas.drawCircle((float)locationX, (float)locationY, 9.0f * this.dm.density, this.location);
                    canvas.drawCircle((float)locationX, (float)locationY, 9.0f * this.dm.density, this.bearingOver);
                } else {
                    int x = this.mTMapView.getRotatedMapXForPoint(this.mTMapView.getLocationPoint().getLatitude(), this.mTMapView.getLocationPoint().getLongitude());
                    int y = this.mTMapView.getRotatedMapYForPoint(this.mTMapView.getLocationPoint().getLatitude(), this.mTMapView.getLocationPoint().getLongitude());
                    canvas.save();
                    canvas.rotate(-this.mTMapView.getRotateData(), (float)this.mTMapView.getCenterPointX(), (float)this.mTMapView.getCenterPointY());
                    canvas.translate((float)(x - this.btIcon.getWidth() / 2), (float)(y - this.btIcon.getHeight() / 2));
                    canvas.drawBitmap(this.btIcon, 0.0f, 0.0f, null);
                    canvas.restore();
                }
                if (this.mHeading != null) {
                    canvas.drawArc(this.getHeadingRect(locationX, locationY), this.mHeading.floatValue() - 30.0f - 90.0f, 60.0f, true, this.headingPaint);
                }
            }
        }
    }

    public boolean isLocationVisibleCheck(Location location) {
        if (location == null || this.mTMapView == null) {
            return false;
        }
        return this.mTMapView.isPointOnTheRotatedMap(location.getLatitude(), location.getLongitude());
    }

    public Location getLastLocation() {
        return this.mLastKnownLocation;
    }

    public void setHeadingData(Float headingData) {
        this.mHeading = headingData;
        if (!this.mTMapView.mapIsRefreshing() && this.isLocationVisibleCheck(this.mLastKnownLocation)) {
            this.mTMapView.postInvalidate();
        }
    }

    public Float getHeadingData() {
        return this.mHeading;
    }

    public void setLastLocation(Location lastLocation) {
        boolean redraw = this.isLocationVisibleCheck(this.mLastKnownLocation) || this.isLocationVisibleCheck(lastLocation);
        this.mLastKnownLocation = lastLocation;
        if (redraw) {
            this.mTMapView.postInvalidate();
        }
    }

    @Override
    public void destroyTMapLayer() {
    }

    @Override
    public boolean drawInScreenPixels() {
        return false;
    }

    @Override
    public boolean onLongPressEvent(PointF point) {
        return false;
    }

    @Override
    public boolean onTouchEvent(PointF point) {
        return false;
    }
}

