/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import com.skt.Tmap.TMapPoint;
import java.util.ArrayList;

public class TMapBesselPoint {
    private double x;
    private double y;

    public TMapBesselPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TMapBesselPoint other = (TMapBesselPoint)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.getX())) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.getY());
    }

    public String toString() {
        return "x " + this.x + " y " + this.y;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public static TMapPoint convertToWgs(TMapBesselPoint besselPoint) {
        return TMapBesselPoint.convertToWgs(besselPoint.getX(), besselPoint.getY());
    }

    public static ArrayList<TMapPoint> convertToWgs(ArrayList<TMapBesselPoint> alBesselPoint) {
        ArrayList<TMapPoint> alTMapPoint = new ArrayList<TMapPoint>();
        int besselPointSize = alBesselPoint.size();
        for (int i = 0; i < besselPointSize; ++i) {
            alTMapPoint.add(TMapBesselPoint.convertToWgs(alBesselPoint.get(i).getX(), alBesselPoint.get(i).getY()));
        }
        return alTMapPoint;
    }

    private static TMapPoint convertToWgs(double x, double y) {
        double inLat = y;
        double inLon = x;
        double dbA = 6377397.155;
        double dbF = 0.0033427731821748;
        double dbEE = 0.006674372;
        double dbDX = -128.0;
        double dbDY = 481.0;
        double dbDZ = 664.0;
        double dbDA = 739.845;
        double dbDF = 1.0037499008E-5;
        double dbCS_LAT_RAD = inLat * 0.0174532925199433;
        double dbCS_LON_RAD = inLon * 0.0174532925199433;
        double dbCS_P = dbA * (1.0 - dbEE) / Math.pow(1.0 - dbEE * Math.pow(Math.sin(dbCS_LAT_RAD), 2.0), 1.5);
        double dbCS_V = dbA / Math.pow(1.0 - dbEE * Math.pow(Math.sin(dbCS_LAT_RAD), 2.0), 0.5);
        double dbCS_LAT_GRS_DS = (-1.0 * dbDX * Math.sin(dbCS_LAT_RAD) * Math.cos(dbCS_LON_RAD) - dbDY * Math.sin(dbCS_LAT_RAD) * Math.sin(dbCS_LON_RAD) + dbDZ * Math.cos(dbCS_LAT_RAD) + (dbA * dbDF + dbF * dbDA) * Math.sin(2.0 * dbCS_LAT_RAD)) / (dbCS_P * Math.sin(4.84813681109536E-6));
        double dbCS_LON_GRS_DS = (-1.0 * dbDX * Math.sin(dbCS_LON_RAD) + dbDY * Math.cos(dbCS_LON_RAD)) / (dbCS_V * Math.cos(dbCS_LAT_RAD) * Math.sin(4.84813681109536E-6));
        TMapPoint tMapPoint = new TMapPoint(inLon + dbCS_LON_GRS_DS / 3600.0, inLat + dbCS_LAT_GRS_DS / 3600.0);
        return tMapPoint;
    }
}

