/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.graphics.Color;
import android.util.Log;
import com.skt.Tmap.BizCategory;
import com.skt.Tmap.MapUtils;
import com.skt.Tmap.TMapAutoComplete;
import com.skt.Tmap.TMapAutoCompleteV2;
import com.skt.Tmap.TMapLabelInfo;
import com.skt.Tmap.TMapPoint;
import com.skt.Tmap.TMapPolyLine;
import com.skt.Tmap.address_info.AdminDongCoord;
import com.skt.Tmap.address_info.LegalDongCoord;
import com.skt.Tmap.address_info.RoadCoord;
import com.skt.Tmap.address_info.TMapAddressInfo;
import com.skt.Tmap.poi_item.EvCharger;
import com.skt.Tmap.poi_item.GroupSub;
import com.skt.Tmap.poi_item.NewAddress;
import com.skt.Tmap.poi_item.TMapPOIItem;
import com.skt.Tmap.util.HttpConnect;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TMapData {
    private static boolean blcheck = false;
    private static String baseUrl = null;
    private static String dataUrl = null;
    private double X_MIN = 124.0;
    private double X_MAX = 133.0;
    private double Y_MIN = 32.0;
    private double Y_MAX = 39.0;
    private static Map<String, TMapAutoComplete> autoName = new LinkedHashMap<String, TMapAutoComplete>();
    public static OnResponseCodeInfoCallback responseCodeListener;

    public static void setBaseUrl(String url) {
        baseUrl = url;
        dataUrl = baseUrl + "/tmap/";
    }

    private boolean checkBoundary(double lat, double lon) {
        return lat > this.Y_MIN && lat < this.Y_MAX && lon > this.X_MIN && lon < this.X_MAX;
    }

    protected static void checkApiKey(final CheckKeyResultListenerCallback result) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block15: {
                    StringBuilder uri = new StringBuilder();
                    if (MapUtils.mIsMapOp) {
                        uri.append(dataUrl);
                        uri.append("auth/android?format=json&appKey=");
                        uri.append(MapUtils.mApiKey);
                    } else if (MapUtils.mIsMapPickat) {
                        uri.append(dataUrl);
                        uri.append("auth/android?format=json&appKey=");
                        uri.append(MapUtils.mApiKey);
                    } else {
                        return;
                    }
                    if (!MapUtils.checkAppKey()) {
                        HttpURLConnection urlCon = null;
                        try {
                            URL url = new URL(uri.toString());
                            urlCon = (HttpURLConnection)url.openConnection();
                            urlCon.setRequestMethod("GET");
                            if (urlCon.getResponseCode() == 200) {
                                MapUtils.setAppKey();
                                result.onCheckKeyResult("OK");
                                break block15;
                            }
                            BufferedReader bufReader = new BufferedReader(new InputStreamReader(urlCon.getErrorStream()));
                            StringBuffer strBuffer = new StringBuffer();
                            String readLine = null;
                            while ((readLine = bufReader.readLine()) != null) {
                                strBuffer.append(readLine);
                            }
                            bufReader.close();
                            String message = null;
                            try {
                                Log.e((String)"TMapData", (String)("connection = " + strBuffer.toString()));
                                JSONObject jsonBody = new JSONObject(strBuffer.toString());
                                JSONObject jsonError = jsonBody.getJSONObject("error");
                                message = jsonError.getString("message");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (message == null || message.equals("")) {
                                message = "ApiKey \uc778\uc99d\uc5d0 \uc2e4\ud328 \ud588\uc2b5\ub2c8\ub2e4.";
                            }
                            result.onCheckKeyResult(message);
                        }
                        catch (Exception e) {
                            result.onCheckKeyResult(e.getMessage());
                            e.printStackTrace();
                        }
                        finally {
                            urlCon.disconnect();
                        }
                    }
                }
            }
        }.start();
    }

    public static synchronized boolean invokeStatistics(final String invokeCate, final boolean bResult) {
        blcheck = false;
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStream is = null;
                Closeable ir = null;
                String invokeResult = "fa";
                if (bResult) {
                    invokeResult = "su";
                }
                String uri = dataUrl + "invokeStatistics?version=1&format=xml&invokeCate=" + invokeCate + "&invokeResult=" + invokeResult;
                HttpURLConnection urlCon = null;
                try {
                    URL url = new URL(uri.toString());
                    urlCon = (HttpURLConnection)url.openConnection();
                    urlCon.setRequestMethod("GET");
                    urlCon.setRequestProperty("appKey", MapUtils.mApiKey);
                    if (urlCon.getResponseCode() == 200) {
                        is = urlCon.getInputStream();
                        DocumentBuilder dom = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        Document doc = dom.parse(is);
                        NodeList list = doc.getElementsByTagName("result");
                        String result = list.item(0).getFirstChild().getNodeValue();
                        if (result.equals("success")) {
                            blcheck = true;
                        }
                        if (is != null) {
                            MapUtils.closeStream(is);
                        }
                        if (ir != null) {
                            MapUtils.closeStream(ir);
                        }
                    } else {
                        blcheck = false;
                    }
                }
                catch (SAXException e) {
                    blcheck = false;
                }
                catch (Exception e) {
                    blcheck = false;
                }
                finally {
                    urlCon.disconnect();
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return blcheck;
    }

    protected static void checkInitMap() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpURLConnection urlCon = null;
                try {
                    StringBuilder uri = new StringBuilder();
                    if (!MapUtils.mIsMapOp) {
                        return;
                    }
                    uri.append(dataUrl);
                    uri.append("auth/android?format=json&appKey=");
                    uri.append("MapUtils.mApiKey");
                    URL url = new URL(uri.toString());
                    urlCon = (HttpURLConnection)url.openConnection();
                    urlCon.setRequestMethod("GET");
                    if (urlCon.getResponseCode() == 200) {
                        // empty if block
                    }
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {
                }
                finally {
                    urlCon.disconnect();
                }
            }
        }.start();
    }

    public static void findReverseLabel(final TMapPoint tmappoint, final int zoom, final findReverseLabelCallBack callback) {
        new Thread(){

            @Override
            public void run() {
                Document doc = null;
                TMapLabelInfo labelitem = new TMapLabelInfo();
                StringBuilder uri = new StringBuilder();
                int reqLevel = zoom < 15 ? 15 : (zoom > 19 ? 19 : zoom);
                try {
                    uri.append(dataUrl);
                    uri.append("geo/reverseLabel?version=1&format=xml&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&bizAppId=1");
                    uri.append("&centerLat=").append(tmappoint.getLatitude());
                    uri.append("&centerLon=").append(tmappoint.getLongitude());
                    uri.append("&reqLevel=").append(reqLevel);
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "findReverseLabel");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("poiInfo");
                        for (int i = 0; i < list.getLength(); ++i) {
                            Element item = (Element)list.item(i);
                            labelitem.id = HttpConnect.getContentFromNode(item, "id");
                            labelitem.labelLat = HttpConnect.getContentFromNode(item, "poiLat");
                            labelitem.labelLon = HttpConnect.getContentFromNode(item, "poiLon");
                            labelitem.labelName = HttpConnect.getContentFromNode(item, "name");
                        }
                    }
                    callback.onReverseLabelCallBack(labelitem);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public String convertGpsToAddress(double lat, double lon) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        if (!this.checkBoundary(lat, lon)) {
            Log.w((String)"SKT", (String)"convertGpsToAddress \uc758 \uc694\uccad \uc88c\ud45c\uac00 \ud5c8\uc6a9\ubc94\uc704\ub97c \ubc97\uc5b4\ub0ac\uc2b5\ub2c8\ub2e4.");
            return null;
        }
        String Address = null;
        Document doc = null;
        String strLat = URLEncoder.encode(Double.toString(lat), "UTF-8");
        String strLon = URLEncoder.encode(Double.toString(lon), "UTF-8");
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("geo/reversegeocoding?version=1&coordType=WGS84GEO&addressType=A02&format=xml");
        uri.append("&lat=").append(strLat);
        uri.append("&lon=").append(strLon);
        doc = TMapData.getDownloadFromUrl(uri.toString(), "convertGpsToAddress");
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("addressInfo");
            for (int i = 0; i < list.getLength(); ++i) {
                Element item = (Element)list.item(i);
                Address = HttpConnect.getContentFromNode(item, "fullAddress");
            }
        } else {
            Address = null;
        }
        return Address;
    }

    public void convertGpsToAddress(final double lat, final double lon, final ConvertGPSToAddressListenerCallback addressListener) {
        if (!this.checkBoundary(lat, lon)) {
            Log.w((String)"SKT", (String)"convertGpsToAddress \uc758 \uc694\uccad \uc88c\ud45c\uac00 \ud5c8\uc6a9\ubc94\uc704\ub97c \ubc97\uc5b4\ub0ac\uc2b5\ub2c8\ub2e4.");
            addressListener.onConvertToGPSToAddress(null);
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    String Address = null;
                    Document doc = null;
                    String strLat = URLEncoder.encode(Double.toString(lat), "UTF-8");
                    String strLon = URLEncoder.encode(Double.toString(lon), "UTF-8");
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("geo/reversegeocoding?version=1&coordType=WGS84GEO&addressType=A02&format=xml");
                    uri.append("&lat=").append(strLat);
                    uri.append("&lon=").append(strLon);
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "convertGpsToAddress");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("addressInfo");
                        for (int i = 0; i < list.getLength(); ++i) {
                            Element item = (Element)list.item(i);
                            Address = HttpConnect.getContentFromNode(item, "fullAddress");
                        }
                    } else {
                        Address = null;
                    }
                    addressListener.onConvertToGPSToAddress(Address);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public TMapAddressInfo reverseGeocoding(double lat, double lon, String addressType) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        if (!this.checkBoundary(lat, lon)) {
            Log.w((String)"SKT", (String)"reverseGeocoding \uc758 \uc694\uccad \uc88c\ud45c\uac00 \ud5c8\uc6a9\ubc94\uc704\ub97c \ubc97\uc5b4\ub0ac\uc2b5\ub2c8\ub2e4.");
            return null;
        }
        String strLat = URLEncoder.encode(Double.toString(lat), "UTF-8");
        String strLon = URLEncoder.encode(Double.toString(lon), "UTF-8");
        String strType = URLEncoder.encode(addressType, "UTF-8");
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("geo/reversegeocoding?version=1&coordType=WGS84GEO&format=json");
        uri.append("&lat=").append(strLat);
        uri.append("&lon=").append(strLon);
        uri.append("&addressType=").append(strType);
        uri.append("&coordYn=Y");
        uri.append("&keyInfo=Y");
        JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
        TMapAddressInfo info = this.parseTmapAddressInfo(jsonObject);
        uri.delete(0, uri.length());
        return info;
    }

    public void reverseGeocoding(final double lat, final double lon, final String addressType, final reverseGeocodingListenerCallback addressListener) {
        if (!this.checkBoundary(lat, lon)) {
            Log.w((String)"SKT", (String)"reverseGeocoding \uc758 \uc694\uccad \uc88c\ud45c\uac00 \ud5c8\uc6a9\ubc94\uc704\ub97c \ubc97\uc5b4\ub0ac\uc2b5\ub2c8\ub2e4.");
            addressListener.onReverseGeocoding(null);
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    String strLat = URLEncoder.encode(Double.toString(lat), "UTF-8");
                    String strLon = URLEncoder.encode(Double.toString(lon), "UTF-8");
                    String strType = URLEncoder.encode(addressType, "UTF-8");
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("geo/reversegeocoding?version=1&coordType=WGS84GEO&format=json");
                    uri.append("&lat=").append(strLat);
                    uri.append("&lon=").append(strLon);
                    uri.append("&addressType=").append(strType);
                    uri.append("&coordYn=Y");
                    uri.append("&keyInfo=Y");
                    JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
                    TMapAddressInfo info = TMapData.this.parseTmapAddressInfo(jsonObject);
                    uri.delete(0, uri.length());
                    addressListener.onReverseGeocoding(info);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public ArrayList<TMapPOIItem> findAllPOI(String data) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        String encodedData = URLEncoder.encode(data, "UTF-8");
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=json");
        uri.append("&searchKeyword=").append(encodedData);
        uri.append("&poiGroupYn=Y");
        JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
        ArrayList<TMapPOIItem> allpoi = this.parseTmapPOIItemList(jsonObject);
        uri.delete(0, uri.length());
        return allpoi;
    }

    public ArrayList<TMapPOIItem> findAllPOI(String data, int nSearchCount) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        String encodedData = URLEncoder.encode(data, "UTF-8");
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=json");
        uri.append("&searchKeyword=").append(encodedData);
        if (nSearchCount <= 0) {
            nSearchCount = 20;
        } else if (nSearchCount > 200) {
            nSearchCount = 200;
        }
        uri.append("&count=").append(nSearchCount);
        uri.append("&poiGroupYn=Y");
        JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
        ArrayList<TMapPOIItem> allpoi = this.parseTmapPOIItemList(jsonObject);
        uri.delete(0, uri.length());
        return allpoi;
    }

    public void findAllPOI(final String data, final FindAllPOIListenerCallback findAllPoiListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    String encodedData = URLEncoder.encode(data, "UTF-8");
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=json");
                    uri.append("&searchKeyword=").append(encodedData);
                    uri.append("&poiGroupYn=Y");
                    JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
                    ArrayList allpoi = TMapData.this.parseTmapPOIItemList(jsonObject);
                    findAllPoiListener.onFindAllPOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void findAllPOI(final String data, final int nSearchCount, final FindAllPOIListenerCallback findAllPoiListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    String encodedData = URLEncoder.encode(data, "UTF-8");
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=json");
                    uri.append("&searchKeyword=").append(encodedData);
                    if (nSearchCount <= 0) {
                        uri.append("&count=").append(20);
                    } else if (nSearchCount > 200) {
                        uri.append("&count=").append(200);
                    } else {
                        uri.append("&count=").append(nSearchCount);
                    }
                    uri.append("&poiGroupYn=Y");
                    JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
                    ArrayList allpoi = TMapData.this.parseTmapPOIItemList(jsonObject);
                    uri.delete(0, uri.length());
                    findAllPoiListener.onFindAllPOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public ArrayList<TMapPOIItem> findAddressPOI(String data) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        String encodedData = URLEncoder.encode(data, "UTF-8");
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=json");
        uri.append("&searchKeyword=").append(encodedData);
        uri.append("&poiGroupYn=Y");
        JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
        ArrayList<TMapPOIItem> allpoi = this.parseTmapPOIItemList(jsonObject);
        uri.delete(0, uri.length());
        return allpoi;
    }

    public ArrayList<TMapPOIItem> findAddressPOI(String data, int nSearchCount) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        String encodedData = URLEncoder.encode(data, "UTF-8");
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=json");
        uri.append("&searchKeyword=").append(encodedData);
        if (nSearchCount <= 0) {
            nSearchCount = 20;
        } else if (nSearchCount > 200) {
            nSearchCount = 200;
        }
        uri.append("&count=").append(nSearchCount);
        uri.append("&poiGroupYn=Y");
        JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
        ArrayList<TMapPOIItem> allpoi = this.parseTmapPOIItemList(jsonObject);
        uri.delete(0, uri.length());
        return allpoi;
    }

    public void findAddressPOI(final String data, final FindAddressPOIListenerCallback findAddressPOIListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    String encodedData = URLEncoder.encode(data, "UTF-8");
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=json");
                    uri.append("&searchKeyword=").append(encodedData);
                    uri.append("&poiGroupYn=Y");
                    JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
                    ArrayList allpoi = TMapData.this.parseTmapPOIItemList(jsonObject);
                    uri.delete(0, uri.length());
                    findAddressPOIListener.onFindAddressPOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void findAddressPOI(final String data, final int nSearchCount, final FindAddressPOIListenerCallback findAddressPOIListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    String encodedData = URLEncoder.encode(data, "UTF-8");
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=json");
                    uri.append("&searchKeyword=").append(encodedData);
                    if (nSearchCount <= 0) {
                        uri.append("&count=").append(20);
                    } else if (nSearchCount > 200) {
                        uri.append("&count=").append(200);
                    } else {
                        uri.append("&count=").append(nSearchCount);
                    }
                    uri.append("&poiGroupYn=Y");
                    JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
                    ArrayList allpoi = TMapData.this.parseTmapPOIItemList(jsonObject);
                    uri.delete(0, uri.length());
                    findAddressPOIListener.onFindAddressPOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public ArrayList<TMapPOIItem> findTitlePOI(String data) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        String encodedData = URLEncoder.encode(data, "UTF-8");
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=json");
        uri.append("&searchKeyword=").append(encodedData);
        uri.append("&poiGroupYn=Y");
        JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
        ArrayList<TMapPOIItem> allpoi = this.parseTmapPOIItemList(jsonObject);
        uri.delete(0, uri.length());
        return allpoi;
    }

    public ArrayList<TMapPOIItem> findTitlePOI(String data, int nSearchCount) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        String encodedData = URLEncoder.encode(data, "UTF-8");
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=json");
        uri.append("&searchKeyword=").append(encodedData);
        if (nSearchCount <= 0) {
            nSearchCount = 20;
        } else if (nSearchCount > 200) {
            nSearchCount = 200;
        }
        uri.append("&count=").append(nSearchCount);
        uri.append("&poiGroupYn=Y");
        JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
        ArrayList<TMapPOIItem> allpoi = this.parseTmapPOIItemList(jsonObject);
        uri.delete(0, uri.length());
        return allpoi;
    }

    public void findTitlePOI(final String data, final FindTitlePOIListenerCallback findTitlePOIListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    String encodedData = URLEncoder.encode(data, "UTF-8");
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=json");
                    uri.append("&searchKeyword=").append(encodedData);
                    uri.append("&poiGroupYn=Y");
                    JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
                    ArrayList allpoi = TMapData.this.parseTmapPOIItemList(jsonObject);
                    uri.delete(0, uri.length());
                    findTitlePOIListener.onFindTitlePOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void findTitlePOI(final String data, final int nSearchCount, final FindTitlePOIListenerCallback findTitlePOIListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    String encodedData = URLEncoder.encode(data, "UTF-8");
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=json");
                    uri.append("&searchKeyword=").append(encodedData);
                    if (nSearchCount <= 0) {
                        uri.append("&count=").append(20);
                    } else if (nSearchCount > 200) {
                        uri.append("&count=").append(200);
                    } else {
                        uri.append("&count=").append(nSearchCount);
                    }
                    uri.append("&poiGroupYn=Y");
                    JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
                    ArrayList allpoi = TMapData.this.parseTmapPOIItemList(jsonObject);
                    uri.delete(0, uri.length());
                    findTitlePOIListener.onFindTitlePOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public ArrayList<TMapPOIItem> findAroundNamePOI(TMapPoint tmappoint, String categoryName) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("pois/search/around?version=1&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&searchType=name&format=json");
        String utf8name = URLEncoder.encode(categoryName, "UTF-8");
        uri.append("&categories=").append(utf8name);
        uri.append("&centerLat=").append(tmappoint.getLatitude());
        uri.append("&centerLon=").append(tmappoint.getLongitude());
        JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
        ArrayList<TMapPOIItem> allpoi = this.parseTmapPOIItemList(jsonObject);
        uri.delete(0, uri.length());
        return allpoi;
    }

    public ArrayList<TMapPOIItem> findAroundNamePOI(TMapPoint tmappoint, String categoryName, int nRadius, int nSearchCount) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("pois/search/around?version=1&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&searchType=name&format=json");
        String utf8name = URLEncoder.encode(categoryName, "UTF-8");
        uri.append("&categories=").append(utf8name);
        uri.append("&centerLat=").append(tmappoint.getLatitude());
        uri.append("&centerLon=").append(tmappoint.getLongitude());
        if (nRadius < 1) {
            nRadius = 1;
        } else if (nRadius > 33) {
            nRadius = 33;
        }
        uri.append("&radius=").append(nRadius);
        if (nSearchCount <= 0) {
            nSearchCount = 20;
        } else if (nSearchCount > 200) {
            nSearchCount = 200;
        }
        uri.append("&count=").append(nSearchCount);
        JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
        ArrayList<TMapPOIItem> allpoi = this.parseTmapPOIItemList(jsonObject);
        uri.delete(0, uri.length());
        return allpoi;
    }

    public void findAroundNamePOI(final TMapPoint tmappoint, final String categoryName, final FindAroundNamePOIListenerCallback findAroundNamePoiListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois/search/around?version=1&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=json");
                    String utf8name = URLEncoder.encode(categoryName, "UTF-8");
                    uri.append("&categories=").append(utf8name);
                    uri.append("&centerLat=").append(tmappoint.getLatitude());
                    uri.append("&centerLon=").append(tmappoint.getLongitude());
                    JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
                    ArrayList allpoi = TMapData.this.parseTmapPOIItemList(jsonObject);
                    uri.delete(0, uri.length());
                    findAroundNamePoiListener.onFindAroundNamePOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void findAroundNamePOI(final TMapPoint tmappoint, final String categoryName, final int nRadius, final int nSearchCount, final FindAroundNamePOIListenerCallback findAroundNamePoiListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois/search/around?version=1&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=json");
                    String utf8name = URLEncoder.encode(categoryName, "UTF-8");
                    uri.append("&categories=").append(utf8name);
                    uri.append("&centerLat=").append(tmappoint.getLatitude());
                    uri.append("&centerLon=").append(tmappoint.getLongitude());
                    if (nRadius < 0) {
                        uri.append("&radius=").append(1);
                    } else if (nRadius > 33) {
                        uri.append("&radius=").append(33);
                    } else {
                        uri.append("&radius=").append(nRadius);
                    }
                    if (nSearchCount <= 0) {
                        uri.append("&count=").append(20);
                    } else if (nSearchCount > 200) {
                        uri.append("&count=").append(200);
                    } else {
                        uri.append("&count=").append(nSearchCount);
                    }
                    JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
                    ArrayList allpoi = TMapData.this.parseTmapPOIItemList(jsonObject);
                    uri.delete(0, uri.length());
                    findAroundNamePoiListener.onFindAroundNamePOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void findAroundNamePOI(final TMapPoint tmappoint, String codeType, final String multiPoint, final String categoryName, final int nRadius, final int nSearchCount, final FindAroundNamePOIListenerCallback findAroundNamePoiListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois/search/around?version=1&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=json");
                    uri.append("&multiPoint=").append(multiPoint);
                    String utf8name = URLEncoder.encode(categoryName, "UTF-8");
                    uri.append("&categories=").append(utf8name);
                    uri.append("&centerLat=").append(tmappoint.getLatitude());
                    uri.append("&centerLon=").append(tmappoint.getLongitude());
                    if (nRadius < 0) {
                        uri.append("&radius=").append(1);
                    } else if (nRadius > 33) {
                        uri.append("&radius=").append(33);
                    } else {
                        uri.append("&radius=").append(nRadius);
                    }
                    if (nSearchCount <= 0) {
                        uri.append("&count=").append(20);
                    } else if (nSearchCount > 200) {
                        uri.append("&count=").append(200);
                    } else {
                        uri.append("&count=").append(nSearchCount);
                    }
                    JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
                    ArrayList allpoi = TMapData.this.parseTmapPOIItemList(jsonObject);
                    uri.delete(0, uri.length());
                    findAroundNamePoiListener.onFindAroundNamePOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    private ArrayList<BizCategory> getBizCategory() throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        ArrayList<BizCategory> bizcategory = new ArrayList<BizCategory>();
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("poi/categories?version=1&format=xml");
        doc = TMapData.getDownloadFromUrl(uri.toString(), "getBizCategory");
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("bizCategory");
            for (int i = 0; i < list.getLength(); ++i) {
                BizCategory category = new BizCategory();
                Element item = (Element)list.item(i);
                category.upperBizCode = HttpConnect.getContentFromNode(item, "upperBizCode");
                category.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                category.middleBizCode = HttpConnect.getContentFromNode(item, "middleBizCode");
                category.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                bizcategory.add(category);
            }
        }
        return bizcategory;
    }

    private void getBizCategory(final BizCategoryListenerCallback BizCategoryListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    ArrayList<BizCategory> bizcategory = new ArrayList<BizCategory>();
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("poi/categories?version=1&format=xml");
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "getBizCategory");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("bizCategory");
                        for (int i = 0; i < list.getLength(); ++i) {
                            BizCategory category = new BizCategory();
                            Element item = (Element)list.item(i);
                            category.upperBizCode = HttpConnect.getContentFromNode(item, "upperBizCode");
                            category.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                            category.middleBizCode = HttpConnect.getContentFromNode(item, "middleBizCode");
                            category.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                            bizcategory.add(category);
                        }
                    }
                    BizCategoryListener.onGetBizCategory(bizcategory);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    private void getBizCategory(final String codeType, final BizCategoryListenerCallback BizCategoryListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    ArrayList<BizCategory> bizcategory = new ArrayList<BizCategory>();
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("poi/categories?version=1&format=xml");
                    uri.append("&codeType=").append(codeType);
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "getBizCategory");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("bizCategory");
                        for (int i = 0; i < list.getLength(); ++i) {
                            BizCategory category = new BizCategory();
                            Element item = (Element)list.item(i);
                            category.upperBizCode = HttpConnect.getContentFromNode(item, "upperBizCode");
                            category.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                            category.middleBizCode = HttpConnect.getContentFromNode(item, "middleBizCode");
                            category.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                            category.lowerBizCode = HttpConnect.getContentFromNode(item, "lowerBizCode");
                            category.lowerBizName = HttpConnect.getContentFromNode(item, "lowerBizName");
                            bizcategory.add(category);
                        }
                    }
                    BizCategoryListener.onGetBizCategory(bizcategory);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public TMapPolyLine findPathData(TMapPoint startpoint, TMapPoint endpoint) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        TMapPolyLine polyline = new TMapPolyLine();
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("routes?version=1");
        StringBuilder content = new StringBuilder();
        content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
        content.append("&startY=").append(startpoint.getLatitude());
        content.append("&startX=").append(startpoint.getLongitude());
        content.append("&endY=").append(endpoint.getLatitude());
        content.append("&endX=").append(endpoint.getLongitude());
        doc = TMapData.getDownloadFromPostUrl("findPathData", uri.toString(), content.toString(), false);
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("LineString");
            for (int i = 0; i < list.getLength(); ++i) {
                Element item = (Element)list.item(i);
                String str = HttpConnect.getContentFromNode(item, "coordinates");
                if (str == null) continue;
                String[] str2 = str.split(" ");
                for (int k = 0; k < str2.length; ++k) {
                    try {
                        String[] str3 = str2[k].split(",");
                        TMapPoint point = new TMapPoint(Double.parseDouble(str3[1]), Double.parseDouble(str3[0]));
                        polyline.addLinePoint(point);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return polyline;
    }

    public void findPathData(final TMapPoint startpoint, final TMapPoint endpoint, final FindPathDataListenerCallback findPathDataListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    TMapPolyLine polyline = new TMapPolyLine();
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("routes?version=1&format=xml");
                    StringBuilder content = new StringBuilder();
                    content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO");
                    content.append("&startY=").append(startpoint.getLatitude());
                    content.append("&startX=").append(startpoint.getLongitude());
                    content.append("&endY=").append(endpoint.getLatitude());
                    content.append("&endX=").append(endpoint.getLongitude());
                    doc = TMapData.getDownloadFromPostUrl("findPathData", uri.toString(), content.toString(), false);
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("LineString");
                        for (int i = 0; i < list.getLength(); ++i) {
                            Element item = (Element)list.item(i);
                            String str = HttpConnect.getContentFromNode(item, "coordinates");
                            if (str == null) continue;
                            String[] str2 = str.split(" ");
                            for (int k = 0; k < str2.length; ++k) {
                                try {
                                    String[] str3 = str2[k].split(",");
                                    TMapPoint point = new TMapPoint(Double.parseDouble(str3[1]), Double.parseDouble(str3[0]));
                                    polyline.addLinePoint(point);
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    findPathDataListener.onFindPathData(polyline);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public TMapPolyLine findPathDataWithType(TMapPathType type, TMapPoint startpoint, TMapPoint endpoint) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        TMapPolyLine polyline = new TMapPolyLine();
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        if (TMapPathType.CAR_PATH == type) {
            uri.append("routes?version=1");
        } else if (TMapPathType.PEDESTRIAN_PATH == type) {
            uri.append("routes/pedestrian?version=1");
        }
        StringBuilder content = new StringBuilder();
        content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
        content.append("&startY=").append(startpoint.getLatitude());
        content.append("&startX=").append(startpoint.getLongitude());
        content.append("&endY=").append(endpoint.getLatitude());
        content.append("&endX=").append(endpoint.getLongitude());
        content.append("&startName=").append(URLEncoder.encode("\ucd9c\ubc1c\uc9c0", "UTF-8"));
        content.append("&endName=").append(URLEncoder.encode("\ub3c4\ucc29\uc9c0", "UTF-8"));
        doc = TMapData.getDownloadFromPostUrl("findPathDataWithType", uri.toString(), content.toString(), false);
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("LineString");
            for (int i = 0; i < list.getLength(); ++i) {
                Element item = (Element)list.item(i);
                String str = HttpConnect.getContentFromNode(item, "coordinates");
                if (str == null) continue;
                String[] str2 = str.split(" ");
                for (int k = 0; k < str2.length; ++k) {
                    try {
                        String[] str3 = str2[k].split(",");
                        TMapPoint point = new TMapPoint(Double.parseDouble(str3[1]), Double.parseDouble(str3[0]));
                        polyline.addLinePoint(point);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return polyline;
    }

    public void findPathDataWithType(final TMapPathType type, final TMapPoint startpoint, final TMapPoint endpoint, final FindPathDataListenerCallback findPathDataListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    TMapPolyLine polyline = new TMapPolyLine();
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    if (TMapPathType.CAR_PATH == type) {
                        uri.append("routes?version=1");
                    } else if (TMapPathType.PEDESTRIAN_PATH == type) {
                        uri.append("routes/pedestrian?version=1");
                    }
                    StringBuilder content = new StringBuilder();
                    content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
                    content.append("&startY=").append(startpoint.getLatitude());
                    content.append("&startX=").append(startpoint.getLongitude());
                    content.append("&endY=").append(endpoint.getLatitude());
                    content.append("&endX=").append(endpoint.getLongitude());
                    content.append("&startName=").append(URLEncoder.encode("\ucd9c\ubc1c\uc9c0", "UTF-8"));
                    content.append("&endName=").append(URLEncoder.encode("\ub3c4\ucc29\uc9c0", "UTF-8"));
                    doc = TMapData.getDownloadFromPostUrl("findPathDataWithType", uri.toString(), content.toString(), false);
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("LineString");
                        for (int i = 0; i < list.getLength(); ++i) {
                            Element item = (Element)list.item(i);
                            String str = HttpConnect.getContentFromNode(item, "coordinates");
                            if (str == null) continue;
                            String[] str2 = str.split(" ");
                            for (int k = 0; k < str2.length; ++k) {
                                try {
                                    String[] str3 = str2[k].split(",");
                                    TMapPoint point = new TMapPoint(Double.parseDouble(str3[1]), Double.parseDouble(str3[0]));
                                    polyline.addLinePoint(point);
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    findPathDataListener.onFindPathData(polyline);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public Document findPathDataAll(TMapPoint startpoint, TMapPoint endpoint) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("routes?version=1");
        StringBuilder content = new StringBuilder();
        content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
        content.append("&startY=").append(startpoint.getLatitude());
        content.append("&startX=").append(startpoint.getLongitude());
        content.append("&endY=").append(endpoint.getLatitude());
        content.append("&endX=").append(endpoint.getLongitude());
        doc = TMapData.getDownloadFromPostUrl("findPathDataAll", uri.toString(), content.toString(), false);
        return doc;
    }

    public void findPathDataAll(final TMapPoint startpoint, final TMapPoint endpoint, final FindPathDataAllListenerCallback findPathDataAllListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("routes?version=1");
                    StringBuilder content = new StringBuilder();
                    content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
                    content.append("&startY=").append(startpoint.getLatitude());
                    content.append("&startX=").append(startpoint.getLongitude());
                    content.append("&endY=").append(endpoint.getLatitude());
                    content.append("&endX=").append(endpoint.getLongitude());
                    doc = TMapData.getDownloadFromPostUrl("findPathDataAll", uri.toString(), content.toString(), false);
                    findPathDataAllListener.onFindPathDataAll(doc);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public Document findPathDataAllType(TMapPathType type, TMapPoint startpoint, TMapPoint endpoint) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        if (TMapPathType.CAR_PATH == type) {
            uri.append("routes?version=1");
        } else if (TMapPathType.PEDESTRIAN_PATH == type) {
            uri.append("routes/pedestrian?version=1");
        }
        StringBuilder content = new StringBuilder();
        content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
        content.append("&startY=").append(startpoint.getLatitude());
        content.append("&startX=").append(startpoint.getLongitude());
        content.append("&endY=").append(endpoint.getLatitude());
        content.append("&endX=").append(endpoint.getLongitude());
        content.append("&startName=").append(URLEncoder.encode("\ucd9c\ubc1c\uc9c0", "UTF-8"));
        content.append("&endName=").append(URLEncoder.encode("\ub3c4\ucc29\uc9c0", "UTF-8"));
        doc = TMapData.getDownloadFromPostUrl("findPathDataAllType", uri.toString(), content.toString(), false);
        return doc;
    }

    public void findPathDataAllType(final TMapPathType type, final TMapPoint startpoint, final TMapPoint endpoint, final FindPathDataAllListenerCallback findPathDataAllListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    if (TMapPathType.CAR_PATH == type) {
                        uri.append("routes?version=1");
                    } else if (TMapPathType.PEDESTRIAN_PATH == type) {
                        uri.append("routes/pedestrian?version=1");
                    }
                    StringBuilder content = new StringBuilder();
                    content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
                    content.append("&startY=").append(startpoint.getLatitude());
                    content.append("&startX=").append(startpoint.getLongitude());
                    content.append("&endY=").append(endpoint.getLatitude());
                    content.append("&endX=").append(endpoint.getLongitude());
                    content.append("&startName=").append(URLEncoder.encode("\ucd9c\ubc1c\uc9c0", "UTF-8"));
                    content.append("&endName=").append(URLEncoder.encode("\ub3c4\ucc29\uc9c0", "UTF-8"));
                    doc = TMapData.getDownloadFromPostUrl("findPathDataAllType", uri.toString(), content.toString(), false);
                    findPathDataAllListener.onFindPathDataAll(doc);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public TMapPolyLine findPathDataWithType(TMapPathType type, TMapPoint startpoint, TMapPoint endpoint, ArrayList<TMapPoint> passList, int searchOption) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        TMapPolyLine polyline = new TMapPolyLine();
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        if (TMapPathType.CAR_PATH == type) {
            uri.append("routes?version=1");
        } else if (TMapPathType.PEDESTRIAN_PATH == type) {
            uri.append("routes/pedestrian?version=1");
        }
        StringBuilder content = new StringBuilder();
        content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
        content.append("&startY=").append(startpoint.getLatitude());
        content.append("&startX=").append(startpoint.getLongitude());
        content.append("&endY=").append(endpoint.getLatitude());
        content.append("&endX=").append(endpoint.getLongitude());
        content.append("&startName=").append(URLEncoder.encode("\ucd9c\ubc1c\uc9c0", "UTF-8"));
        content.append("&endName=").append(URLEncoder.encode("\ub3c4\ucc29\uc9c0", "UTF-8"));
        content.append("&searchOption=").append(searchOption);
        String strPass = null;
        String strPassList = "";
        if (passList != null && passList.size() > 0) {
            for (int i = 0; i < passList.size(); ++i) {
                strPass = passList.get(i).getLongitude() + "," + passList.get(i).getLatitude();
                if (i != passList.size() - 1) {
                    strPass = strPass + "_";
                }
                strPassList = strPassList + strPass;
            }
            content.append("&passList=").append(URLEncoder.encode(strPassList, "UTF-8"));
        }
        if ((doc = TMapData.getDownloadFromPostUrl("findPathDataWithType", uri.toString(), content.toString(), false)) != null) {
            NodeList placemark = doc.getElementsByTagName("Placemark");
            for (int i = 0; i < placemark.getLength(); ++i) {
                String str;
                String lineIndex;
                Element item = (Element)placemark.item(i);
                String pointType = HttpConnect.getContentFromNode(item, "tmap:pointType");
                if (pointType != null) {
                    TMapPoint point;
                    String[] coord2;
                    String pointCoord;
                    if (TMapPathType.CAR_PATH == type) {
                        if (pointType.matches("B.*") && (pointCoord = HttpConnect.getContentFromNode(item, "coordinates")) != null) {
                            try {
                                coord2 = pointCoord.split(",");
                                point = new TMapPoint(Double.parseDouble(coord2[1]), Double.parseDouble(coord2[0]));
                                polyline.addPassPoint(point);
                            }
                            catch (Exception coord2) {}
                        }
                    } else if (TMapPathType.PEDESTRIAN_PATH == type && pointType.matches("PP.*") && (pointCoord = HttpConnect.getContentFromNode(item, "coordinates")) != null) {
                        try {
                            coord2 = pointCoord.split(",");
                            point = new TMapPoint(Double.parseDouble(coord2[1]), Double.parseDouble(coord2[0]));
                            polyline.addPassPoint(point);
                        }
                        catch (Exception coord3) {
                            // empty catch block
                        }
                    }
                }
                if ((lineIndex = HttpConnect.getContentFromNode(item, "tmap:lineIndex")) == null || (str = HttpConnect.getContentFromNode(item, "coordinates")) == null) continue;
                String[] str2 = str.split(" ");
                for (int k = 0; k < str2.length; ++k) {
                    try {
                        String[] str3 = str2[k].split(",");
                        TMapPoint point = new TMapPoint(Double.parseDouble(str3[1]), Double.parseDouble(str3[0]));
                        polyline.addLinePoint(point);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return polyline;
    }

    public void findPathDataWithType(final TMapPathType type, final TMapPoint startpoint, final TMapPoint endpoint, final ArrayList<TMapPoint> passList, final int searchOption, final FindPathDataListenerCallback findPathDataListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    TMapPolyLine polyline = new TMapPolyLine();
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    if (TMapPathType.CAR_PATH == type) {
                        uri.append("routes?version=1");
                    } else if (TMapPathType.PEDESTRIAN_PATH == type) {
                        uri.append("routes/pedestrian?version=1");
                    }
                    StringBuilder content = new StringBuilder();
                    content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
                    content.append("&startY=").append(startpoint.getLatitude());
                    content.append("&startX=").append(startpoint.getLongitude());
                    content.append("&endY=").append(endpoint.getLatitude());
                    content.append("&endX=").append(endpoint.getLongitude());
                    content.append("&startName=").append(URLEncoder.encode("\ucd9c\ubc1c\uc9c0", "UTF-8"));
                    content.append("&endName=").append(URLEncoder.encode("\ub3c4\ucc29\uc9c0", "UTF-8"));
                    content.append("&searchOption=").append(searchOption);
                    String strPass = null;
                    String strPassList = "";
                    if (passList != null && passList.size() > 0) {
                        for (int i = 0; i < passList.size(); ++i) {
                            strPass = ((TMapPoint)passList.get(i)).getLongitude() + "," + ((TMapPoint)passList.get(i)).getLatitude();
                            if (i != passList.size() - 1) {
                                strPass = strPass + "_";
                            }
                            strPassList = strPassList + strPass;
                        }
                        content.append("&passList=").append(URLEncoder.encode(strPassList, "UTF-8"));
                    }
                    if ((doc = TMapData.getDownloadFromPostUrl("findPathDataWithType", uri.toString(), content.toString(), false)) != null) {
                        NodeList placemark = doc.getElementsByTagName("Placemark");
                        for (int i = 0; i < placemark.getLength(); ++i) {
                            String str;
                            String lineIndex;
                            Element item = (Element)placemark.item(i);
                            String pointType = HttpConnect.getContentFromNode(item, "tmap:pointType");
                            if (pointType != null) {
                                TMapPoint point;
                                String[] coord2;
                                String pointCoord;
                                if (TMapPathType.CAR_PATH == type) {
                                    if (pointType.matches("B.*") && (pointCoord = HttpConnect.getContentFromNode(item, "coordinates")) != null) {
                                        try {
                                            coord2 = pointCoord.split(",");
                                            point = new TMapPoint(Double.parseDouble(coord2[1]), Double.parseDouble(coord2[0]));
                                            polyline.addPassPoint(point);
                                        }
                                        catch (Exception coord2) {}
                                    }
                                } else if (TMapPathType.PEDESTRIAN_PATH == type && pointType.matches("PP.*") && (pointCoord = HttpConnect.getContentFromNode(item, "coordinates")) != null) {
                                    try {
                                        coord2 = pointCoord.split(",");
                                        point = new TMapPoint(Double.parseDouble(coord2[1]), Double.parseDouble(coord2[0]));
                                        polyline.addPassPoint(point);
                                    }
                                    catch (Exception coord3) {
                                        // empty catch block
                                    }
                                }
                            }
                            if ((lineIndex = HttpConnect.getContentFromNode(item, "tmap:lineIndex")) == null || (str = HttpConnect.getContentFromNode(item, "coordinates")) == null) continue;
                            String[] str2 = str.split(" ");
                            for (int k = 0; k < str2.length; ++k) {
                                try {
                                    String[] str3 = str2[k].split(",");
                                    TMapPoint point = new TMapPoint(Double.parseDouble(str3[1]), Double.parseDouble(str3[0]));
                                    polyline.addLinePoint(point);
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    findPathDataListener.onFindPathData(polyline);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public TMapPolyLine findMultiPointPathData(TMapPoint startpoint, TMapPoint endpoint, ArrayList<TMapPoint> passList, int searchOption) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        TMapPolyLine polyline = new TMapPolyLine();
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("routes/routeSequential30?version=1&format=xml");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm", Locale.US);
        String strRequestTime = dateFormat.format(new Date(System.currentTimeMillis()));
        StringBuilder content = new StringBuilder();
        content.append("{");
        content.append("\t\"searchOption\" : \"" + searchOption + "\",");
        content.append("\t\"reqCoordType\" : \"WGS84GEO\",");
        content.append("\t\"resCoordType\" : \"WGS84GEO\",");
        content.append("\t\"startName\" : \"\ucd9c\ubc1c\",");
        content.append("\t\"startX\" : \"" + startpoint.getLongitude() + "\",");
        content.append("\t\"startY\" : \"" + startpoint.getLatitude() + "\",");
        content.append("\t\"startTime\" : \"" + strRequestTime + "\",");
        content.append("\t\"endName\" : \"\ub3c4\ucc29\",");
        content.append("\t\"endX\" : \"" + endpoint.getLongitude() + "\",");
        content.append("\t\"endY\" : \"" + endpoint.getLatitude() + "\",");
        content.append("\t\"viaPoints\" : ");
        content.append("\t[");
        for (int i = 0; i < passList.size(); ++i) {
            content.append("\t    { ");
            content.append("\t\t\"viaPointId\" : \"via" + i + "\",");
            content.append("\t\t\"viaPointName\" : \"via" + i + "\",");
            content.append("\t\t\"viaX\" : \"" + passList.get(i).getLongitude() + "\",");
            content.append("\t\t\"viaY\" : \"" + passList.get(i).getLatitude() + "\"");
            content.append("\t    }");
            if (i >= passList.size() - 1) continue;
            content.append(",");
        }
        content.append("\t] \t");
        content.append("}");
        doc = TMapData.getDownloadFromPostUrl("findMultiPointPathData", uri.toString(), content.toString(), true);
        if (doc != null) {
            NodeList placemark = doc.getElementsByTagName("Placemark");
            for (int i = 0; i < placemark.getLength(); ++i) {
                Element elementLineString;
                String strCoordinates;
                Element item = (Element)placemark.item(i);
                String nodeType = HttpConnect.getContentFromNode(item, "tmap:nodeType");
                if (!nodeType.equals("LINE") || (strCoordinates = HttpConnect.getContentFromNode(elementLineString = (Element)item.getElementsByTagName("LineString").item(0), "coordinates")) == null) continue;
                try {
                    String[] arrCoordinates = strCoordinates.split(" ");
                    for (int j = 0; j < arrCoordinates.length; ++j) {
                        String[] arrCoordinate = arrCoordinates[j].split(",");
                        TMapPoint point = new TMapPoint(Double.parseDouble(arrCoordinate[1]), Double.parseDouble(arrCoordinate[0]));
                        polyline.addLinePoint(point);
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return polyline;
    }

    public void findMultiPointPathData(final TMapPoint startpoint, final TMapPoint endpoint, final ArrayList<TMapPoint> passList, final int searchOption, final FindPathDataListenerCallback findPathDataListener) {
        new Thread(){

            @Override
            public void run() {
                Document doc = null;
                TMapPolyLine polyline = new TMapPolyLine();
                StringBuilder uri = new StringBuilder();
                uri.append(dataUrl);
                uri.append("routes/routeSequential30?version=1&format=xml");
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm", Locale.US);
                String strRequestTime = dateFormat.format(new Date(System.currentTimeMillis()));
                StringBuilder content = new StringBuilder();
                content.append("{");
                content.append("\t\"searchOption\" : \"" + searchOption + "\",");
                content.append("\t\"reqCoordType\" : \"WGS84GEO\",");
                content.append("\t\"resCoordType\" : \"WGS84GEO\",");
                content.append("\t\"startName\" : \"\ucd9c\ubc1c\",");
                content.append("\t\"startX\" : \"" + startpoint.getLongitude() + "\",");
                content.append("\t\"startY\" : \"" + startpoint.getLatitude() + "\",");
                content.append("\t\"startTime\" : \"" + strRequestTime + "\",");
                content.append("\t\"endName\" : \"\ub3c4\ucc29\",");
                content.append("\t\"endX\" : \"" + endpoint.getLongitude() + "\",");
                content.append("\t\"endY\" : \"" + endpoint.getLatitude() + "\",");
                content.append("\t\"viaPoints\" : ");
                content.append("\t[");
                for (int i = 0; i < passList.size(); ++i) {
                    content.append("\t    { ");
                    content.append("\t\t\"viaPointId\" : \"via" + i + "\",");
                    content.append("\t\t\"viaPointName\" : \"via" + i + "\",");
                    content.append("\t\t\"viaX\" : \"" + ((TMapPoint)passList.get(i)).getLongitude() + "\",");
                    content.append("\t\t\"viaY\" : \"" + ((TMapPoint)passList.get(i)).getLatitude() + "\"");
                    content.append("\t    }");
                    if (i >= passList.size() - 1) continue;
                    content.append(",");
                }
                content.append("\t] \t");
                content.append("}");
                doc = TMapData.getDownloadFromPostUrl("findMultiPointPathData", uri.toString(), content.toString(), true);
                if (doc != null) {
                    NodeList placemark = doc.getElementsByTagName("Placemark");
                    for (int i = 0; i < placemark.getLength(); ++i) {
                        Element elementLineString;
                        String strCoordinates;
                        Element item = (Element)placemark.item(i);
                        String nodeType = HttpConnect.getContentFromNode(item, "tmap:nodeType");
                        if (!nodeType.equals("LINE") || (strCoordinates = HttpConnect.getContentFromNode(elementLineString = (Element)item.getElementsByTagName("LineString").item(0), "coordinates")) == null) continue;
                        try {
                            String[] arrCoordinates = strCoordinates.split(" ");
                            for (int j = 0; j < arrCoordinates.length; ++j) {
                                String[] arrCoordinate = arrCoordinates[j].split(",");
                                TMapPoint point = new TMapPoint(Double.parseDouble(arrCoordinate[1]), Double.parseDouble(arrCoordinate[0]));
                                polyline.addLinePoint(point);
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                findPathDataListener.onFindPathData(polyline);
            }
        }.start();
    }

    public ArrayList<TMapPOIItem> findAroundKeywordPOI(TMapPoint tmappoint, String keywordName, int nRadius, int nSearchCount) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("pois?version=1&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=json");
        uri.append("&centerLat=").append(tmappoint.getLatitude());
        uri.append("&centerLon=").append(tmappoint.getLongitude());
        uri.append("&searchtypCd=R");
        if (nRadius < 0) {
            uri.append("&radius=").append(1);
        } else if (nRadius > 33) {
            uri.append("&radius=").append(33);
        } else {
            uri.append("&radius=").append(nRadius);
        }
        if (nSearchCount <= 0) {
            uri.append("&count=").append(20);
        } else if (nSearchCount > 200) {
            uri.append("&count=").append(200);
        } else {
            uri.append("&count=").append(nSearchCount);
        }
        String utf8name = URLEncoder.encode(keywordName, "UTF-8");
        uri.append("&searchKeyword=").append(utf8name);
        uri.append("&poiGroupYn=Y");
        JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
        ArrayList<TMapPOIItem> allpoi = this.parseTmapPOIItemList(jsonObject);
        uri.delete(0, uri.length());
        return allpoi;
    }

    public void findAroundKeywordPOI(final TMapPoint tmappoint, final String keywordName, final int nRadius, final int nSearchCount, final FindAroundKeywordPOIListenerCallback findAroundKeywordPoiListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois?version=1&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=json");
                    uri.append("&centerLat=").append(tmappoint.getLatitude());
                    uri.append("&centerLon=").append(tmappoint.getLongitude());
                    uri.append("&searchtypCd=R");
                    if (nRadius < 0) {
                        uri.append("&radius=").append(1);
                    } else if (nRadius > 33) {
                        uri.append("&radius=").append(33);
                    } else {
                        uri.append("&radius=").append(nRadius);
                    }
                    if (nSearchCount <= 0) {
                        uri.append("&count=").append(20);
                    } else if (nSearchCount > 200) {
                        uri.append("&count=").append(200);
                    } else {
                        uri.append("&count=").append(nSearchCount);
                    }
                    String utf8name = URLEncoder.encode(keywordName, "UTF-8");
                    uri.append("&searchKeyword=").append(utf8name);
                    uri.append("&poiGroupYn=Y");
                    JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
                    ArrayList allpoi = TMapData.this.parseTmapPOIItemList(jsonObject);
                    uri.delete(0, uri.length());
                    findAroundKeywordPoiListener.onFindAroundKeywordPOI(allpoi);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public Document findTimeMachineCarPath(HashMap<String, String> pathInfo, Date date, ArrayList<TMapPoint> wayPoint) {
        Document doc = null;
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("routes/prediction?version=1");
        uri.append("&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
        uri.append("&callback=application/xml");
        String strStName = null;
        String strStlat = null;
        String strStlon = null;
        String strGolat = null;
        String strGolon = null;
        String strGoName = null;
        String strType = null;
        for (Map.Entry<String, String> e : pathInfo.entrySet()) {
            if (e.getKey().contains("rStName")) {
                strStName = e.getValue();
                continue;
            }
            if (e.getKey().contains("rStlat")) {
                strStlat = e.getValue();
                continue;
            }
            if (e.getKey().contains("rStlon")) {
                strStlon = e.getValue();
                continue;
            }
            if (e.getKey().contains("rGoName")) {
                strGoName = e.getValue();
                continue;
            }
            if (e.getKey().contains("rGolat")) {
                strGolat = e.getValue();
                continue;
            }
            if (e.getKey().contains("rGolon")) {
                strGolon = e.getValue();
                continue;
            }
            if (!e.getKey().contains("type")) continue;
            strType = e.getValue();
        }
        JSONStringer stringer = null;
        try {
            HashMap<String, Object> pkt = new HashMap<String, Object>();
            LinkedHashMap<String, String> data1 = new LinkedHashMap<String, String>();
            data1.put("name", strStName);
            data1.put("lat", strStlat);
            data1.put("lon", strStlon);
            LinkedHashMap<String, String> data2 = new LinkedHashMap<String, String>();
            data2.put("name", strGoName);
            data2.put("lat", strGolat);
            data2.put("lon", strGolon);
            pkt.put("departure", data1);
            pkt.put("destination", data2);
            pkt.put("predictionType", strType);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
            String nowAsString = df.format(date);
            pkt.put("predictionTime", nowAsString);
            if (wayPoint != null && wayPoint.size() > 0) {
                JSONObject obj = new JSONObject();
                JSONArray req = new JSONArray();
                for (int i = 0; i < wayPoint.size(); ++i) {
                    JSONObject reqObj = new JSONObject();
                    reqObj.put("lon", wayPoint.get(i).getLongitude());
                    reqObj.put("lat", wayPoint.get(i).getLatitude());
                    req.put((Object)reqObj);
                }
                obj.put("wayPoint", (Object)req);
                pkt.put("wayPoints", obj);
            }
            stringer = new JSONStringer();
            stringer.object();
            stringer.key("routesInfo");
            this.toJSON(pkt, stringer);
            stringer.endObject();
        }
        catch (JSONException e) {
            return null;
        }
        doc = TMapData.getDownloadFromPostUrl("findTimeMachineCarPath", uri.toString(), stringer.toString(), true);
        return doc;
    }

    public void findTimeMachineCarPath(final HashMap<String, String> pathInfo, final Date date, final ArrayList<TMapPoint> wayPoint, final FindTimeMachineCarPathListenerCallback findTimeMachineCarPathListener) {
        new Thread(){

            @Override
            public void run() {
                Document doc = null;
                StringBuilder uri = new StringBuilder();
                uri.append(dataUrl);
                uri.append("routes/prediction?version=1");
                uri.append("&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
                uri.append("&callback=application/xml");
                String strStName = null;
                String strStlat = null;
                String strStlon = null;
                String strGolat = null;
                String strGolon = null;
                String strGoName = null;
                String strType = null;
                for (Map.Entry e : pathInfo.entrySet()) {
                    if (((String)e.getKey()).contains("rStName")) {
                        strStName = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rStlat")) {
                        strStlat = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rStlon")) {
                        strStlon = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rGoName")) {
                        strGoName = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rGolat")) {
                        strGolat = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rGolon")) {
                        strGolon = (String)e.getValue();
                        continue;
                    }
                    if (!((String)e.getKey()).contains("type")) continue;
                    strType = (String)e.getValue();
                }
                JSONStringer stringer = null;
                try {
                    HashMap<String, Object> pkt = new HashMap<String, Object>();
                    LinkedHashMap<String, String> data1 = new LinkedHashMap<String, String>();
                    data1.put("name", strStName);
                    data1.put("lat", strStlat);
                    data1.put("lon", strStlon);
                    LinkedHashMap<String, String> data2 = new LinkedHashMap<String, String>();
                    data2.put("name", strGoName);
                    data2.put("lat", strGolat);
                    data2.put("lon", strGolon);
                    pkt.put("departure", data1);
                    pkt.put("destination", data2);
                    pkt.put("predictionType", strType);
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
                    String nowAsString = df.format(date);
                    pkt.put("predictionTime", nowAsString);
                    if (wayPoint != null && wayPoint.size() > 0) {
                        JSONObject obj = new JSONObject();
                        JSONArray req = new JSONArray();
                        for (int i = 0; i < wayPoint.size(); ++i) {
                            JSONObject reqObj = new JSONObject();
                            reqObj.put("lon", ((TMapPoint)wayPoint.get(i)).getLongitude());
                            reqObj.put("lat", ((TMapPoint)wayPoint.get(i)).getLatitude());
                            req.put((Object)reqObj);
                        }
                        obj.put("wayPoint", (Object)req);
                        pkt.put("wayPoints", obj);
                    }
                    stringer = new JSONStringer();
                    stringer.object();
                    stringer.key("routesInfo");
                    TMapData.this.toJSON(pkt, stringer);
                    stringer.endObject();
                }
                catch (JSONException e) {
                    return;
                }
                doc = TMapData.getDownloadFromPostUrl("findTimeMachineCarPath", uri.toString(), stringer.toString(), true);
                findTimeMachineCarPathListener.onFindTimeMachineCarPath(doc);
            }
        }.start();
    }

    public Document findTimeMachineCarPath(HashMap<String, String> pathInfo, Date date, ArrayList<TMapPoint> wayPoint, String searchOption) {
        Document doc = null;
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("routes/prediction?version=1");
        uri.append("&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
        uri.append("&callback=application/xml");
        String strStName = null;
        String strStlat = null;
        String strStlon = null;
        String strGolat = null;
        String strGolon = null;
        String strGoName = null;
        String strType = null;
        for (Map.Entry<String, String> e : pathInfo.entrySet()) {
            if (e.getKey().contains("rStName")) {
                strStName = e.getValue();
                continue;
            }
            if (e.getKey().contains("rStlat")) {
                strStlat = e.getValue();
                continue;
            }
            if (e.getKey().contains("rStlon")) {
                strStlon = e.getValue();
                continue;
            }
            if (e.getKey().contains("rGoName")) {
                strGoName = e.getValue();
                continue;
            }
            if (e.getKey().contains("rGolat")) {
                strGolat = e.getValue();
                continue;
            }
            if (e.getKey().contains("rGolon")) {
                strGolon = e.getValue();
                continue;
            }
            if (!e.getKey().contains("type")) continue;
            strType = e.getValue();
        }
        JSONStringer stringer = null;
        try {
            HashMap<String, Object> pkt = new HashMap<String, Object>();
            LinkedHashMap<String, String> data1 = new LinkedHashMap<String, String>();
            data1.put("name", strStName);
            data1.put("lat", strStlat);
            data1.put("lon", strStlon);
            LinkedHashMap<String, String> data2 = new LinkedHashMap<String, String>();
            data2.put("name", strGoName);
            data2.put("lat", strGolat);
            data2.put("lon", strGolon);
            pkt.put("departure", data1);
            pkt.put("destination", data2);
            pkt.put("predictionType", strType);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
            String nowAsString = df.format(date);
            pkt.put("predictionTime", nowAsString);
            if (wayPoint != null && wayPoint.size() > 0) {
                JSONObject obj = new JSONObject();
                JSONArray req = new JSONArray();
                for (int i = 0; i < wayPoint.size(); ++i) {
                    JSONObject reqObj = new JSONObject();
                    reqObj.put("lon", wayPoint.get(i).getLongitude());
                    reqObj.put("lat", wayPoint.get(i).getLatitude());
                    req.put((Object)reqObj);
                }
                obj.put("wayPoint", (Object)req);
                pkt.put("wayPoints", obj);
            }
            pkt.put("searchOption", searchOption);
            stringer = new JSONStringer();
            stringer.object();
            stringer.key("routesInfo");
            this.toJSON(pkt, stringer);
            stringer.endObject();
        }
        catch (JSONException e) {
            return null;
        }
        doc = TMapData.getDownloadFromPostUrl("findTimeMachineCarPath", uri.toString(), stringer.toString(), true);
        return doc;
    }

    public void findTimeMachineCarPath(final HashMap<String, String> pathInfo, final Date date, final ArrayList<TMapPoint> wayPoint, final String searchOption, final FindTimeMachineCarPathListenerCallback findTimeMachineCarPathListener) {
        new Thread(){

            @Override
            public void run() {
                Document doc = null;
                StringBuilder uri = new StringBuilder();
                uri.append(dataUrl);
                uri.append("routes/prediction?version=1");
                uri.append("&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
                uri.append("&callback=application/xml");
                String strStName = null;
                String strStlat = null;
                String strStlon = null;
                String strGolat = null;
                String strGolon = null;
                String strGoName = null;
                String strType = null;
                for (Map.Entry e : pathInfo.entrySet()) {
                    if (((String)e.getKey()).contains("rStName")) {
                        strStName = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rStlat")) {
                        strStlat = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rStlon")) {
                        strStlon = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rGoName")) {
                        strGoName = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rGolat")) {
                        strGolat = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rGolon")) {
                        strGolon = (String)e.getValue();
                        continue;
                    }
                    if (!((String)e.getKey()).contains("type")) continue;
                    strType = (String)e.getValue();
                }
                JSONStringer stringer = null;
                try {
                    HashMap<String, Object> pkt = new HashMap<String, Object>();
                    LinkedHashMap<String, String> data1 = new LinkedHashMap<String, String>();
                    data1.put("name", strStName);
                    data1.put("lat", strStlat);
                    data1.put("lon", strStlon);
                    LinkedHashMap<String, String> data2 = new LinkedHashMap<String, String>();
                    data2.put("name", strGoName);
                    data2.put("lat", strGolat);
                    data2.put("lon", strGolon);
                    pkt.put("departure", data1);
                    pkt.put("destination", data2);
                    pkt.put("predictionType", strType);
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
                    String nowAsString = df.format(date);
                    pkt.put("predictionTime", nowAsString);
                    if (wayPoint != null && wayPoint.size() > 0) {
                        JSONObject obj = new JSONObject();
                        JSONArray req = new JSONArray();
                        for (int i = 0; i < wayPoint.size(); ++i) {
                            JSONObject reqObj = new JSONObject();
                            reqObj.put("lon", ((TMapPoint)wayPoint.get(i)).getLongitude());
                            reqObj.put("lat", ((TMapPoint)wayPoint.get(i)).getLatitude());
                            req.put((Object)reqObj);
                        }
                        obj.put("wayPoint", (Object)req);
                        pkt.put("wayPoints", obj);
                    }
                    pkt.put("searchOption", searchOption);
                    stringer = new JSONStringer();
                    stringer.object();
                    stringer.key("routesInfo");
                    TMapData.this.toJSON(pkt, stringer);
                    stringer.endObject();
                }
                catch (JSONException e) {
                    return;
                }
                doc = TMapData.getDownloadFromPostUrl("findTimeMachineCarPath", uri.toString(), stringer.toString(), true);
                findTimeMachineCarPathListener.onFindTimeMachineCarPath(doc);
            }
        }.start();
    }

    private void addAutoName(String id, TMapAutoComplete name) {
        if (autoName.size() > 9) {
            Iterator<String> iterator = autoName.keySet().iterator();
            autoName.remove(iterator.next());
        }
        autoName.put(id, name);
    }

    private TMapAutoComplete getAutoName(String id) {
        return autoName.get(id);
    }

    public ArrayList<String> autoComplete(String keywordName) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        TMapAutoComplete poiitem = new TMapAutoComplete();
        String name = null;
        Document doc = null;
        try {
            StringBuilder uri = new StringBuilder();
            uri.append(dataUrl);
            uri.append("poi/autoComplete?version=1&format=xml");
            String utf8name = URLEncoder.encode(keywordName, "UTF-8");
            uri.append("&searchKeyword=").append(utf8name);
            doc = TMapData.getDownloadFromUrl(uri.toString(), "autoComplete");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("suggestions");
            for (int i = 0; i < list.getLength(); ++i) {
                Element item = (Element)list.item(i);
                name = HttpConnect.getContentFromNode(item, "keyword");
                poiitem.addName(name);
            }
        }
        return poiitem.getNameArry();
    }

    public void autoComplete(final String keywordName, final AutoCompleteListenerCallback autoCompleteListener) {
        new Thread(){

            @Override
            public void run() {
                TMapAutoComplete autoComplete = null;
                autoComplete = TMapData.this.getAutoName(keywordName);
                ArrayList<String> nameArry = null;
                if (autoComplete != null) {
                    nameArry = autoComplete.getNameArry();
                    autoCompleteListener.onAutoComplete(nameArry);
                } else {
                    Document doc = null;
                    String name = null;
                    TMapAutoComplete poiitem = new TMapAutoComplete();
                    try {
                        StringBuilder uri = new StringBuilder();
                        uri.append(dataUrl);
                        uri.append("poi/autoComplete?version=1&format=xml");
                        String utf8name = URLEncoder.encode(keywordName, "UTF-8");
                        uri.append("&searchKeyword=").append(utf8name);
                        doc = TMapData.getDownloadFromUrl(uri.toString(), "autoComplete");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("suggestions");
                        for (int i = 0; i < list.getLength(); ++i) {
                            Element item = (Element)list.item(i);
                            name = HttpConnect.getContentFromNode(item, "keyword");
                            poiitem.addName(name);
                        }
                    }
                    TMapData.this.addAutoName(keywordName, poiitem);
                    autoCompleteListener.onAutoComplete(poiitem.getNameArry());
                }
            }
        }.start();
    }

    public ArrayList<TMapAutoCompleteV2> autoCompleteV2(String searchKeyword, double centerLat, double centerLon, int radius, int count) {
        try {
            StringBuilder uri = new StringBuilder();
            uri.append(dataUrl);
            uri.append("poi/autoCompleteV2?version=1&format=json");
            String utf8Keyword = URLEncoder.encode(searchKeyword, "UTF-8");
            uri.append("&searchKeyword=").append(utf8Keyword);
            if (centerLat > 0.0 && centerLon > 0.0) {
                uri.append("&centerLat=").append(centerLat);
                uri.append("&centerLon=").append(centerLon);
            }
            if (0 <= radius && radius <= 33) {
                uri.append("&radius=").append(radius);
            }
            if (count > 100) {
                uri.append("&numResults=100");
            } else if (1 <= count) {
                uri.append("&numResults=").append(count);
            }
            JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
            if (jsonObject != null) {
                return this.parseAutoCompleteV2List(jsonObject);
            }
            return new ArrayList<TMapAutoCompleteV2>();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<TMapAutoCompleteV2>();
        }
    }

    public void autoCompleteV2(final String searchKeyword, final double centerLat, final double centerLon, final int radius, final int count, final AutoCompleteCallbackV2 callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("poi/autoCompleteV2?version=1&format=json");
                    String utf8Keyword = URLEncoder.encode(searchKeyword, "UTF-8");
                    uri.append("&searchKeyword=").append(utf8Keyword);
                    if (centerLat > 0.0 && centerLon > 0.0) {
                        uri.append("&centerLat=").append(centerLat);
                        uri.append("&centerLon=").append(centerLon);
                    }
                    if (0 <= radius && radius <= 33) {
                        uri.append("&radius=").append(radius);
                    }
                    if (count > 100) {
                        uri.append("&numResults=100");
                    } else if (1 <= count) {
                        uri.append("&numResults=").append(count);
                    }
                    JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
                    if (jsonObject != null) {
                        ArrayList itemList = TMapData.this.parseAutoCompleteV2List(jsonObject);
                        callback.onAutoComplete(itemList);
                    } else {
                        ArrayList<TMapAutoCompleteV2> emptyList = new ArrayList<TMapAutoCompleteV2>();
                        callback.onAutoComplete(emptyList);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ArrayList<TMapAutoCompleteV2> emptyList = new ArrayList<TMapAutoCompleteV2>();
                    callback.onAutoComplete(emptyList);
                }
            }
        }).start();
    }

    public void findPoiAreaDataByName(final int count, final int page, final String data, final FindAllPOIListenerCallback findAllPoiListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    String encodedData = URLEncoder.encode(data, "UTF-8");
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("poi/findPoiAreaDataByName?version=1&addressType=all&resCoordType=WGS84GEO&format=json");
                    if (count < 1) {
                        uri.append("&count=").append(1);
                    } else if (count > 200) {
                        uri.append("&count=").append(200);
                    } else {
                        uri.append("&count=").append(count);
                    }
                    if (count < 1) {
                        uri.append("&page=").append(1);
                    } else if (count > 200) {
                        uri.append("&page=").append(200);
                    } else {
                        uri.append("&page=").append(page);
                    }
                    uri.append("&area_dong=").append(encodedData);
                    ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
                    JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
                    if (jsonObject != null) {
                        JSONObject root = jsonObject.getJSONObject("findPoiAreaDataByNameInfo");
                        JSONArray dongInfoArray = TMapData.this.getJsonArray(root, "dongInfo");
                        for (int i = 0; i < dongInfoArray.length(); ++i) {
                            JSONObject dongInfo = TMapData.this.getJsonObject(dongInfoArray, i);
                            TMapPOIItem poiItem = new TMapPOIItem();
                            poiItem.name = TMapData.this.getJsonString(dongInfo, "address");
                            poiItem.noorLat = TMapData.this.getJsonString(dongInfo, "resLat");
                            poiItem.noorLon = TMapData.this.getJsonString(dongInfo, "resLon");
                            allpoi.add(poiItem);
                        }
                    }
                    findAllPoiListener.onFindAllPOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void findPOIDetailInfo(final String poiId, final FindAllPOIListenerCallback findAllPoiListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois/");
                    uri.append(poiId);
                    uri.append("?version=1&resCoordType=WGS84GEO&format=json");
                    JSONObject jsonObject = TMapData.getDownloadFromUrlJson(uri.toString());
                    ArrayList allpoi = TMapData.this.parseTmapPoiDetail(jsonObject);
                    uri.delete(0, uri.length());
                    findAllPoiListener.onFindAllPOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void setResponseCodeInfoCallBack(OnResponseCodeInfoCallback listener) {
        responseCodeListener = listener;
    }

    private static Document getDownloadFromUrl(String url, String apiName) {
        Document doc = null;
        URLConnection con = HttpConnect.getDownloadFromUrl(url);
        try {
            HttpURLConnection urlCon = (HttpURLConnection)con;
            if (responseCodeListener != null) {
                responseCodeListener.responseCodeInfo(apiName, urlCon.getResponseCode(), url);
            }
            if (con != null && (doc = HttpConnect.getDocument(con)) == null && urlCon.getResponseCode() != 200) {
                if (urlCon.getResponseMessage().equals("Unauthorized")) {
                    Log.w((String)"SKT", (String)"\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 API Key \uc785\ub2c8\ub2e4.");
                } else if (urlCon.getResponseMessage().equals("Bad Request")) {
                    Log.w((String)"SKT", (String)"\uc694\uccad \ub370\uc774\ud130 \uc624\ub958\uc785\ub2c8\ub2e4.");
                } else {
                    Log.w((String)"SKT", (String)urlCon.getResponseMessage());
                }
            }
        }
        catch (IOException e) {
            return doc;
        }
        return doc;
    }

    private static Document getDownloadFromPostUrl(String apiName, String url, String contents, boolean conTypeJason) {
        Document doc = null;
        URLConnection con = HttpConnect.getDownloadFromPostUrl(url, contents, conTypeJason);
        try {
            HttpURLConnection urlCon = (HttpURLConnection)con;
            if (responseCodeListener != null) {
                responseCodeListener.responseCodeInfo(apiName, urlCon.getResponseCode(), url + "/" + contents);
            }
            if (con != null && (doc = HttpConnect.getDocument(con)) == null && urlCon.getResponseCode() != 200) {
                if (urlCon.getResponseMessage().equals("Unauthorized")) {
                    Log.w((String)"SKT", (String)"\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 API Key \uc785\ub2c8\ub2e4.");
                } else if (urlCon.getResponseMessage().equals("Bad Request")) {
                    Log.w((String)"SKT", (String)"\uc694\uccad \ub370\uc774\ud130 \uc624\ub958\uc785\ub2c8\ub2e4.");
                } else {
                    Log.w((String)"SKT", (String)urlCon.getResponseMessage());
                }
            }
        }
        catch (IOException e) {
            return doc;
        }
        return doc;
    }

    private void toJSON(Map<?, ?> map, JSONStringer stringer) throws JSONException {
        stringer.object();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            stringer.key(String.valueOf(entry.getKey()));
            this.toJSONValue(entry.getValue(), stringer);
        }
        stringer.endObject();
    }

    private void toJSONValue(Object value, JSONStringer stringer) throws JSONException {
        if (value == null) {
            stringer.value(null);
        } else if (value instanceof Collection) {
            this.toJSON((Collection)value, stringer);
        } else if (value instanceof Map) {
            this.toJSON((Map)value, stringer);
        } else if (value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                stringer.array();
                if (value instanceof byte[]) {
                    for (byte b : (byte[])value) {
                        stringer.value((long)b);
                    }
                } else if (value instanceof short[]) {
                    for (short s : (short[])value) {
                        stringer.value((long)s);
                    }
                } else if (value instanceof int[]) {
                    for (int i : (int[])value) {
                        stringer.value((long)i);
                    }
                } else if (value instanceof float[]) {
                    for (float f : (float[])value) {
                        stringer.value((double)f);
                    }
                } else if (value instanceof double[]) {
                    for (double d : (double[])value) {
                        stringer.value(d);
                    }
                } else if (value instanceof char[]) {
                    for (char c : (char[])value) {
                        stringer.value((long)c);
                    }
                } else if (value instanceof boolean[]) {
                    for (boolean b : (boolean[])value) {
                        stringer.value(b);
                    }
                }
                stringer.endArray();
            } else {
                this.toJSON((Object[])value, stringer);
            }
        } else {
            stringer.value(value);
        }
    }

    public void findTrafficData(final double minLat, final double minLon, final double maxLat, final double maxLon, final float zoomLevel, final findTrafficDataCallBack callBack) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        if (!MapUtils.isVerifyApiKey) {
            Log.w((String)"SKT", (String)"AppKey \uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uac70\ub098 AppKey \uc778\uc99d\uacb0\uacfc\uac00 \uc624\uae30 \uc804\uc5d0 \ud638\ucd9c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
            callBack.onTrafficDataCallBack(null);
            return;
        }
        new Thread(){

            @Override
            public void run() {
                Document doc = null;
                ArrayList<TMapPolyLine> responseList = new ArrayList<TMapPolyLine>();
                StringBuilder uri = new StringBuilder();
                uri.append(dataUrl);
                uri.append("traffic?version=1");
                uri.append("&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml&simpleOption=Y");
                uri.append("&minLat=").append(minLat);
                uri.append("&minLon=").append(minLon);
                uri.append("&maxLat=").append(maxLat);
                uri.append("&maxLon=").append(maxLon);
                uri.append("&zoomLevel=").append((int)zoomLevel);
                doc = TMapData.getDownloadFromUrl(uri.toString(), "findTrafficData");
                if (doc != null) {
                    NodeList list = doc.getElementsByTagName("Placemark");
                    for (int i = 0; i < list.getLength(); ++i) {
                        Element item = (Element)list.item(i);
                        String congestion = HttpConnect.getContentFromNode(item, "tmap:congestion");
                        String str = HttpConnect.getContentFromNode(item, "coordinates");
                        if (str == null) continue;
                        TMapPolyLine polyline = new TMapPolyLine();
                        String[] str2 = str.split(" ");
                        for (int k = 0; k < str2.length; ++k) {
                            try {
                                String[] str3 = str2[k].split(",");
                                TMapPoint point = new TMapPoint(Double.parseDouble(str3[1]), Double.parseDouble(str3[0]));
                                polyline.addLinePoint(point);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (congestion != null && congestion.equals("1")) {
                            polyline.setLineColor(Color.rgb((int)0, (int)255, (int)0));
                        } else if (congestion != null && congestion.equals("2")) {
                            polyline.setLineColor(Color.rgb((int)255, (int)255, (int)0));
                        } else if (congestion != null && congestion.equals("3")) {
                            polyline.setLineColor(Color.rgb((int)255, (int)128, (int)0));
                        } else if (congestion != null && congestion.equals("4")) {
                            polyline.setLineColor(Color.rgb((int)255, (int)0, (int)0));
                        } else {
                            polyline.setLineColor(Color.rgb((int)130, (int)130, (int)135));
                        }
                        polyline.setOutLineAlpha(30);
                        responseList.add(polyline);
                    }
                }
                doc = null;
                uri.delete(0, uri.length());
                callBack.onTrafficDataCallBack(responseList);
            }
        }.start();
    }

    private void toJSON(Object[] array, JSONStringer stringer) throws JSONException {
        stringer.array();
        for (Object value : array) {
            this.toJSONValue(value, stringer);
        }
        stringer.endArray();
    }

    private void toJSON(Collection<?> collection, JSONStringer stringer) throws JSONException {
        stringer.array();
        for (Object value : collection) {
            this.toJSONValue(value, stringer);
        }
        stringer.endArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject getDownloadFromUrlJson(String url) {
        StringBuilder result = new StringBuilder();
        BufferedReader reader = null;
        try {
            JSONObject object;
            String line;
            URLConnection con = HttpConnect.getDownloadFromUrl(url);
            reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            JSONObject jSONObject = object = new JSONObject(result.toString());
            MapUtils.closeStream(reader);
            return jSONObject;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            MapUtils.closeStream(reader);
        }
        return null;
    }

    private JSONObject getJsonObject(JSONObject json, String key) {
        try {
            return json.getJSONObject(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    private JSONObject getJsonObject(JSONArray json, int index) {
        try {
            return json.getJSONObject(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    private JSONArray getJsonArray(JSONObject json, String key) {
        try {
            return json.getJSONArray(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getJsonString(JSONObject json, String key) {
        try {
            return json.getString(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    private TMapAddressInfo parseTmapAddressInfo(JSONObject jsonObject) {
        TMapAddressInfo info = new TMapAddressInfo();
        JSONObject addressInfo = this.getJsonObject(jsonObject, "addressInfo");
        info.strFullAddress = this.getJsonString(addressInfo, "fullAddress");
        info.strAddressKey = this.getJsonString(addressInfo, "addressKey");
        info.strRoadAddressKey = this.getJsonString(addressInfo, "roadAddressKey");
        info.strAddressType = this.getJsonString(addressInfo, "addressType");
        info.strCity_do = this.getJsonString(addressInfo, "city_do");
        info.strGu_gun = this.getJsonString(addressInfo, "gu_gun");
        info.strEup_myun = this.getJsonString(addressInfo, "eup_myun");
        info.strAdminDong = this.getJsonString(addressInfo, "adminDong");
        info.strAdminDongCode = this.getJsonString(addressInfo, "adminDongCode");
        info.strLegalDong = this.getJsonString(addressInfo, "legalDong");
        info.strLegalDongCode = this.getJsonString(addressInfo, "legalDongCode");
        info.strRi = this.getJsonString(addressInfo, "ri");
        info.strBunji = this.getJsonString(addressInfo, "bunji");
        info.strRoadName = this.getJsonString(addressInfo, "roadName");
        info.strBuildingIndex = this.getJsonString(addressInfo, "buildingIndex");
        info.strBuildingName = this.getJsonString(addressInfo, "buildingName");
        info.strMappingDistance = this.getJsonString(addressInfo, "mappingDistance");
        info.strRoadCode = this.getJsonString(addressInfo, "roadCode");
        JSONObject child1 = this.getJsonObject(addressInfo, "adminDongCoord");
        if (child1 != null) {
            info.adminDongCoord = new AdminDongCoord();
            info.adminDongCoord.strLat = this.getJsonString(child1, "lat");
            info.adminDongCoord.strLon = this.getJsonString(child1, "lon");
            info.adminDongCoord.strLatEntr = this.getJsonString(child1, "latEntr");
            info.adminDongCoord.strLonEntr = this.getJsonString(child1, "lonEntr");
        } else {
            info.adminDongCoord = null;
        }
        JSONObject child2 = this.getJsonObject(addressInfo, "legalDongCoord");
        if (child2 != null) {
            info.legalDongCoord = new LegalDongCoord();
            info.legalDongCoord.strLat = this.getJsonString(child2, "lat");
            info.legalDongCoord.strLon = this.getJsonString(child2, "lon");
            info.legalDongCoord.strLatEntr = this.getJsonString(child2, "latEntr");
            info.legalDongCoord.strLonEntr = this.getJsonString(child2, "lonEntr");
        } else {
            info.adminDongCoord = null;
        }
        JSONObject child3 = this.getJsonObject(addressInfo, "adminDongCoord");
        if (child3 != null) {
            info.roadCoord = new RoadCoord();
            info.roadCoord.strLat = this.getJsonString(child3, "lat");
            info.roadCoord.strLon = this.getJsonString(child3, "lon");
            info.roadCoord.strLatEntr = this.getJsonString(child3, "latEntr");
            info.roadCoord.strLonEntr = this.getJsonString(child3, "lonEntr");
        } else {
            info.adminDongCoord = null;
        }
        return info;
    }

    private ArrayList<TMapPOIItem> parseTmapPOIItemList(JSONObject jsonObject) {
        ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
        JSONObject searchPoiInfo = this.getJsonObject(jsonObject, "searchPoiInfo");
        JSONObject pois = this.getJsonObject(searchPoiInfo, "pois");
        JSONArray poiArray = this.getJsonArray(pois, "poi");
        for (int i = 0; i < poiArray.length(); ++i) {
            JSONObject jsonItem = this.getJsonObject(poiArray, i);
            TMapPOIItem poiItem = new TMapPOIItem();
            poiItem.id = this.getJsonString(jsonItem, "id");
            poiItem.pkey = this.getJsonString(jsonItem, "pkey");
            poiItem.navSeq = this.getJsonString(jsonItem, "navSeq");
            poiItem.collectionType = this.getJsonString(jsonItem, "collectionType");
            poiItem.name = this.getJsonString(jsonItem, "name");
            poiItem.telNo = this.getJsonString(jsonItem, "telNo");
            poiItem.frontLat = this.getJsonString(jsonItem, "frontLat");
            poiItem.frontLon = this.getJsonString(jsonItem, "frontLon");
            poiItem.noorLat = this.getJsonString(jsonItem, "noorLat");
            poiItem.noorLon = this.getJsonString(jsonItem, "noorLon");
            poiItem.upperAddrName = this.getJsonString(jsonItem, "upperAddrName");
            poiItem.middleAddrName = this.getJsonString(jsonItem, "middleAddrName");
            poiItem.lowerAddrName = this.getJsonString(jsonItem, "lowerAddrName");
            poiItem.detailAddrName = this.getJsonString(jsonItem, "detailAddrName");
            poiItem.mlClass = this.getJsonString(jsonItem, "mlClass");
            poiItem.firstNo = this.getJsonString(jsonItem, "firstNo");
            poiItem.secondNo = this.getJsonString(jsonItem, "firstNo");
            poiItem.roadName = this.getJsonString(jsonItem, "roadName");
            poiItem.buildingNo1 = this.getJsonString(jsonItem, "buildingNo1");
            poiItem.buildingNo2 = this.getJsonString(jsonItem, "buildingNo2");
            poiItem.firstBuildNo = this.getJsonString(jsonItem, "firstBuildNo");
            poiItem.secondBuildNo = this.getJsonString(jsonItem, "secondBuildNo");
            poiItem.radius = this.getJsonString(jsonItem, "radius");
            poiItem.bizName = this.getJsonString(jsonItem, "bizName");
            poiItem.upperBizName = this.getJsonString(jsonItem, "upperBizName");
            poiItem.middleBizName = this.getJsonString(jsonItem, "middleBizName");
            poiItem.lowerBizName = this.getJsonString(jsonItem, "lowerBizName");
            poiItem.detailBizName = this.getJsonString(jsonItem, "detailBizName");
            poiItem.rpFlag = this.getJsonString(jsonItem, "rpFlag");
            poiItem.parkFlag = this.getJsonString(jsonItem, "parkFlag");
            poiItem.detailInfoFlag = this.getJsonString(jsonItem, "detailInfoFlag");
            poiItem.desc = this.getJsonString(jsonItem, "desc");
            poiItem.merchanFlag = this.getJsonString(jsonItem, "merchantFlag");
            poiItem.dataKind = this.getJsonString(jsonItem, "dataKind");
            poiItem.stId = this.getJsonString(jsonItem, "stId");
            poiItem.highHhSale = this.getJsonString(jsonItem, "highHhSale");
            poiItem.minOilYn = this.getJsonString(jsonItem, "minOilYn");
            poiItem.oilBaseSdt = this.getJsonString(jsonItem, "oilBaseSdt");
            poiItem.hhPrice = this.getJsonString(jsonItem, "hhPrice");
            poiItem.ggPrice = this.getJsonString(jsonItem, "ggPrice");
            poiItem.llPrice = this.getJsonString(jsonItem, "llPrice");
            poiItem.highHhPrice = this.getJsonString(jsonItem, "highHhPrice");
            poiItem.highGgPrice = this.getJsonString(jsonItem, "highGgPrice");
            poiItem.groupSubList = new ArrayList();
            JSONObject groupJson = this.getJsonObject(jsonItem, "groupSubLists");
            if (groupJson != null) {
                JSONArray groupArr = this.getJsonArray(groupJson, "groupSub");
                for (int j = 0; j < groupArr.length(); ++j) {
                    GroupSub groupSub = new GroupSub();
                    JSONObject gJson = this.getJsonObject(groupArr, j);
                    groupSub.subPkey = this.getJsonString(gJson, "subPkey");
                    groupSub.subSeq = this.getJsonString(gJson, "subSeq");
                    groupSub.subName = this.getJsonString(gJson, "subName");
                    groupSub.subCenterY = this.getJsonString(gJson, "subCenterY");
                    groupSub.subCenterX = this.getJsonString(gJson, "subCenterX");
                    groupSub.subNavY = this.getJsonString(gJson, "subNavY");
                    groupSub.subNavX = this.getJsonString(gJson, "subNavX");
                    groupSub.subRpFlag = this.getJsonString(gJson, "subRpFlag");
                    groupSub.subPoiId = this.getJsonString(gJson, "subPoiId");
                    groupSub.subNavSeq = this.getJsonString(gJson, "subNavSeq");
                    groupSub.subParkYn = this.getJsonString(gJson, "subParkYn");
                    groupSub.subClassCd = this.getJsonString(gJson, "subClassCd");
                    groupSub.subClassNmA = this.getJsonString(gJson, "subClassNmA");
                    groupSub.subClassNmB = this.getJsonString(gJson, "subClassNmB");
                    groupSub.subClassNmC = this.getJsonString(gJson, "subClassNmC");
                    groupSub.subClassNmD = this.getJsonString(gJson, "subClassNmD");
                    poiItem.groupSubList.add(groupSub);
                }
            }
            poiItem.newAddressList = new ArrayList();
            JSONObject newAddressJson = this.getJsonObject(jsonItem, "newAddressList");
            if (newAddressJson != null) {
                JSONArray newAddressArr = this.getJsonArray(newAddressJson, "newAddress");
                for (int j = 0; j < newAddressArr.length(); ++j) {
                    JSONObject newJson = this.getJsonObject(newAddressArr, j);
                    NewAddress newAddress = new NewAddress();
                    newAddress.centerLat = this.getJsonString(newJson, "centerLat");
                    newAddress.centerLon = this.getJsonString(newJson, "centerLon");
                    newAddress.frontLat = this.getJsonString(newJson, "frontLat");
                    newAddress.frontLon = this.getJsonString(newJson, "frontLon");
                    newAddress.roadName = this.getJsonString(newJson, "roadName");
                    newAddress.bldNo1 = this.getJsonString(newJson, "bldNo1");
                    newAddress.bldNo2 = this.getJsonString(newJson, "bldNo2");
                    newAddress.roadId = this.getJsonString(newJson, "roadId");
                    newAddress.fullAddressRoad = this.getJsonString(newJson, "fullAddressRoad");
                    poiItem.newAddressList.add(newAddress);
                }
            }
            allpoi.add(poiItem);
        }
        return allpoi;
    }

    private ArrayList<TMapPOIItem> parseTmapPoiDetail(JSONObject jsonObject) {
        TMapPOIItem poiItem = new TMapPOIItem();
        JSONObject root = this.getJsonObject(jsonObject, "poiDetailInfo");
        poiItem.id = this.getJsonString(root, "id");
        poiItem.viewId = this.getJsonString(root, "viewId");
        poiItem.dbKind = this.getJsonString(root, "dbKind");
        poiItem.pkey = this.getJsonString(root, "pkey");
        poiItem.navSeq = this.getJsonString(root, "navSeq");
        poiItem.name = this.getJsonString(root, "name");
        poiItem.bizCatName = this.getJsonString(root, "bizCatName");
        poiItem.address = this.getJsonString(root, "address");
        poiItem.firstNo = this.getJsonString(root, "firstNo");
        poiItem.secondNo = this.getJsonString(root, "secondNo");
        poiItem.zipCode = this.getJsonString(root, "zipCode");
        poiItem.telNo = this.getJsonString(root, "tel");
        poiItem.mlClass = this.getJsonString(root, "mlClass");
        poiItem.lcdName = this.getJsonString(root, "lcdName");
        poiItem.mcdName = this.getJsonString(root, "mcdName");
        poiItem.scdName = this.getJsonString(root, "scdName");
        poiItem.dcdName = this.getJsonString(root, "dcdName");
        poiItem.bldAddr = this.getJsonString(root, "bldAddr");
        poiItem.roadScdName = this.getJsonString(root, "roadScdName");
        poiItem.roadName = this.getJsonString(root, "roadName");
        poiItem.bldNo1 = this.getJsonString(root, "bldNo1");
        poiItem.bldNo2 = this.getJsonString(root, "bldNo2");
        poiItem.noorLat = this.getJsonString(root, "lat");
        poiItem.noorLon = this.getJsonString(root, "lon");
        poiItem.frontLat = this.getJsonString(root, "frontLat");
        poiItem.frontLon = this.getJsonString(root, "frontLon");
        poiItem.menu1 = this.getJsonString(root, "menu1");
        poiItem.menu2 = this.getJsonString(root, "menu2");
        poiItem.menu3 = this.getJsonString(root, "menu3");
        poiItem.menu4 = this.getJsonString(root, "menu4");
        poiItem.menu5 = this.getJsonString(root, "menu5");
        poiItem.parkFlag = this.getJsonString(root, "parkFlag");
        poiItem.twFlag = this.getJsonString(root, "twFlag");
        poiItem.yaFlag = this.getJsonString(root, "yaFlag");
        poiItem.homepageURL = this.getJsonString(root, "homepageURL");
        poiItem.routeInfo = this.getJsonString(root, "routeInfo");
        poiItem.facility = this.getJsonString(root, "facility");
        poiItem.upperLegalCode = this.getJsonString(root, "upperLegalCode");
        poiItem.middleLegalCode = this.getJsonString(root, "middleLegalCode");
        poiItem.lowerLegalCode = this.getJsonString(root, "lowerLegalCode");
        poiItem.detailLegalCode = this.getJsonString(root, "detailLegalCode");
        poiItem.upperAdminCode = this.getJsonString(root, "upperAdminCode");
        poiItem.middleAdminCode = this.getJsonString(root, "middleAdminCode");
        poiItem.lowerAdminCode = this.getJsonString(root, "lowerAdminCode");
        poiItem.upperCode = this.getJsonString(root, "upperCode");
        poiItem.middleCode = this.getJsonString(root, "middleCode");
        poiItem.lowerCode = this.getJsonString(root, "lowerCode");
        poiItem.participant = this.getJsonString(root, "participant");
        poiItem.point = this.getJsonString(root, "point");
        poiItem.merchantFlag = this.getJsonString(root, "merchantFlag");
        poiItem.merchantDispType = this.getJsonString(root, "merchantDispType");
        poiItem.additionalInfo = this.getJsonString(root, "additionalInfo");
        poiItem.desc = this.getJsonString(root, "desc");
        poiItem.mngName = this.getJsonString(root, "mngName");
        poiItem.mngId = this.getJsonString(root, "mngId");
        poiItem.freeYn = this.getJsonString(root, "freeYn");
        poiItem.reservYn = this.getJsonString(root, "reservYn");
        poiItem.useTime = this.getJsonString(root, "useTime");
        poiItem.payYn = this.getJsonString(root, "payYn");
        poiItem.fee = this.getJsonString(root, "fee");
        poiItem.updateDt = this.getJsonString(root, "updateDt");
        poiItem.totalCnt = this.getJsonString(root, "totalCnt");
        poiItem.evChargerList = new ArrayList();
        JSONArray evArray = this.getJsonArray(root, "evChargers");
        for (int i = 0; i < evArray.length(); ++i) {
            JSONObject evJson = this.getJsonObject(evArray, i);
            EvCharger evCharger = new EvCharger();
            evCharger.bid = this.getJsonString(evJson, "bid");
            evCharger.sid = this.getJsonString(evJson, "sid");
            evCharger.cid = this.getJsonString(evJson, "cid");
            evCharger.type = this.getJsonString(evJson, "type");
            evCharger.status = this.getJsonString(evJson, "status");
            poiItem.evChargerList.add(evCharger);
        }
        ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
        allpoi.add(poiItem);
        return allpoi;
    }

    private ArrayList<TMapAutoCompleteV2> parseAutoCompleteV2List(JSONObject jsonObject) {
        ArrayList<TMapAutoCompleteV2> itemList = new ArrayList<TMapAutoCompleteV2>();
        JSONObject root = this.getJsonObject(jsonObject, "response");
        JSONArray suggestionsJson = this.getJsonArray(root, "suggestions");
        for (int i = 0; i < suggestionsJson.length(); ++i) {
            JSONObject suJson = this.getJsonObject(suggestionsJson, i);
            TMapAutoCompleteV2 item = new TMapAutoCompleteV2();
            item.poiId = this.getJsonString(suJson, "poi_id");
            item.pKey = this.getJsonString(suJson, "pkey");
            item.keyword = this.getJsonString(suJson, "keyword");
            item.fullAddress = this.getJsonString(suJson, "full_address");
            item.fullAddressJibun = this.getJsonString(suJson, "full_address_jibun");
            item.cateName = this.getJsonString(suJson, "cate_name");
            JSONObject coordJson = this.getJsonObject(suJson, "coordinates");
            item.lat = this.getJsonString(coordJson, "lat");
            item.lon = this.getJsonString(coordJson, "lon");
            itemList.add(item);
        }
        return itemList;
    }

    public static interface findTrafficDataCallBack {
        public void onTrafficDataCallBack(ArrayList<TMapPolyLine> var1);
    }

    public static interface OnResponseCodeInfoCallback {
        public void responseCodeInfo(String var1, int var2, String var3);
    }

    public static interface AutoCompleteCallbackV2 {
        public void onAutoComplete(ArrayList<TMapAutoCompleteV2> var1);
    }

    public static interface AutoCompleteListenerCallback {
        public void onAutoComplete(ArrayList<String> var1);
    }

    public static interface FindTimeMachineCarPathListenerCallback {
        public void onFindTimeMachineCarPath(Document var1);
    }

    public static interface FindAroundKeywordPOIListenerCallback {
        public void onFindAroundKeywordPOI(ArrayList<TMapPOIItem> var1);
    }

    public static interface FindPathDataAllListenerCallback {
        public void onFindPathDataAll(Document var1);
    }

    public static interface FindPathDataListenerCallback {
        public void onFindPathData(TMapPolyLine var1);
    }

    private static interface BizCategoryListenerCallback {
        public void onGetBizCategory(ArrayList<BizCategory> var1);
    }

    public static interface FindAroundNamePOIListenerCallback {
        public void onFindAroundNamePOI(ArrayList<TMapPOIItem> var1);
    }

    public static interface FindTitlePOIListenerCallback {
        public void onFindTitlePOI(ArrayList<TMapPOIItem> var1);
    }

    public static interface FindAddressPOIListenerCallback {
        public void onFindAddressPOI(ArrayList<TMapPOIItem> var1);
    }

    public static interface FindAllPOIListenerCallback {
        public void onFindAllPOI(ArrayList<TMapPOIItem> var1);
    }

    public static interface reverseGeocodingListenerCallback {
        public void onReverseGeocoding(TMapAddressInfo var1);
    }

    public static interface ConvertGPSToAddressListenerCallback {
        public void onConvertToGPSToAddress(String var1);
    }

    public static interface findReverseLabelCallBack {
        public void onReverseLabelCallBack(TMapLabelInfo var1);
    }

    protected static interface CheckKeyResultListenerCallback {
        public void onCheckKeyResult(String var1);
    }

    public static enum TMapPathType {
        CAR_PATH,
        PEDESTRIAN_PATH;

    }
}

