/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.skt.Tmap.TMapLayer;
import com.skt.Tmap.TMapPolyLine;
import com.skt.Tmap.TMapView;
import java.io.InputStream;

public class TMapPathLayer
implements TMapLayer {
    public TMapPolyLine polyline = new TMapPolyLine();
    private TMapView view;
    private DisplayMetrics dm;
    private Bitmap btStart;
    private Bitmap btEnd;
    private Bitmap btPass;
    private boolean isRotate = true;
    private Context mContext = null;
    private Paint paintPath_STROKE = null;

    public TMapPathLayer(Context context) {
        this.mContext = context;
    }

    @Override
    public void initLayer(TMapView view) {
        this.view = view;
        this.dm = new DisplayMetrics();
        WindowManager wmgr = (WindowManager)view.getContext().getSystemService("window");
        wmgr.getDefaultDisplay().getMetrics(this.dm);
        float density = this.dm.density;
        this.paintPath_STROKE = new Paint();
        this.paintPath_STROKE.setStyle(Paint.Style.STROKE);
        this.btStart = this.loadBitmap("start", density);
        this.btEnd = this.loadBitmap("end", density);
        this.btPass = this.loadBitmap("pass", density);
    }

    private Bitmap loadBitmap(String imgName, float density) {
        Bitmap bitmap = null;
        AssetManager assetmanager = this.mContext.getResources().getAssets();
        try {
            InputStream is = assetmanager.open(imgName + ".png", 3);
            bitmap = BitmapFactory.decodeStream((InputStream)is);
            int width = (int)((float)bitmap.getWidth() * density);
            int height = (int)((float)bitmap.getHeight() * density);
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Canvas canvas, RectF TMapPointRect, boolean nightMode) {
        TMapPolyLine tMapPolyLine = this.polyline;
        synchronized (tMapPolyLine) {
            float pass_x;
            int passCnt;
            this.paintPath_STROKE.setColor(this.polyline.getLineColor());
            this.paintPath_STROKE.setAlpha(this.polyline.getLineAlpha());
            this.paintPath_STROKE.setStrokeWidth(this.polyline.getLineWidth());
            this.paintPath_STROKE.setPathEffect((PathEffect)this.polyline.getPathEffect());
            Path path = new Path();
            for (int k = 0; k < this.polyline.getLinePoint().size(); ++k) {
                float x = this.view.getMapXForPoint(this.polyline.getLinePoint().get(k).getLongitude(), this.polyline.getLinePoint().get(k).getLatitude());
                float y = this.view.getMapYForPoint(this.polyline.getLinePoint().get(k).getLongitude(), this.polyline.getLinePoint().get(k).getLatitude());
                if (k == 0) {
                    path.moveTo(x, y);
                    continue;
                }
                path.lineTo(x, y);
            }
            canvas.drawPath(path, this.paintPath_STROKE);
            if (this.polyline.getLinePoint().size() <= 0) {
                return;
            }
            if (this.isRotate) {
                if (this.btPass != null) {
                    passCnt = this.polyline.getPassPoint().size();
                    for (int i = 0; i < passCnt; ++i) {
                        pass_x = this.view.getRotatedMapXForPoint(this.polyline.getPassPoint().get(i).getLatitude(), this.polyline.getPassPoint().get(i).getLongitude());
                        float pass_y = this.view.getRotatedMapYForPoint(this.polyline.getPassPoint().get(i).getLatitude(), this.polyline.getPassPoint().get(i).getLongitude());
                        canvas.save();
                        canvas.rotate(-this.view.getRotateData(), (float)this.view.getCenterPointX(), (float)this.view.getCenterPointY());
                        canvas.translate(pass_x - (float)(this.btPass.getWidth() / 2), pass_y - (float)this.btPass.getHeight());
                        canvas.drawBitmap(this.btPass, 0.0f, 0.0f, null);
                        canvas.restore();
                    }
                }
                if (this.btStart != null) {
                    float start_x = this.view.getRotatedMapXForPoint(this.polyline.getLinePoint().get(0).getLatitude(), this.polyline.getLinePoint().get(0).getLongitude());
                    float start_y = this.view.getRotatedMapYForPoint(this.polyline.getLinePoint().get(0).getLatitude(), this.polyline.getLinePoint().get(0).getLongitude());
                    canvas.save();
                    canvas.rotate(-this.view.getRotateData(), (float)this.view.getCenterPointX(), (float)this.view.getCenterPointY());
                    canvas.translate(start_x - (float)(this.btStart.getWidth() / 2), start_y - (float)this.btStart.getHeight());
                    canvas.drawBitmap(this.btStart, 0.0f, 0.0f, null);
                    canvas.restore();
                }
                if (this.btEnd != null) {
                    float end_x = this.view.getRotatedMapXForPoint(this.polyline.getLinePoint().get(this.polyline.getLinePoint().size() - 1).getLatitude(), this.polyline.getLinePoint().get(this.polyline.getLinePoint().size() - 1).getLongitude());
                    float end_y = this.view.getRotatedMapYForPoint(this.polyline.getLinePoint().get(this.polyline.getLinePoint().size() - 1).getLatitude(), this.polyline.getLinePoint().get(this.polyline.getLinePoint().size() - 1).getLongitude());
                    canvas.save();
                    canvas.rotate(-this.view.getRotateData(), (float)this.view.getCenterPointX(), (float)this.view.getCenterPointY());
                    canvas.translate(end_x - (float)(this.btEnd.getWidth() / 2), end_y - (float)this.btEnd.getHeight());
                    canvas.drawBitmap(this.btEnd, 0.0f, 0.0f, null);
                    canvas.restore();
                }
            } else {
                if (this.btPass != null) {
                    passCnt = this.polyline.getPassPoint().size();
                    for (int i = 0; i < passCnt; ++i) {
                        pass_x = this.view.getRotatedMapXForPoint(this.polyline.getPassPoint().get(i).getLatitude(), this.polyline.getPassPoint().get(i).getLongitude());
                        float pass_y = this.view.getRotatedMapYForPoint(this.polyline.getPassPoint().get(i).getLatitude(), this.polyline.getPassPoint().get(i).getLongitude());
                        canvas.drawBitmap(this.btPass, pass_x - (float)(this.btPass.getWidth() / 2), pass_y - (float)this.btPass.getHeight(), null);
                    }
                }
                if (this.btStart != null) {
                    float start_x = this.view.getMapXForPoint(this.polyline.getLinePoint().get(0).getLongitude(), this.polyline.getLinePoint().get(0).getLatitude());
                    float start_y = this.view.getMapYForPoint(this.polyline.getLinePoint().get(0).getLongitude(), this.polyline.getLinePoint().get(0).getLatitude());
                    canvas.drawBitmap(this.btStart, start_x - (float)(this.btStart.getWidth() / 2), start_y - (float)this.btStart.getHeight(), null);
                }
                if (this.btEnd != null) {
                    float end_x = this.view.getMapXForPoint(this.polyline.getLinePoint().get(this.polyline.getLinePoint().size() - 1).getLongitude(), this.polyline.getLinePoint().get(this.polyline.getLinePoint().size() - 1).getLatitude());
                    float end_y = this.view.getMapYForPoint(this.polyline.getLinePoint().get(this.polyline.getLinePoint().size() - 1).getLongitude(), this.polyline.getLinePoint().get(this.polyline.getLinePoint().size() - 1).getLatitude());
                    canvas.drawBitmap(this.btEnd, end_x - (float)(this.btEnd.getWidth() / 2), end_y - (float)this.btEnd.getHeight(), null);
                }
            }
        }
    }

    public void setRotate(boolean rotate) {
        this.isRotate = rotate;
    }

    @Override
    public void destroyTMapLayer() {
    }

    @Override
    public boolean onTouchEvent(PointF point) {
        return false;
    }

    @Override
    public boolean onLongPressEvent(PointF point) {
        return false;
    }

    @Override
    public boolean drawInScreenPixels() {
        return false;
    }

    public void setIcon(Bitmap start, Bitmap end) {
        this.btStart = start;
        this.btEnd = end;
    }

    public void setIcon(Bitmap start, Bitmap end, Bitmap pass) {
        this.btStart = start;
        this.btEnd = end;
        this.btPass = pass;
    }
}

