/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.skt.Tmap.TMapLayer;
import com.skt.Tmap.TMapPolyLine;
import com.skt.Tmap.TMapView;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class TMapPolyLineLayer
implements TMapLayer {
    public Map<String, TMapPolyLine> mPolyLines = new LinkedHashMap<String, TMapPolyLine>();
    private TMapView view = null;
    private DisplayMetrics dm = null;
    private Paint paintPolyLine_STROKE = null;
    private Paint paintPath_OUTLINE = null;

    @Override
    public void initLayer(TMapView view) {
        this.view = view;
        this.dm = new DisplayMetrics();
        WindowManager wmgr = (WindowManager)view.getContext().getSystemService("window");
        wmgr.getDefaultDisplay().getMetrics(this.dm);
        this.paintPolyLine_STROKE = new Paint();
        this.paintPolyLine_STROKE.setStyle(Paint.Style.STROKE);
        this.paintPath_OUTLINE = new Paint();
        this.paintPath_OUTLINE.setStyle(Paint.Style.STROKE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Canvas canvas, RectF latlonRect, boolean nightMode) {
        Map<String, TMapPolyLine> map = this.mPolyLines;
        synchronized (map) {
            ArrayList<String> list = new ArrayList<String>(this.mPolyLines.keySet());
            for (int i = 0; i < list.size(); ++i) {
                this.paintPolyLine_STROKE.setColor(this.mPolyLines.get(list.get(i)).getLineColor());
                this.paintPolyLine_STROKE.setAlpha(this.mPolyLines.get(list.get(i)).getLineAlpha());
                this.paintPolyLine_STROKE.setStrokeWidth(this.mPolyLines.get(list.get(i)).getLineWidth());
                this.paintPolyLine_STROKE.setPathEffect((PathEffect)this.mPolyLines.get(list.get(i)).getPathEffect());
                this.paintPath_OUTLINE.setColor(this.mPolyLines.get(list.get(i)).getOutLineColor());
                this.paintPath_OUTLINE.setAlpha(this.mPolyLines.get(list.get(i)).getOutLineAlpha());
                this.paintPath_OUTLINE.setStrokeWidth(this.mPolyLines.get(list.get(i)).getOutLineWidth());
                this.paintPath_OUTLINE.setPathEffect((PathEffect)this.mPolyLines.get(list.get(i)).getOutLinePathEffect());
                Path path = new Path();
                int xPos = 0;
                int yPos = 0;
                for (int k = 0; k < this.mPolyLines.get(list.get(i)).getLinePoint().size(); ++k) {
                    xPos = this.view.getMapXForPoint(this.mPolyLines.get(list.get(i)).getLinePoint().get(k).getLongitude(), this.mPolyLines.get(list.get(i)).getLinePoint().get(k).getLatitude());
                    yPos = this.view.getMapYForPoint(this.mPolyLines.get(list.get(i)).getLinePoint().get(k).getLongitude(), this.mPolyLines.get(list.get(i)).getLinePoint().get(k).getLatitude());
                    if (k == 0) {
                        path.moveTo((float)xPos, (float)yPos);
                        continue;
                    }
                    path.lineTo((float)xPos, (float)yPos);
                }
                canvas.drawPath(path, this.paintPath_OUTLINE);
                canvas.drawPath(path, this.paintPolyLine_STROKE);
                if (path == null) continue;
                path = null;
            }
        }
    }

    @Override
    public void destroyTMapLayer() {
    }

    @Override
    public boolean onTouchEvent(PointF point) {
        return false;
    }

    @Override
    public boolean onLongPressEvent(PointF point) {
        return false;
    }

    @Override
    public boolean drawInScreenPixels() {
        return false;
    }
}

