/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import com.skt.Tmap.ITileOrigin;
import com.skt.Tmap.MapTileDownloader;
import com.skt.Tmap.MapUtils;
import com.skt.Tmap.ResourceManager;
import com.skt.Tmap.TMapPoint;
import com.skt.Tmap.TMapView;
import java.util.ArrayList;
import java.util.Date;

public class TMapRenderer {
    private Context mContext = null;
    private TMapView mTMapView = null;
    private MapTileDownloader mMapTileDownloader = null;
    private ResourceManager mResourceManager = null;
    public MapUtils mapUtils = null;
    private ITileOrigin map = null;
    private ArrayList<String> mlist = new ArrayList();
    private boolean drawOnlyTileSrc = true;
    protected int emptyTileDivisor = 8;
    public static final int TILETYPE_NORMALTILE = 0;
    public static final int TILETYPE_EXTENSIONTILE = 1;
    public static final int TILETYPE_HDTILE = 2;
    public static final int TILETYPE_ENGLISHTILE = 3;
    public static final int TILETYPE_CHINATILE = 4;
    public static final int TILETYPE_HIGHCONTRASTTILE = 5;
    public int TileType = 2;
    protected int zoom = 15;
    protected float rotate = 0.0f;
    private double latitude = 37.566474;
    private double longitude = 126.985022;
    private MapTileBoardInfo mCurrentMapTileBoard = null;
    private MapTileBoardInfo mNextMapTileBoard = null;
    private MapTileBoardInfo upTileBoard = null;
    private MapTileBoardInfo downTileBoard = null;
    private ArrayList<MapTileBoardInfo> farTileBoardArray = new ArrayList();
    private ArrayList<MapTileBoardInfo> thrashTileBoardArray = new ArrayList();
    private MakeTileBoardThread makeTileBoardThread = null;
    private MakeTileCacheThread makeTileCacheThread = null;
    private boolean isBackgroundImage = false;
    private Paint paintBGFill = null;
    private Paint paintBlackFill = null;
    private Paint paintCenter = null;
    private Paint paintBitmap = null;
    private int screenWidth = 0;
    private int screenHeight = 0;
    private Bitmap EmptyBitmap = null;
    private static int m_nBufferStep = 1;
    public static boolean m_bCanvasSave = false;

    public TMapRenderer(Context context, TMapView tMapView, MapTileDownloader mapTileDownloader, ResourceManager resourceManager) {
        this.mContext = context;
        this.mTMapView = tMapView;
        this.mMapTileDownloader = mapTileDownloader;
        this.mResourceManager = resourceManager;
        this.isBackgroundImage = true;
        this.paintBGFill = new Paint();
        this.paintBGFill.setStyle(Paint.Style.FILL);
        this.paintBGFill.setAntiAlias(true);
        this.paintBGFill.setColor(-1);
        this.paintBlackFill = new Paint();
        this.paintBlackFill.setColor(-16777216);
        this.paintBlackFill.setStyle(Paint.Style.FILL);
        this.paintBlackFill.setAntiAlias(true);
        this.paintCenter = new Paint();
        this.paintCenter.setStyle(Paint.Style.STROKE);
        this.paintCenter.setColor(Color.rgb((int)60, (int)60, (int)60));
        this.paintCenter.setStrokeWidth(2.0f);
        this.paintCenter.setAntiAlias(true);
        this.paintBitmap = new Paint();
        this.paintBitmap.setFilterBitmap(true);
        this.setCallback();
        this.EmptyBitmap = tMapView.loadBitmap("empty.png", true);
    }

    public void setMap(ITileOrigin map, MapUtils mapUtils) {
        this.map = map;
        this.mapUtils = mapUtils;
    }

    public void setMapPosition(double longitude, double latitude, int zoom) {
        if (this.latitude == latitude && this.longitude == longitude && this.zoom == zoom) {
            return;
        }
        this.latitude = latitude;
        this.longitude = longitude;
        this.zoom = zoom;
        if (!this.drawOnlyTileSrc) {
            if (this.mCurrentMapTileBoard != null && !this.mCurrentMapTileBoard.isOverDistance(this.latitude, this.longitude)) {
                return;
            }
            if (this.makeTileBoardThread != null) {
                this.makeTileBoardThread.stop();
                this.makeTileBoardThread = null;
            }
            MapTileBoardInfo mapTileBoardInfo = new MapTileBoardInfo();
            mapTileBoardInfo.invalidate = true;
            this.makeTileBoardThread = new MakeTileBoardThread(this, mapTileBoardInfo, this.latitude, this.longitude, this.zoom);
            this.makeTileBoardThread.start();
        }
    }

    public void setScreenSize(int width, int height) {
        this.screenWidth = width;
        this.screenHeight = height;
    }

    public void setTMapBackgroundColor(int backgroundColor) {
        this.isBackgroundImage = false;
        this.paintBGFill.setColor(backgroundColor);
    }

    public boolean contains(RectF bounds1, RectF bounds2) {
        boolean result = false;
        if (bounds1.left <= bounds2.left && bounds1.right >= bounds2.right && bounds1.bottom <= bounds2.bottom && bounds1.top >= bounds2.top) {
            result = true;
        }
        return result;
    }

    private void zoomChanged() {
        if (this.mCurrentMapTileBoard.zoom < (float)this.zoom) {
            if (this.downTileBoard != null) {
                if (this.upTileBoard != null) {
                    this.thrashTileBoardArray.add(this.upTileBoard);
                }
                this.upTileBoard = this.mCurrentMapTileBoard;
                this.mCurrentMapTileBoard = null;
                this.mCurrentMapTileBoard = this.downTileBoard;
                this.downTileBoard = this.popFromThrash(this.latitude, this.longitude, (int)this.mCurrentMapTileBoard.zoom + 1);
            } else {
                MapTileBoardInfo mapTileBoardInfo = new MapTileBoardInfo();
                mapTileBoardInfo.target = 1;
                this.makeTileBoardThread = new MakeTileBoardThread(this, mapTileBoardInfo, this.latitude, this.longitude, this.zoom + 1);
                this.makeTileBoardThread.start();
            }
        } else if (this.upTileBoard != null) {
            if (this.downTileBoard != null) {
                this.thrashTileBoardArray.add(this.downTileBoard);
            }
            this.downTileBoard = this.mCurrentMapTileBoard;
            this.mCurrentMapTileBoard = null;
            this.mCurrentMapTileBoard = this.upTileBoard;
            this.upTileBoard = this.popFromThrash(this.latitude, this.longitude, (int)this.mCurrentMapTileBoard.zoom - 1);
        } else {
            MapTileBoardInfo mapTileBoardInfo = new MapTileBoardInfo();
            mapTileBoardInfo.target = -1;
            this.makeTileBoardThread = new MakeTileBoardThread(this, mapTileBoardInfo, this.latitude, this.longitude, this.zoom - 1);
            this.makeTileBoardThread.start();
        }
    }

    private MapTileBoardInfo popFromThrash(double latitude, double longitude, int zoom) {
        MapTileBoardInfo result = null;
        return result;
    }

    private MapTileBoardInfo findAllBoundsCoveredBoard(RectF bounds) {
        MapTileBoardInfo result = null;
        if (this.upTileBoard != null && this.contains(this.upTileBoard.mapPointRect, bounds)) {
            result = this.upTileBoard;
        } else {
            for (int i = 0; i < this.farTileBoardArray.size(); ++i) {
                if (!this.contains(this.farTileBoardArray.get((int)i).mapPointRect, bounds)) continue;
                result = this.farTileBoardArray.get(i);
                break;
            }
        }
        return result;
    }

    protected void drawEmptyTile(Canvas cvs, float x, float y, float ftileSize, boolean nightMode) {
        this.emptyTileDivisor = this.TileType == 1 ? 4 : 8;
        if (!this.isBackgroundImage) {
            cvs.drawRect(x, y, x + ftileSize, y + ftileSize, this.paintBGFill);
            return;
        }
        float tileDiv = ftileSize / (float)this.emptyTileDivisor;
        for (int k1 = 0; k1 < this.emptyTileDivisor; ++k1) {
            for (int k2 = 0; k2 < this.emptyTileDivisor; ++k2) {
                float xk = x + tileDiv * (float)k1;
                float yk = y + tileDiv * (float)k2;
                cvs.drawRect(xk, yk, xk + tileDiv, yk + tileDiv, this.paintBGFill);
                cvs.drawBitmap(this.EmptyBitmap, xk, yk, null);
            }
        }
    }

    protected void makeMapTileCache(double longitude, double latitude, int zoom, MakeTileCacheThread makeTileCacheThread, boolean bNow) {
        int tileSize = 512;
        if (this.mMapTileDownloader != null) {
            this.mMapTileDownloader.refuseAllPreviousDataRequests();
        }
        int nzoom = zoom;
        float tileX = (float)this.mapUtils.getTileNumberX(nzoom, longitude, latitude);
        float tileY = (float)this.mapUtils.getTileNumberY(nzoom, longitude, latitude);
        int needHTileCount = Math.round((float)this.screenWidth / (float)tileSize);
        int needVTileCount = Math.round((float)this.screenHeight / (float)tileSize);
        int tileHBuffer = needHTileCount + (int)((double)needHTileCount * 0.5);
        int tileVBuffer = needVTileCount + (int)((double)needVTileCount * 0.5);
        if (!bNow) {
            tileHBuffer = needHTileCount;
            tileVBuffer = needVTileCount;
        }
        if (m_nBufferStep < 3) {
            tileHBuffer = 0;
            tileVBuffer = 0;
        }
        RectF tileIndexRect = new RectF();
        Rect boundsRect = new Rect();
        boundsRect.set(0, 0, this.screenWidth, this.screenHeight);
        Bitmap bmp = null;
        try {
            if (this.map == null || this.map.getVIndexOrder() > 0) {
                int Max_y = (int)(Math.pow(2.0, nzoom) - 1.0);
                tileIndexRect.set((float)((int)tileX - tileHBuffer), (float)(Max_y - ((int)tileY - tileVBuffer)), (float)((int)tileX + tileHBuffer), (float)(Max_y - ((int)tileY + tileVBuffer)));
                int left = (int)tileIndexRect.left;
                int top = (int)tileIndexRect.top;
                int cols = (int)tileIndexRect.right - (int)tileIndexRect.left + 1;
                int rows = (int)tileIndexRect.top - (int)tileIndexRect.bottom + 1;
                if (this.map != null) {
                    int maxLevel = this.map.getMaximumZoom();
                    for (int i = 0; i < cols; ++i) {
                        for (int j = 0; j < rows; ++j) {
                            if (makeTileCacheThread.stopped) {
                                return;
                            }
                            int tileIndexX = left + i;
                            int tileIndexY = top - j;
                            String ordImgTile = this.mResourceManager.calculateTileId(this.map, tileIndexX, tileIndexY, nzoom);
                            bmp = this.mResourceManager.getTileImageFromCache(ordImgTile);
                            if (bmp != null || (bmp = this.mResourceManager.getTileImageForMapAsync(null, this.map, tileIndexX, tileIndexY, nzoom, true)) != null || this.mlist.contains(ordImgTile)) continue;
                            this.mlist.add(ordImgTile);
                        }
                    }
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MapTileBoardInfo makeMapTileBoard(double longitude, double latitude, int zoom, MapTileBoardInfo mapTileBoardInfo, boolean bNow) {
        Canvas canvas;
        int tileSize = 512;
        if (this.mMapTileDownloader != null) {
            this.mMapTileDownloader.refuseAllPreviousDataRequests();
        }
        int nzoom = zoom;
        float tileX = (float)this.mapUtils.getTileNumberX(nzoom, longitude, latitude);
        float tileY = (float)this.mapUtils.getTileNumberY(nzoom, longitude, latitude);
        MapTileBoardInfo workBoard = mapTileBoardInfo;
        workBoard.isBusy = true;
        workBoard.zoom = zoom;
        int needHTileCount = Math.round((float)this.screenWidth / (float)tileSize);
        int needVTileCount = Math.round((float)this.screenHeight / (float)tileSize);
        int tileHBuffer = needHTileCount + (int)((double)needHTileCount * 0.5);
        int tileVBuffer = needVTileCount + (int)((double)needVTileCount * 0.5);
        if (!bNow) {
            tileHBuffer = needHTileCount;
            tileVBuffer = needVTileCount;
        }
        if (m_nBufferStep < 3) {
            tileHBuffer = 0;
            tileVBuffer = 0;
        }
        if (workBoard.bitmap == null) {
            workBoard.width = tileSize * (tileHBuffer * 2 + 1);
            workBoard.height = tileSize * (tileVBuffer * 2 + 1);
            workBoard.bitmap = Bitmap.createBitmap((int)workBoard.width, (int)workBoard.height, (Bitmap.Config)Bitmap.Config.RGB_565);
        }
        if ((canvas = new Canvas(workBoard.bitmap)) != null) {
            canvas.drawColor(-1);
            boolean nightMode = false;
            Rect boundsRect = new Rect();
            RectF bitmapToDraw = new RectF();
            Rect bitmapToZoom = new Rect();
            boundsRect.set(0, 0, this.screenWidth, this.screenHeight);
            Bitmap bmp = null;
            try {
                if (this.map == null || this.map.getVIndexOrder() > 0) {
                    int Max_y = (int)(Math.pow(2.0, nzoom) - 1.0);
                    int leftIdx = (int)tileX - tileHBuffer;
                    int topIdx = (int)tileY - tileVBuffer;
                    int rightIdx = (int)tileX + tileHBuffer;
                    int bottomIdx = (int)tileY + tileVBuffer;
                    workBoard.tileIndexRect.set((float)((int)tileX - tileHBuffer), (float)(Max_y - ((int)tileY - tileVBuffer)), (float)((int)tileX + tileHBuffer), (float)(Max_y - ((int)tileY + tileVBuffer)));
                    workBoard.mapPointRect.top = (float)this.mapUtils.getLatitudeTile(nzoom, leftIdx, topIdx);
                    workBoard.mapPointRect.left = (float)this.mapUtils.getLongitudeFromTile(nzoom, leftIdx, topIdx);
                    workBoard.mapPointRect.bottom = (float)this.mapUtils.getLatitudeTile(nzoom, rightIdx + 1, bottomIdx + 1);
                    workBoard.mapPointRect.right = (float)this.mapUtils.getLongitudeFromTile(nzoom, rightIdx + 1, bottomIdx + 1);
                    int left = (int)workBoard.tileIndexRect.left;
                    int top = (int)workBoard.tileIndexRect.top;
                    int cols = (int)workBoard.tileIndexRect.right - (int)workBoard.tileIndexRect.left + 1;
                    int rows = (int)workBoard.tileIndexRect.top - (int)workBoard.tileIndexRect.bottom + 1;
                    if (this.map != null) {
                        int maxLevel = this.map.getMaximumZoom();
                        for (int i = 0; i < cols; ++i) {
                            for (int j = 0; j < rows; ++j) {
                                int tileIndexX = left + i;
                                int tileIndexY = top - j;
                                float bmpDesX = i * tileSize;
                                float bmpDesY = j * tileSize;
                                String ordImgTile = this.mResourceManager.calculateTileId(this.map, tileIndexX, tileIndexY, nzoom);
                                boolean originalBeLoaded = nzoom <= maxLevel;
                                bmp = this.mResourceManager.getTileImageFromCache(ordImgTile);
                                if (bmp == null && (bmp = this.mResourceManager.getTileImageForMapSync(null, this.map, tileIndexX, tileIndexY, nzoom, true)) == null && !this.mlist.contains(ordImgTile)) {
                                    this.mlist.add(ordImgTile);
                                }
                                if (bmp == null) continue;
                                bitmapToZoom.set(0, 0, tileSize, tileSize);
                                bitmapToDraw.set(bmpDesX, bmpDesY, bmpDesX + (float)tileSize, bmpDesY + (float)tileSize);
                                canvas.drawBitmap(bmp, bitmapToZoom, bitmapToDraw, this.paintBitmap);
                            }
                        }
                    }
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception exception) {
            }
            finally {
                workBoard.isBusy = false;
            }
        }
        return workBoard;
    }

    public RectF draw(Canvas canvas, DrawParams params) {
        canvas.drawColor(Color.rgb((int)236, (int)235, (int)233));
        float tileX = (float)this.mapUtils.getTileNumberX(params.zoom, this.longitude, this.latitude);
        float tileY = (float)this.mapUtils.getTileNumberY(params.zoom, this.longitude, this.latitude);
        float screenCenterX = params.centerPointX;
        float screenCenterY = params.centerPointY;
        Rect boundsRect = new Rect();
        boundsRect.set(0, 0, this.screenWidth, this.screenHeight);
        RectF tilesRect = new RectF();
        this.mTMapView.calculateTileRectangle(boundsRect, screenCenterX, screenCenterY, tileX, tileY, tilesRect);
        RectF TMapPointRect = new RectF();
        TMapPointRect.top = (float)this.mapUtils.getLatitudeTile(params.zoom, tilesRect.left, tilesRect.top);
        TMapPointRect.left = (float)this.mapUtils.getLongitudeFromTile(params.zoom, tilesRect.left, tilesRect.top);
        TMapPointRect.bottom = (float)this.mapUtils.getLatitudeTile(params.zoom, tilesRect.right, tilesRect.bottom);
        TMapPointRect.right = (float)this.mapUtils.getLongitudeFromTile(params.zoom, tilesRect.right, tilesRect.bottom);
        if (this.drawOnlyTileSrc || this.mCurrentMapTileBoard == null) {
            this.drawFromTileSrc(canvas, params);
            if (this.makeTileCacheThread != null) {
                this.makeTileCacheThread.stop();
            }
            this.makeTileCacheThread = new MakeTileCacheThread(this.latitude, this.longitude, this.zoom);
            this.makeTileCacheThread.start();
        } else {
            MapTileBoardInfo allCoveredBoard;
            MapTileBoardInfo mapTileBoardInfo = this.mCurrentMapTileBoard;
            if (this.mCurrentMapTileBoard.zoom < (float)params.zoom) {
                if (this.downTileBoard != null) {
                    mapTileBoardInfo = this.downTileBoard;
                }
            } else if (this.mCurrentMapTileBoard.zoom > (float)params.zoom && this.upTileBoard != null) {
                mapTileBoardInfo = this.upTileBoard;
            }
            if (!this.contains(mapTileBoardInfo.mapPointRect, TMapPointRect) && (allCoveredBoard = this.findAllBoundsCoveredBoard(TMapPointRect)) != null) {
                this.drawFromBuffer(canvas, params, allCoveredBoard);
            }
            this.drawFromBuffer(canvas, params, mapTileBoardInfo);
        }
        this.zoom = params.zoom;
        return TMapPointRect;
    }

    public void drawFromBuffer(Canvas canvas, DrawParams params, MapTileBoardInfo mapTileBoardInfo) {
        if (mapTileBoardInfo != null && mapTileBoardInfo.bitmap != null && canvas != null) {
            int nzoom = 0;
            float tileX = 0.0f;
            float tileY = 0.0f;
            double longitude = params.longitude;
            double latitude = params.latitude;
            nzoom = this.zoom;
            tileX = (float)this.mapUtils.getTileNumberX(nzoom, longitude, latitude);
            tileY = (float)this.mapUtils.getTileNumberY(nzoom, longitude, latitude);
            float screenCenterX = params.centerPointX;
            float screenCenterY = params.centerPointY;
            boolean nightMode = false;
            Rect boundsRect = new Rect();
            boundsRect.set(0, 0, this.screenWidth, this.screenHeight);
            canvas.save();
            m_bCanvasSave = true;
            canvas.rotate(params.rotate, screenCenterX, screenCenterY);
            RectF tilesRect = new RectF();
            this.mTMapView.calculateTileRectangle(boundsRect, screenCenterX, screenCenterY, tileX, tileY, tilesRect);
            RectF TMapPointRect = new RectF();
            TMapPointRect.top = (float)this.mapUtils.getLatitudeTile(nzoom, tilesRect.left, tilesRect.top);
            TMapPointRect.left = (float)this.mapUtils.getLongitudeFromTile(nzoom, tilesRect.left, tilesRect.top);
            TMapPointRect.bottom = (float)this.mapUtils.getLatitudeTile(nzoom, tilesRect.right, tilesRect.bottom);
            TMapPointRect.right = (float)this.mapUtils.getLongitudeFromTile(nzoom, tilesRect.right, tilesRect.bottom);
            Rect srcRect = new Rect(0, 0, this.screenWidth, this.screenHeight);
            Rect dstRect = new Rect(0, 0, this.screenWidth, this.screenHeight);
            srcRect.left = (int)((float)mapTileBoardInfo.width * (TMapPointRect.left - mapTileBoardInfo.mapPointRect.left) / mapTileBoardInfo.mapPointRect.width());
            srcRect.top = (int)((float)mapTileBoardInfo.height * (mapTileBoardInfo.mapPointRect.top - TMapPointRect.top) / -mapTileBoardInfo.mapPointRect.height());
            srcRect.right = (int)((float)mapTileBoardInfo.width * (TMapPointRect.right - mapTileBoardInfo.mapPointRect.left) / mapTileBoardInfo.mapPointRect.width());
            srcRect.bottom = (int)((float)mapTileBoardInfo.height * (mapTileBoardInfo.mapPointRect.top - TMapPointRect.bottom) / -mapTileBoardInfo.mapPointRect.height());
            if (srcRect.left < 0) {
                dstRect.left = (int)(Math.abs((float)srcRect.left) * ((float)dstRect.width() / (float)srcRect.width()));
                srcRect.left = 0;
            }
            if (srcRect.top < 0) {
                dstRect.top = (int)(Math.abs((float)srcRect.top) * ((float)dstRect.height() / (float)srcRect.height()));
                srcRect.top = 0;
            }
            if (srcRect.right > mapTileBoardInfo.width) {
                dstRect.right = this.screenWidth - (int)((float)(srcRect.right - mapTileBoardInfo.width) * ((float)dstRect.width() / (float)srcRect.width()));
                srcRect.right = mapTileBoardInfo.width;
            }
            if (srcRect.bottom > mapTileBoardInfo.height) {
                dstRect.bottom = this.screenHeight - (int)((float)(srcRect.bottom - mapTileBoardInfo.height) * ((float)dstRect.height() / (float)srcRect.height()));
                srcRect.bottom = mapTileBoardInfo.height;
            }
            canvas.drawBitmap(mapTileBoardInfo.bitmap, srcRect, dstRect, this.paintBitmap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawFromTileSrc(Canvas canvas, DrawParams params) {
        if (!MapUtils.isVerifyApiKey) {
            return;
        }
        if (this.mMapTileDownloader != null) {
            this.mMapTileDownloader.refuseAllPreviousDataRequests();
        }
        float ftileSize = params.tileSize;
        int tileSize = params.srcTileSize;
        tileSize = this.TileType == 1 ? 256 : 512;
        int nzoom = 0;
        float tileX = 0.0f;
        float tileY = 0.0f;
        double longitude = params.longitude;
        double latitude = params.latitude;
        nzoom = params.zoom;
        tileX = (float)this.mapUtils.getTileNumberX(nzoom, longitude, latitude);
        tileY = (float)this.mapUtils.getTileNumberY(nzoom, longitude, latitude);
        float screenCenterX = params.centerPointX;
        float screenCenterY = params.centerPointY;
        if (canvas != null) {
            canvas.save();
            m_bCanvasSave = true;
            boolean nightMode = false;
            Rect boundsRect = new Rect();
            boundsRect.set(0, 0, this.screenWidth, this.screenHeight);
            canvas.rotate(params.rotate, screenCenterX, screenCenterY);
            Bitmap bmp = null;
            try {
                RectF tilesRect = new RectF();
                this.mTMapView.calculateTileRectangle(boundsRect, screenCenterX, screenCenterY, tileX, tileY, tilesRect);
                if (this.map == null || this.map.getVIndexOrder() > 0) {
                    int left = (int)Math.floor(tilesRect.left);
                    int top = (int)Math.floor(tilesRect.top);
                    int cols = (int)Math.ceil(tilesRect.right - (float)left);
                    int rows = (int)Math.ceil(tilesRect.bottom - (float)top);
                    RectF TMapPointRect = new RectF();
                    TMapPointRect.top = (float)this.mapUtils.getLatitudeTile(nzoom, tilesRect.left, tilesRect.top);
                    TMapPointRect.left = (float)this.mapUtils.getLongitudeFromTile(nzoom, tilesRect.left, tilesRect.top);
                    TMapPointRect.bottom = (float)this.mapUtils.getLatitudeTile(nzoom, tilesRect.right, tilesRect.bottom);
                    TMapPointRect.right = (float)this.mapUtils.getLongitudeFromTile(nzoom, tilesRect.right, tilesRect.bottom);
                    Rect bitmapToZoom = new Rect();
                    RectF bitmapToDraw = new RectF();
                    if (this.map != null) {
                        int maxLevel = this.map.getMaximumZoom();
                        int WTile = this.screenWidth / tileSize;
                        int HTile = this.screenHeight / tileSize;
                        float widthTile = cols / 2 - WTile / 2;
                        float heightTile = rows / 2 - HTile / 2;
                        int showWTile = (int)Math.ceil(widthTile);
                        int showHTile = (int)Math.ceil(heightTile);
                        for (int i = 0; i < cols; ++i) {
                            if (params.zoomType == 0 && (i < showWTile - 1 || i > cols - showWTile + 1)) continue;
                            for (int j = rows - 1; j > -1; --j) {
                                if (params.zoomType == 0 && (j < showHTile - 1 || j > rows - showHTile + 1)) continue;
                                int leftPlusI = left + i;
                                int topPlusJ = top + j;
                                float x1 = ((float)leftPlusI - tileX) * ftileSize + screenCenterX;
                                float y1 = ((float)topPlusJ - tileY) * ftileSize + screenCenterY;
                                int Max_y = (int)(Math.pow(2.0, nzoom) - 1.0);
                                topPlusJ = Max_y - topPlusJ;
                                String ordImgTile = this.mResourceManager.calculateTileId(this.map, leftPlusI, topPlusJ, nzoom);
                                boolean originalBeLoaded = nzoom <= maxLevel;
                                bmp = this.mResourceManager.getTileImageFromCache(ordImgTile);
                                if (bmp == null) {
                                    // empty if block
                                }
                                if (bmp == null) {
                                    this.drawEmptyTile(canvas, x1, y1, ftileSize, nightMode);
                                    if (!params.isZooming) {
                                        if (params.rotate == 0.0f) {
                                            if (this.mResourceManager.MaxTileNum < cols * rows) {
                                                this.mResourceManager.MaxTileNum = cols * rows;
                                            }
                                            this.mResourceManager.AddTileNum = this.TileType == 1 ? this.mResourceManager.MaxTileNum / 2 : this.mResourceManager.MaxTileNum;
                                        } else {
                                            if (this.mResourceManager.MaxTileNum == 2) {
                                                this.mResourceManager.MaxTileNum = cols * rows;
                                            }
                                            this.mResourceManager.AddTileNum = this.mResourceManager.MaxTileNum;
                                        }
                                        if ((float)nzoom == (float)params.zoom) {
                                            bmp = this.mResourceManager.getTileImageForMapAsync(null, this.map, leftPlusI, topPlusJ, nzoom, true);
                                            String strTile = this.mResourceManager.calculateTileId(this.map, leftPlusI, topPlusJ, nzoom);
                                            if (bmp == null && !this.mlist.contains(strTile)) {
                                                this.mlist.add(strTile);
                                            }
                                        }
                                    }
                                    if (bmp == null) {
                                        int div = 2;
                                        String imgTile2 = "";
                                        imgTile2 = params.initialMultiTouchZoom <= (float)this.zoom ? this.mResourceManager.calculateTileId(this.map, leftPlusI / 2, topPlusJ / 2, nzoom - 1) : this.mResourceManager.calculateTileId(this.map, leftPlusI * 2 + 1, topPlusJ * 2 + 1, nzoom + 1);
                                        if (originalBeLoaded && imgTile2 != null) {
                                            bmp = this.mResourceManager.getTileImageFromCache(imgTile2);
                                        }
                                        if (bmp == null) continue;
                                        if (params.initialMultiTouchZoom <= (float)this.zoom) {
                                            int xZoom = (left + i) % div * tileSize / div;
                                            int yZoom = (top + j) % div * tileSize / div;
                                            bitmapToZoom.set(xZoom, yZoom, xZoom + tileSize / div, yZoom + tileSize / div);
                                            bitmapToDraw.set(x1, y1, x1 + ftileSize, y1 + ftileSize);
                                            canvas.drawRect(bitmapToDraw, this.paintBGFill);
                                            canvas.drawBitmap(bmp, bitmapToZoom, bitmapToDraw, this.paintBitmap);
                                            if (!params.slide) continue;
                                            Tile tile = new Tile(bmp, x1, y1);
                                            continue;
                                        }
                                        if (params.zoomType != -1) continue;
                                        this.drawEmptyTile(canvas, x1, y1, ftileSize, nightMode);
                                        continue;
                                    }
                                    bitmapToZoom.set(0, 0, tileSize, tileSize);
                                    bitmapToDraw.set(x1, y1, x1 + ftileSize, y1 + ftileSize);
                                    canvas.drawRect(bitmapToDraw, this.paintBGFill);
                                    canvas.drawBitmap(bmp, bitmapToZoom, bitmapToDraw, this.paintBitmap);
                                    if (!params.slide) continue;
                                    Tile tile = new Tile(bmp, x1, y1);
                                    continue;
                                }
                                bitmapToZoom.set(0, 0, tileSize, tileSize);
                                bitmapToDraw.set(x1, y1, x1 + ftileSize, y1 + ftileSize);
                                canvas.drawBitmap(bmp, bitmapToZoom, bitmapToDraw, this.paintBitmap);
                                if (!params.slide) continue;
                                Tile tile = new Tile(bmp, x1, y1);
                            }
                        }
                    } else {
                        for (int i = 0; i < cols; ++i) {
                            for (int j = 0; j < rows; ++j) {
                                float x1 = ((float)(i + left) - tileX) * ftileSize + screenCenterX;
                                float y1 = ((float)(j + top) - tileY) * ftileSize + screenCenterY;
                                this.drawEmptyTile(canvas, x1, y1, ftileSize, nightMode);
                            }
                        }
                    }
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception exception) {
            }
        }
    }

    public void setCallback() {
        this.mMapTileDownloader.addDownloaderMapCallback(new MapTileDownloader.IMapDownloaderCallback(){

            @Override
            public void tileDownloaded(MapTileDownloader.DownloadRequest request) {
                TMapRenderer.this.tileDownloaded_Reload(request);
            }
        });
    }

    public void tileDownloaded_Reload(MapTileDownloader.DownloadRequest request) {
        if (request == null) {
            return;
        }
        String ordImgTile = request.zoom + "_" + request.xTile + "_" + request.yTile + ".png";
        if (request.memoryErr) {
            if (this.mResourceManager != null) {
                this.mResourceManager.removeTileImageFromCache();
            }
            return;
        }
        if (request.error) {
            if (request.retry < 5) {
                ++request.retry;
                this.mResourceManager.downloader.downloadRequest(request);
            }
            return;
        }
        if (request.retry > 0) {
            // empty if block
        }
        if (this.rotate != 0.0f) {
            if (request.fileToSave != null && request.type == 0) {
                this.mResourceManager.setTileImageFromCache(ordImgTile, request.fileToSave);
            }
            if (request.zoom == this.zoom) {
                this.invalidate();
            }
            return;
        }
        if (request.fileToSave != null) {
            if (request.type == 0) {
                this.mResourceManager.setTileImageFromCache(ordImgTile, request.fileToSave);
            }
            if (this.mlist.size() > 0 && this.mlist.contains(ordImgTile)) {
                this.mlist.remove(ordImgTile);
            }
            if (request.type == 0) {
                this.mResourceManager.insertImage(ordImgTile, request.fileToSave);
            }
            if (request.zoom == this.zoom) {
                this.invalidate();
            }
            return;
        }
        if (request.retry < 5) {
            ++request.retry;
            this.mResourceManager.downloader.downloadRequest(request);
        }
    }

    private void invalidate() {
        this.mTMapView.postInvalidate();
    }

    public void setBufferStep(int nBufferStep) {
        m_nBufferStep = nBufferStep;
    }

    public int getBufferStep() {
        return m_nBufferStep;
    }

    public class MakeTileBoardThread
    implements Runnable {
        private TMapRenderer tmapRenderer = null;
        private MapTileBoardInfo mapTileBoardInfo = null;
        private volatile Thread currentThread = null;
        private volatile boolean stopped;
        private Date lastCheckTime = new Date();
        private double latitude = 0.0;
        private double longitude = 0.0;
        private int zoom = 0;

        public MakeTileBoardThread(TMapRenderer tmapRenderer, MapTileBoardInfo mapTileBoardInfo, double latitude, double longitude, int zoom) {
            this.tmapRenderer = tmapRenderer;
            this.mapTileBoardInfo = mapTileBoardInfo;
            this.latitude = latitude;
            this.longitude = longitude;
            this.zoom = zoom;
        }

        @Override
        public void run() {
            this.currentThread = Thread.currentThread();
            try {
                this.tmapRenderer.makeMapTileBoard(this.longitude, this.latitude, this.zoom, this.mapTileBoardInfo, true);
                if (this.mapTileBoardInfo.target == 0) {
                    TMapRenderer.this.mCurrentMapTileBoard = this.mapTileBoardInfo;
                    TMapRenderer.this.invalidate();
                } else if (this.mapTileBoardInfo.target == 1) {
                    TMapRenderer.this.downTileBoard = this.mapTileBoardInfo;
                } else if (this.mapTileBoardInfo.target == -1) {
                    TMapRenderer.this.upTileBoard = this.mapTileBoardInfo;
                }
                if (this.mapTileBoardInfo.isMakeOtherBoard && m_nBufferStep == 4) {
                    MapTileBoardInfo board;
                    if (!this.stopped) {
                        board = new MapTileBoardInfo();
                        this.tmapRenderer.makeMapTileBoard(this.longitude, this.latitude, this.zoom - 1, board, false);
                        TMapRenderer.this.upTileBoard = board;
                    }
                    if (!this.stopped) {
                        board = new MapTileBoardInfo();
                        this.tmapRenderer.makeMapTileBoard(this.longitude, this.latitude, this.zoom + 1, board, false);
                        TMapRenderer.this.downTileBoard = board;
                    }
                    if (!this.stopped) {
                        board = new MapTileBoardInfo();
                        this.tmapRenderer.makeMapTileBoard(this.longitude, this.latitude, this.zoom - 4, board, false);
                        if (TMapRenderer.this.farTileBoardArray.size() > 5) {
                            TMapRenderer.this.farTileBoardArray.remove(0);
                        }
                        TMapRenderer.this.farTileBoardArray.add(board);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentThread = null;
        }

        public void start() {
            if (this.currentThread == null) {
                Thread thread = new Thread(this);
                thread.start();
            }
        }

        public void stop() {
            this.stopped = true;
        }
    }

    public class MakeTileCacheThread
    implements Runnable {
        private volatile Thread currentThread = null;
        private volatile boolean stopped;
        private Date lastCheckTime = new Date();
        private double latitude = 0.0;
        private double longitude = 0.0;
        private int zoom = 0;

        public MakeTileCacheThread(double latitude, double longitude, int zoom) {
            this.latitude = latitude;
            this.longitude = longitude;
            this.zoom = zoom;
        }

        @Override
        public void run() {
            this.currentThread = Thread.currentThread();
            if (m_nBufferStep == 4) {
                if (!this.stopped) {
                    TMapRenderer.this.makeMapTileCache(this.longitude, this.latitude, this.zoom, this, true);
                }
                if (!this.stopped) {
                    TMapRenderer.this.makeMapTileCache(this.longitude, this.latitude, this.zoom - 1, this, false);
                }
            } else if (m_nBufferStep == 3 && !this.stopped) {
                TMapRenderer.this.makeMapTileCache(this.longitude, this.latitude, this.zoom, this, true);
            }
        }

        public void start() {
            if (this.currentThread == null) {
                Thread thread = new Thread(this);
                thread.start();
            }
        }

        public void stop() {
            this.stopped = true;
        }
    }

    public static class DrawParams {
        public boolean isZooming;
        public int zoom;
        public int zoomType;
        public float rotate;
        public float initialMultiTouchZoom;
        public int moveZoomLevel;
        public float centerPointX;
        public float centerPointY;
        public double latitude;
        public double longitude;
        public float tileSize;
        public int srcTileSize;
        public boolean slide;
    }

    private class MapTileBoardInfo {
        public boolean invalidate = false;
        public Bitmap bitmap = null;
        public boolean isBusy = false;
        public boolean isThrash = false;
        public RectF mapPointRect = new RectF();
        public RectF tileIndexRect = new RectF();
        public TMapPoint mapPoint = new TMapPoint(0.0, 0.0);
        public int tileIndexX = 0;
        public int tileIndexY = 0;
        public float zoom = 0.0f;
        public int width = 0;
        public int height = 0;
        public boolean isMakeOtherBoard = true;
        public int target = 0;

        private MapTileBoardInfo() {
        }

        public boolean isOverDistance(double latitude, double longitude) {
            boolean result = false;
            if (this.mapPointRect.contains((float)longitude, (float)latitude)) {
                float distX = this.mapPointRect.centerX() - (float)longitude;
                float distY = this.mapPointRect.centerY() - (float)latitude;
                if (this.mapPointRect.width() / distX < 3.0f || this.mapPointRect.height() / distY < 3.0f) {
                    result = true;
                }
            } else {
                result = true;
            }
            return result;
        }

        public boolean isBoundsCovered(RectF bounds) {
            boolean result = false;
            if (this.mapPointRect.contains(bounds)) {
                result = true;
            }
            return result;
        }
    }

    public class Tile {
        public Bitmap bt = null;
        public float x = 0.0f;
        public float y = 0.0f;

        public Tile(Bitmap b, float _x, float _y) {
            this.bt = b;
            this.x = _x;
            this.y = _y;
        }
    }
}

