/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import com.skt.Tmap.ITileOrigin;
import com.skt.Tmap.MapUtils;
import java.io.File;
import java.text.MessageFormat;

public class TileSourceManager {
    private static String baseUrl = null;

    public static void setBaseUrl(String url) {
        baseUrl = url + "/tms/";
    }

    public static TileOriginTemplate getHDTileSource() {
        return new TileOriginTemplate("Tmap", baseUrl + "1.0.0/hd_tile/{0}/{1}/{2}.png", ".png", 19, 3, 512, 8, 18000);
    }

    public static TileOriginTemplate getENGTileSource() {
        return new TileOriginTemplate("Tmap", baseUrl + "1.0.0/topEnBase/{0}/{1}/{2}.png", ".png", 19, 3, 512, 8, 18000);
    }

    public static TileOriginTemplate getCNTileSource() {
        return new TileOriginTemplate("Tmap", baseUrl + "1.0.0/topCnBase/{0}/{1}/{2}.png", ".png", 19, 3, 512, 8, 18000);
    }

    public static TileOriginTemplate getNomalTileSource() {
        return new TileOriginTemplate("Tmap", baseUrl + "1.0.0/topKoBaseSD/{0}/{1}/{2}.png", ".png", 19, 3, 256, 8, 18000);
    }

    public static TileOriginTemplate getCONTileSource() {
        return new TileOriginTemplate("Tmap", baseUrl + "1.0.0/topKoContrast/{0}/{1}/{2}.png", ".png", 19, 3, 512, 8, 18000);
    }

    public static class TileOriginTemplate
    implements ITileOrigin {
        private int mMaxZoom = 0;
        private int mMinZoom = 0;
        protected int mVIndexOrder = 0;
        protected int mTileSize = 0;
        private String mName = "";
        protected String mUrlToLoad = "";
        private boolean mBaseMapEnable = false;
        private int mBitDensity = 0;
        private int mAvgSize = 0;
        protected MapUtils mMapUtils = null;
        protected String mExt = "";

        public TileOriginTemplate(File file, String name, String url) {
            this(name, url, TileOriginTemplate.ExtDetermine(file, ".jpg"), 18, 1, 512, 16, 20000);
        }

        private static String ExtDetermine(File dir, String defaultExt) {
            String Ext = TileOriginTemplate.findTile(dir);
            return Ext == null ? defaultExt : Ext;
        }

        private static String findTile(File fileDir) {
            if (fileDir.isDirectory()) {
                for (File file : fileDir.listFiles()) {
                    String substring;
                    int extIndex;
                    if (file.isDirectory()) {
                        String findExt = TileOriginTemplate.findTile(file);
                        if (findExt == null) continue;
                        return findExt;
                    }
                    String name = file.getName();
                    if (!name.endsWith(".tile") || (extIndex = (substring = name.substring(0, name.length() - ".tile".length())).lastIndexOf(".")) == -1) continue;
                    return substring.substring(extIndex, substring.length());
                }
            }
            return null;
        }

        public TileOriginTemplate(String name, String url) {
            this(name, url, ".jpg", 18, 1, 512, 16, 20000);
        }

        public TileOriginTemplate(String name, String urlToLoad, String ext, int maxZoom, int minZoom, int tileSize, int bitDensity, int avgSize) {
            this(name, urlToLoad, ext, maxZoom, minZoom, tileSize, bitDensity, avgSize, 0, true);
        }

        public TileOriginTemplate(String name, String urlToLoad, String ext, int maxZoom, int minZoom, int tileSize, int bitDensity, int avgSize, int mapUtilNumber, boolean baseMapEnable) {
            this.mMaxZoom = maxZoom;
            this.mTileSize = tileSize;
            this.mMinZoom = minZoom;
            this.mVIndexOrder = mapUtilNumber == 0 ? 1 : -1;
            this.mUrlToLoad = urlToLoad;
            this.mBaseMapEnable = baseMapEnable;
            this.mExt = ext;
            this.mAvgSize = avgSize;
            this.mMapUtils = new MapUtils();
            this.mName = name;
            this.mBitDensity = bitDensity;
        }

        @Override
        public int getBitDensityData() {
            return this.mBitDensity;
        }

        public int getAverageSize() {
            return this.mAvgSize;
        }

        @Override
        public int getMaximumZoom() {
            return this.mMaxZoom;
        }

        @Override
        public int getMinimumZoom() {
            return this.mMinZoom;
        }

        @Override
        public void setMinimumZoom(int minZoom) {
            this.mMinZoom = minZoom;
        }

        @Override
        public String getFileName() {
            return this.mName;
        }

        @Override
        public int getTileSizeValue() {
            return this.mTileSize;
        }

        @Override
        public String getTileFormatData() {
            return this.mExt;
        }

        public boolean getBaseMapEnable() {
            return this.mBaseMapEnable;
        }

        @Override
        public MapUtils getMapUtils() {
            return this.mMapUtils;
        }

        @Override
        public int getVIndexOrder() {
            return this.mVIndexOrder;
        }

        @Override
        public String getUrlLoadData(int x, int y, int zoom) {
            if (this.mUrlToLoad == null) {
                return null;
            }
            return MessageFormat.format(this.mUrlToLoad, zoom + "", x + "", y + "");
        }

        public String getUrlTemplate() {
            return this.mUrlToLoad;
        }

        @Override
        public boolean isTileDownLoad() {
            return this.mUrlToLoad != null;
        }

        public int hashCode() {
            int value = 31;
            int resultData = 1;
            resultData = 31 * resultData + (this.mName == null ? 0 : this.mName.hashCode());
            return resultData;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TileOriginTemplate other = (TileOriginTemplate)object;
            return !(this.mName == null ? other.mName != null : !this.mName.equals(other.mName));
        }
    }
}

